/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.math;

import com.phloc.commons.CGlobal;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.math.FactorialHelper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class CombinationGenerator<DATATYPE>
implements IIterableIterator<List<DATATYPE>> {
    private final Object[] m_aElements;
    private final int[] m_aIndexResult;
    private final BigInteger m_aTotalCombinations;
    private BigInteger m_aCombinationsLeft;
    private final boolean m_bUseLong;
    private final long m_nTotalCombinations;
    private long m_nCombinationsLeft;

    public CombinationGenerator(@Nonnull @Nonempty List<DATATYPE> list, @Nonnegative int n) {
        if (ContainerHelper.isEmpty(list)) {
            throw new IllegalArgumentException("No elements passed");
        }
        if (n < 0) {
            throw new IllegalArgumentException("To small slot count: " + n);
        }
        if (n > list.size()) {
            throw new IllegalArgumentException("To few elements for specified slots: " + list.size());
        }
        this.m_aElements = list.toArray();
        this.m_aIndexResult = new int[n];
        BigInteger bigInteger = FactorialHelper.getAnyFactorialLinear(this.m_aElements.length);
        BigInteger bigInteger2 = FactorialHelper.getAnyFactorialLinear(n);
        BigInteger bigInteger3 = FactorialHelper.getAnyFactorialLinear(this.m_aElements.length - n);
        this.m_aTotalCombinations = bigInteger.divide(bigInteger2.multiply(bigInteger3));
        this.m_bUseLong = this.m_aTotalCombinations.compareTo(CGlobal.BIGINT_MAX_LONG) < 0;
        this.m_nTotalCombinations = this.m_bUseLong ? this.m_aTotalCombinations.longValue() : -1L;
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.m_aIndexResult.length; ++i) {
            this.m_aIndexResult[i] = i;
        }
        this.m_aCombinationsLeft = this.m_aTotalCombinations;
        this.m_nCombinationsLeft = this.m_nTotalCombinations;
    }

    @Nonnull
    public BigInteger getCombinationsLeft() {
        return this.m_bUseLong ? BigInteger.valueOf(this.m_nCombinationsLeft) : this.m_aCombinationsLeft;
    }

    @Override
    public boolean hasNext() {
        return this.m_bUseLong ? this.m_nCombinationsLeft > 0L : this.m_aCombinationsLeft.compareTo(BigInteger.ZERO) > 0;
    }

    @Nonnull
    public BigInteger getTotalCombinations() {
        return this.m_aTotalCombinations;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<DATATYPE> next() {
        boolean bl;
        boolean bl2 = this.m_bUseLong ? this.m_nCombinationsLeft == this.m_nTotalCombinations : (bl = this.m_aCombinationsLeft.equals(this.m_aTotalCombinations));
        if (!bl) {
            int n = this.m_aElements.length;
            int n2 = this.m_aIndexResult.length;
            int n3 = n2 - 1;
            while (this.m_aIndexResult[n3] == n - n2 + n3) {
                --n3;
            }
            int n4 = n3;
            this.m_aIndexResult[n4] = this.m_aIndexResult[n4] + 1;
            for (int i = n3 + 1; i < n2; ++i) {
                this.m_aIndexResult[i] = this.m_aIndexResult[n3] + i - n3;
            }
        }
        if (this.m_bUseLong) {
            --this.m_nCombinationsLeft;
        } else {
            this.m_aCombinationsLeft = this.m_aCombinationsLeft.subtract(BigInteger.ONE);
        }
        ArrayList arrayList = new ArrayList(this.m_aIndexResult.length);
        for (int n : this.m_aIndexResult) {
            arrayList.add(GenericReflection.uncheckedCast(this.m_aElements[n]));
        }
        return arrayList;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Iterator<List<DATATYPE>> iterator() {
        return this;
    }

    @Nonnull
    public static <DATATYPE> List<List<DATATYPE>> getAllPermutations(@Nonnull @Nonempty List<DATATYPE> list, @Nonnegative int n) {
        ArrayList<List<DATATYPE>> arrayList = new ArrayList<List<DATATYPE>>();
        CombinationGenerator.addAllPermutations(list, n, arrayList);
        return arrayList;
    }

    public static <DATATYPE> void addAllPermutations(@Nonnull @Nonempty List<DATATYPE> list, @Nonnegative int n, @Nonnull Collection<List<DATATYPE>> collection) {
        for (List<DATATYPE> list2 : new CombinationGenerator<DATATYPE>(list, n)) {
            collection.add(list2);
        }
    }
}

