/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert.impl;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.StringParser;
import com.phloc.commons.typeconvert.ITypeConverter;
import com.phloc.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.phloc.commons.typeconvert.ITypeConverterRegistry;
import com.phloc.commons.typeconvert.TypeConverter;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRuleAnySourceFixedDestination;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRuleAssignableSourceFixedDestination;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRuleFixedSourceAnyDestination;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRuleFixedSourceAssignableDestination;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class BaseTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Boolean.class){

            @Override
            public Boolean convert(@Nonnull Object object) {
                return ((Number)object).intValue() != 0;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Character.class, Boolean.class, new ITypeConverter(){

            @Override
            public Boolean convert(@Nonnull Object object) {
                return ((Character)object).charValue() != '\u0000';
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Boolean.class){

            @Override
            public Boolean convert(@Nonnull Object object) {
                return StringParser.parseBoolObj(object, null);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Byte.class){

            @Override
            public Byte convert(@Nonnull Object object) {
                return ((Number)object).byteValue();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Byte.class, new ITypeConverter(){

            @Override
            public Byte convert(@Nonnull Object object) {
                return (Boolean)object != false ? (byte)1 : 0;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Character.class, Byte.class, new ITypeConverter(){

            @Override
            public Byte convert(@Nonnull Object object) {
                return (byte)((Character)object).charValue();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Byte.class){

            @Override
            public Byte convert(@Nonnull Object object) {
                return StringParser.parseByteObj(object, (Byte)null);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Character.class){

            @Override
            public Character convert(@Nonnull Object object) {
                return Character.valueOf((char)((Number)object).intValue());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Character.class, new ITypeConverter(){

            @Override
            public Character convert(@Nonnull Object object) {
                return Character.valueOf((Boolean)object != false ? (char)'\u0001' : '\u0000');
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Character.class){

            @Override
            public Character convert(@Nonnull Object object) {
                String string = object.toString();
                return string.length() == 1 ? Character.valueOf(string.charAt(0)) : null;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Double.class){

            @Override
            public Double convert(@Nonnull Object object) {
                return ((Number)object).doubleValue();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Double.class, new ITypeConverter(){

            @Override
            public Double convert(@Nonnull Object object) {
                return (Boolean)object != false ? 1.0 : 0.0;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Character.class, Double.class, new ITypeConverter(){

            @Override
            public Double convert(@Nonnull Object object) {
                return ((Character)object).charValue();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Double.class){

            @Override
            public Double convert(@Nonnull Object object) {
                return StringParser.parseDoubleObj(object, (Double)null);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Float.class){

            @Override
            public Float convert(@Nonnull Object object) {
                return Float.valueOf(((Number)object).floatValue());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Float.class, new ITypeConverter(){

            @Override
            public Float convert(@Nonnull Object object) {
                return Float.valueOf((Boolean)object != false ? 1.0f : 0.0f);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Character.class, Float.class, new ITypeConverter(){

            @Override
            public Float convert(@Nonnull Object object) {
                return Float.valueOf(((Character)object).charValue());
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Float.class){

            @Override
            public Float convert(@Nonnull Object object) {
                return StringParser.parseFloatObj(object, (Float)null);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Integer.class){

            @Override
            public Integer convert(@Nonnull Object object) {
                return ((Number)object).intValue();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Integer.class, new ITypeConverter(){

            @Override
            public Integer convert(@Nonnull Object object) {
                return (Boolean)object != false ? 1 : 0;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Character.class, Integer.class, new ITypeConverter(){

            @Override
            public Integer convert(@Nonnull Object object) {
                return ((Character)object).charValue();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Integer.class){

            @Override
            public Integer convert(@Nonnull Object object) {
                return StringParser.parseIntObj(object, (Integer)null);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Long.class){

            @Override
            public Long convert(@Nonnull Object object) {
                return ((Number)object).longValue();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Long.class, new ITypeConverter(){

            @Override
            public Long convert(@Nonnull Object object) {
                return (Boolean)object != false ? 1L : 0L;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Character.class, Long.class, new ITypeConverter(){

            @Override
            public Long convert(@Nonnull Object object) {
                return ((Character)object).charValue();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Long.class){

            @Override
            public Long convert(@Nonnull Object object) {
                return StringParser.parseLongObj(object, (Long)null);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Short.class){

            @Override
            public final Short convert(@Nonnull Object object) {
                return ((Number)object).shortValue();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, Short.class, new ITypeConverter(){

            @Override
            public Short convert(@Nonnull Object object) {
                return (Boolean)object != false ? (short)1 : 0;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Character.class, Short.class, new ITypeConverter(){

            @Override
            public Short convert(@Nonnull Object object) {
                return (short)((Character)object).charValue();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Short.class){

            @Override
            public Short convert(@Nonnull Object object) {
                return StringParser.parseShortObj(object, (Short)null);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(String.class){

            @Override
            public String convert(@Nonnull Object object) {
                return object.toString();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(BigInteger.class, BigDecimal.class, new ITypeConverter(){

            @Override
            public BigDecimal convert(@Nonnull Object object) {
                return new BigDecimal((BigInteger)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, BigDecimal.class){

            @Override
            public BigDecimal convert(@Nonnull Object object) {
                return BigDecimal.valueOf(((Number)object).doubleValue());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, BigDecimal.class, new ITypeConverter(){

            @Override
            public BigDecimal convert(@Nonnull Object object) {
                return (Boolean)object != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Character.class, BigDecimal.class, new ITypeConverter(){

            @Override
            public BigDecimal convert(@Nonnull Object object) {
                return BigDecimal.valueOf(((Character)object).charValue());
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(BigDecimal.class){

            @Override
            public BigDecimal convert(@Nonnull Object object) {
                return StringParser.parseBigDecimal(object.toString(), null);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(BigDecimal.class, BigInteger.class, new ITypeConverter(){

            @Override
            public BigInteger convert(@Nonnull Object object) {
                return ((BigDecimal)object).toBigInteger();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, BigInteger.class){

            @Override
            public BigInteger convert(@Nonnull Object object) {
                return BigInteger.valueOf(((Number)object).longValue());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, BigInteger.class, new ITypeConverter(){

            @Override
            public BigInteger convert(@Nonnull Object object) {
                return (Boolean)object != false ? BigInteger.ONE : BigInteger.ZERO;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(Character.class, BigInteger.class, new ITypeConverter(){

            @Override
            public BigInteger convert(@Nonnull Object object) {
                return BigInteger.valueOf(((Character)object).charValue());
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(BigInteger.class){

            @Override
            public BigInteger convert(@Nonnull Object object) {
                return StringParser.parseBigInteger(object.toString(), null);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleFixedSourceAnyDestination(AtomicBoolean.class){

            @Override
            protected Object getInBetweenValue(@Nonnull Object object) {
                return ((AtomicBoolean)object).get();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(AtomicBoolean.class){

            @Override
            public AtomicBoolean convert(@Nonnull Object object) {
                return new AtomicBoolean(TypeConverter.convertIfNecessary(object, Boolean.class));
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleFixedSourceAnyDestination(AtomicInteger.class){

            @Override
            protected Object getInBetweenValue(@Nonnull Object object) {
                return ((AtomicInteger)object).get();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(AtomicInteger.class){

            @Override
            public AtomicInteger convert(@Nonnull Object object) {
                return new AtomicInteger(TypeConverter.convertIfNecessary(object, Integer.class));
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleFixedSourceAnyDestination(AtomicLong.class){

            @Override
            protected Object getInBetweenValue(@Nonnull Object object) {
                return ((AtomicLong)object).get();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(AtomicLong.class){

            @Override
            public AtomicLong convert(@Nonnull Object object) {
                return new AtomicLong(TypeConverter.convertIfNecessary(object, Long.class));
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(StringBuilder.class){

            @Override
            public StringBuilder convert(@Nonnull Object object) {
                if (object instanceof CharSequence) {
                    return new StringBuilder((CharSequence)object);
                }
                return new StringBuilder(TypeConverter.convertIfNecessary(object, String.class));
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(StringBuffer.class){

            @Override
            public StringBuffer convert(@Nonnull Object object) {
                if (object instanceof CharSequence) {
                    return new StringBuffer((CharSequence)object);
                }
                return new StringBuffer(TypeConverter.convertIfNecessary(object, String.class));
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Enum.class, String.class){

            @Override
            @Nonnull
            public String convert(@Nonnull Object object) {
                return object.getClass().getName() + ':' + ((Enum)object).name();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleFixedSourceAssignableDestination(String.class, Enum.class){

            @Override
            public Enum<?> convert(@Nonnull Object object) {
                List<String> list = StringHelper.getExploded(':', (String)object, 2);
                try {
                    Class clazz = GenericReflection.getClassFromName(list.get(0));
                    return Enum.valueOf(clazz, list.get(1));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        });
    }
}

