/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.BooleanCollection;
import org.apache.commons.collections.primitives.adapters.BooleanIteratorIterator;
import org.apache.commons.collections.primitives.adapters.CollectionBooleanCollection;

abstract class AbstractBooleanCollectionCollection
implements Collection<Boolean> {
    AbstractBooleanCollectionCollection() {
    }

    @Nonnull
    protected abstract BooleanCollection getBooleanCollection();

    @Override
    public boolean add(Boolean bl) {
        return this.getBooleanCollection().add(bl);
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> collection) {
        return this.getBooleanCollection().addAll(CollectionBooleanCollection.wrap(collection));
    }

    @Override
    public void clear() {
        this.getBooleanCollection().clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.getBooleanCollection().contains((Boolean)object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getBooleanCollection().containsAll(CollectionBooleanCollection.wrap(collection));
    }

    public String toString() {
        return this.getBooleanCollection().toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getBooleanCollection().isEmpty();
    }

    @Override
    public Iterator<Boolean> iterator() {
        return BooleanIteratorIterator.wrap(this.getBooleanCollection().iterator());
    }

    @Override
    public boolean remove(Object object) {
        return this.getBooleanCollection().removeElement((Boolean)object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getBooleanCollection().removeAll(CollectionBooleanCollection.wrap(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getBooleanCollection().retainAll(CollectionBooleanCollection.wrap(collection));
    }

    @Override
    public int size() {
        return this.getBooleanCollection().size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Boolean[] toArray() {
        boolean[] blArray = this.getBooleanCollection().toArray();
        Boolean[] booleanArray = new Boolean[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            booleanArray[i] = blArray[i];
        }
        return booleanArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Boolean[] booleanArray = this.toArray();
        int n = this.size();
        if (TArray.length < n) {
            return Arrays.copyOf(booleanArray, n, TArray.getClass());
        }
        System.arraycopy(booleanArray, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }
}

