/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.DoubleList;
import org.apache.commons.collections.primitives.decorators.BaseUnmodifiableDoubleList;
import org.apache.commons.collections.primitives.decorators.NonSerializableUnmodifiableDoubleList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public final class UnmodifiableDoubleList
extends BaseUnmodifiableDoubleList
implements Serializable {
    private transient DoubleList m_aProxied;

    UnmodifiableDoubleList(@Nonnull DoubleList doubleList) {
        this.m_aProxied = doubleList;
    }

    @Override
    @Nonnull
    protected DoubleList getProxiedList() {
        return this.m_aProxied;
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m_aProxied);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_aProxied = (DoubleList)objectInputStream.readObject();
    }

    @Nullable
    public static final DoubleList wrap(@Nullable DoubleList doubleList) {
        if (null == doubleList) {
            return null;
        }
        if (doubleList instanceof UnmodifiableDoubleList) {
            return doubleList;
        }
        if (doubleList instanceof Serializable) {
            return new UnmodifiableDoubleList(doubleList);
        }
        return new NonSerializableUnmodifiableDoubleList(doubleList);
    }
}

