/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work.api;

import java.util.HashSet;
import java.util.Set;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="queue")
public class WorkQueueDescriptor {
    @XNode(value="@id")
    public String id;
    @XNode(value="name")
    public String name;
    @XNode(value="maxThreads")
    public int maxThreads;
    @XNode(value="usePriority")
    public boolean usePriority;
    @XNode(value="clearCompletedAfterSeconds")
    public int clearCompletedAfterSeconds = 3600;
    @XNodeList(value="category", type=HashSet.class, componentType=String.class)
    public Set<String> categories;

    public WorkQueueDescriptor clone() {
        WorkQueueDescriptor o = new WorkQueueDescriptor();
        o.id = this.id;
        o.name = this.name;
        o.maxThreads = this.maxThreads;
        o.usePriority = this.usePriority;
        o.clearCompletedAfterSeconds = this.clearCompletedAfterSeconds;
        o.categories = new HashSet<String>(this.categories);
        return o;
    }

    public void merge(WorkQueueDescriptor other) {
        this.name = other.name;
        this.maxThreads = other.maxThreads;
        this.usePriority = other.usePriority;
        this.clearCompletedAfterSeconds = other.clearCompletedAfterSeconds;
        this.categories.addAll(other.categories);
    }
}

