/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.core.impl.AbstractRunner;
import org.nuxeo.ecm.platform.routing.core.impl.ElementRunner;

public class ParallelRunner
extends AbstractRunner
implements ElementRunner {
    @Override
    public void run(CoreSession session, DocumentRouteElement element) {
        List<DocumentRouteElement> children = this.getChildrenElement(session, element);
        if (children.isEmpty()) {
            element.setRunning(session);
            element.setDone(session);
            return;
        }
        if (!element.isRunning()) {
            element.setRunning(session);
            boolean someChildrenNotDone = false;
            for (DocumentRouteElement child : children) {
                child.run(session);
                if (child.isDone()) continue;
                someChildrenNotDone = true;
            }
            if (!someChildrenNotDone) {
                element.setDone(session);
            }
            return;
        }
        boolean someChildrenNotDone = false;
        for (DocumentRouteElement child : children) {
            if (child.isDone()) continue;
            child.run(session);
            if (child.isDone()) continue;
            someChildrenNotDone = true;
        }
        if (!someChildrenNotDone) {
            element.setDone(session);
        }
    }
}

