/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.TimerContext;
import com.yammer.metrics.stats.Snapshot;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class Timer
implements Metered,
Sampling,
Summarizable {
    private final TimeUnit durationUnit;
    private final TimeUnit rateUnit;
    private final Meter meter;
    private final Histogram histogram = new Histogram(Histogram.SampleType.BIASED);
    private final Clock clock;

    Timer(TimeUnit durationUnit, TimeUnit rateUnit, Clock clock) {
        this.durationUnit = durationUnit;
        this.rateUnit = rateUnit;
        this.meter = new Meter("calls", rateUnit, clock);
        this.clock = clock;
        this.clear();
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    @Override
    public TimeUnit getRateUnit() {
        return this.rateUnit;
    }

    public void clear() {
        this.histogram.clear();
    }

    public void update(long duration, TimeUnit unit) {
        this.update(unit.toNanos(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    public TimerContext time() {
        return new TimerContext(this, this.clock);
    }

    @Override
    public long getCount() {
        return this.histogram.getCount();
    }

    @Override
    public double getFifteenMinuteRate() {
        return this.meter.getFifteenMinuteRate();
    }

    @Override
    public double getFiveMinuteRate() {
        return this.meter.getFiveMinuteRate();
    }

    @Override
    public double getMeanRate() {
        return this.meter.getMeanRate();
    }

    @Override
    public double getOneMinuteRate() {
        return this.meter.getOneMinuteRate();
    }

    @Override
    public double getMax() {
        return this.convertFromNS(this.histogram.getMax());
    }

    @Override
    public double getMin() {
        return this.convertFromNS(this.histogram.getMin());
    }

    @Override
    public double getMean() {
        return this.convertFromNS(this.histogram.getMean());
    }

    @Override
    public double getStdDev() {
        return this.convertFromNS(this.histogram.getStdDev());
    }

    @Override
    public double getSum() {
        return this.convertFromNS(this.histogram.getSum());
    }

    @Override
    public Snapshot getSnapshot() {
        double[] values = this.histogram.getSnapshot().getValues();
        double[] converted = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            converted[i] = this.convertFromNS(values[i]);
        }
        return new Snapshot(converted);
    }

    @Override
    public String getEventType() {
        return this.meter.getEventType();
    }

    private void update(long duration) {
        if (duration >= 0L) {
            this.histogram.update(duration);
            this.meter.mark();
        }
    }

    private double convertFromNS(double ns) {
        return ns / (double)TimeUnit.NANOSECONDS.convert(1L, this.durationUnit);
    }
}

