/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.automation.AdapterNotFoundException;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.CompiledChain;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.TypeAdapter;
import org.nuxeo.ecm.automation.core.impl.AdapterKeyedRegistry;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.CompiledChainImpl;
import org.nuxeo.ecm.automation.core.impl.OperationTypeImpl;
import org.nuxeo.ecm.automation.core.impl.OperationTypeRegistry;
import org.nuxeo.ecm.automation.core.impl.TypeAdapterKey;

public class OperationServiceImpl
implements AutomationService {
    protected final OperationTypeRegistry operations;
    protected Map<String, CompiledChainImpl> compiledChains = new HashMap<String, CompiledChainImpl>();
    protected AdapterKeyedRegistry adapters;

    public OperationServiceImpl() {
        this.operations = new OperationTypeRegistry();
        this.adapters = new AdapterKeyedRegistry();
    }

    @Override
    public Object run(OperationContext ctx, String chainId) throws Exception {
        ChainTypeImpl chain = (ChainTypeImpl)this.getOperation(chainId);
        return this.run(ctx, chain, chain.getChainParameters());
    }

    @Override
    public Object run(OperationContext ctx, OperationChain chain) throws Exception {
        Map<String, Object> chainParameters = Collections.emptyMap();
        if (!chain.getChainParameters().isEmpty()) {
            chainParameters = chain.getChainParameters();
        }
        ChainTypeImpl chainType = new ChainTypeImpl(this, chain);
        return this.run(ctx, chainType, chainParameters);
    }

    @Override
    public Object run(OperationContext ctx, String operationId, Map<String, Object> runtimeParameters) throws Exception {
        OperationType type = this.getOperation(operationId);
        return this.run(ctx, type, runtimeParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(OperationContext ctx, OperationType operationType, Map<String, Object> params) throws Exception {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        ctx.put("ChainParameters", (Object)params);
        if (params != null && !params.isEmpty()) {
            ctx.put("ChainParameters", (Object)params);
        }
        try {
            CompiledChainImpl chain;
            Class<Void> inputType;
            Object input = ctx.getInput();
            Class<Void> clazz = inputType = input == null ? Void.TYPE : input.getClass();
            if (ChainTypeImpl.class.isAssignableFrom(operationType.getClass())) {
                chain = this.compiledChains.get(operationType.getId());
                if (chain == null) {
                    chain = (CompiledChainImpl)operationType.newInstance(ctx, params);
                    if (this.hasOperation(operationType.getId())) {
                        this.compiledChains.put(operationType.getId(), chain);
                    }
                }
            } else {
                chain = CompiledChainImpl.buildChain(inputType, OperationServiceImpl.toParams(operationType.getId()));
            }
            Object ret = chain.invoke(ctx);
            if (ctx.getCoreSession() != null && ctx.isCommit()) {
                ctx.getCoreSession().save();
            }
            Object object = ret;
            return object;
        }
        finally {
            ctx.dispose();
        }
    }

    public static OperationParameters[] toParams(String ... ids) {
        OperationParameters[] operationParameters = new OperationParameters[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            operationParameters[i] = new OperationParameters(ids[i]);
        }
        return operationParameters;
    }

    @Override
    @Deprecated
    public synchronized void putOperationChain(OperationChain chain) throws OperationException {
        this.putOperationChain(chain, false);
    }

    @Override
    @Deprecated
    public synchronized void putOperationChain(OperationChain chain, boolean replace) throws OperationException {
        ChainTypeImpl docChainType = new ChainTypeImpl(this, chain);
        this.putOperation(docChainType, replace);
    }

    @Override
    @Deprecated
    public synchronized void removeOperationChain(String id) {
        OperationChain chain = new OperationChain(id);
        ChainTypeImpl docChainType = new ChainTypeImpl(this, chain);
        this.operations.removeContribution(docChainType);
    }

    @Override
    @Deprecated
    public OperationChain getOperationChain(String id) throws OperationNotFoundException {
        ChainTypeImpl chain = (ChainTypeImpl)this.getOperation(id);
        return chain.getChain();
    }

    @Override
    @Deprecated
    public List<OperationChain> getOperationChains() {
        ArrayList<ChainTypeImpl> chainsType = new ArrayList<ChainTypeImpl>();
        ArrayList<OperationChain> chains = new ArrayList<OperationChain>();
        for (OperationType operationType : this.operations.lookup().values()) {
            if (!(operationType instanceof ChainTypeImpl)) continue;
            chainsType.add((ChainTypeImpl)operationType);
        }
        for (ChainTypeImpl chainType : chainsType) {
            chains.add(chainType.getChain());
        }
        return chains;
    }

    public synchronized void flushCompiledChains() {
        this.compiledChains.clear();
    }

    @Override
    public void putOperation(Class<?> type) throws OperationException {
        OperationTypeImpl op = new OperationTypeImpl(this, type);
        this.putOperation(op, false);
    }

    @Override
    public void putOperation(Class<?> type, boolean replace) throws OperationException {
        this.putOperation(type, replace, null);
    }

    @Override
    public void putOperation(Class<?> type, boolean replace, String contributingComponent) throws OperationException {
        OperationTypeImpl op = new OperationTypeImpl(this, type, contributingComponent);
        this.putOperation(op, replace);
    }

    public synchronized void putOperation(OperationType op, boolean replace) throws OperationException {
        this.operations.addContribution(op, replace);
    }

    @Override
    public synchronized void removeOperation(Class<?> key) {
        OperationType op = this.operations.getOperationType(key);
        if (op != null) {
            this.operations.removeContribution(op);
        }
    }

    @Override
    public OperationType[] getOperations() {
        Collection<OperationType> values = this.operations.lookup().values();
        return values.toArray(new OperationType[values.size()]);
    }

    @Override
    public OperationType getOperation(String id) throws OperationNotFoundException {
        OperationType op = this.operations.lookup().get(id);
        if (op == null) {
            throw new OperationNotFoundException("No operation was bound on ID: " + id);
        }
        return op;
    }

    @Override
    public boolean hasOperation(String id) {
        OperationType op = this.operations.lookup().get(id);
        return op != null;
    }

    @Override
    public CompiledChain compileChain(Class<?> inputType, OperationChain chain) throws Exception, InvalidChainException {
        List<OperationParameters> ops = chain.getOperations();
        return this.compileChain(inputType, ops.toArray(new OperationParameters[ops.size()]));
    }

    @Override
    public CompiledChain compileChain(Class<?> inputType, OperationParameters ... operations) throws Exception, InvalidChainException {
        return CompiledChainImpl.buildChain(this, inputType == null ? Void.TYPE : inputType, operations);
    }

    @Override
    public void putTypeAdapter(Class<?> accept, Class<?> produce, TypeAdapter adapter) {
        this.adapters.put(new TypeAdapterKey(accept, produce), adapter);
    }

    @Override
    public void removeTypeAdapter(Class<?> accept, Class<?> produce) {
        this.adapters.remove(new TypeAdapterKey(accept, produce));
    }

    @Override
    public TypeAdapter getTypeAdapter(Class<?> accept, Class<?> produce) {
        return (TypeAdapter)this.adapters.get(new TypeAdapterKey(accept, produce));
    }

    @Override
    public boolean isTypeAdaptable(Class<?> typeToAdapt, Class<?> targetType) {
        return this.getTypeAdapter(typeToAdapt, targetType) != null;
    }

    @Override
    public <T> T getAdaptedValue(OperationContext ctx, Object toAdapt, Class<?> targetType) throws Exception {
        if (toAdapt == null) {
            return null;
        }
        Class<?> toAdaptClass = toAdapt.getClass();
        if (targetType.isPrimitive() && (targetType = OperationServiceImpl.getTypeForPrimitive(targetType)).isAssignableFrom(toAdaptClass)) {
            return (T)toAdapt;
        }
        TypeAdapter adapter = this.getTypeAdapter(toAdaptClass, targetType);
        if (adapter == null) {
            if (toAdapt instanceof JsonNode) {
                ObjectMapper mapper = new ObjectMapper();
                return (T)mapper.convertValue(toAdapt, targetType);
            }
            throw new AdapterNotFoundException("No type adapter found for input: " + toAdapt.getClass() + " and output " + targetType, ctx);
        }
        return (T)adapter.getAdaptedValue(ctx, toAdapt);
    }

    @Override
    public List<OperationDocumentation> getDocumentation() throws OperationException {
        ArrayList<OperationDocumentation> result = new ArrayList<OperationDocumentation>();
        Collection<OperationType> ops = this.operations.lookup().values();
        for (OperationType ot : ops.toArray(new OperationType[ops.size()])) {
            result.add(ot.getDocumentation());
        }
        Collections.sort(result);
        return result;
    }

    public static Class<?> getTypeForPrimitive(Class<?> primitiveType) {
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        return primitiveType;
    }
}

