/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.OutputCollector;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.impl.InvokableIteratorMethod;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;

public class OperationTypeImpl
implements OperationType {
    protected AutomationService service;
    protected String id;
    protected Class<?> type;
    protected Map<String, Field> params;
    protected List<InvokableMethod> methods;
    protected List<Field> injectableFields;
    protected String contributingComponent;

    public OperationTypeImpl(AutomationService service, Class<?> type) {
        this(service, type, null);
    }

    public OperationTypeImpl(AutomationService service, Class<?> type, String contributingComponent) {
        Operation anno = type.getAnnotation(Operation.class);
        if (anno == null) {
            throw new IllegalArgumentException("Invalid operation class: " + type + ". No @Operation annotation found on class.");
        }
        this.service = service;
        this.type = type;
        this.contributingComponent = contributingComponent;
        this.id = anno.id();
        if (this.id.length() == 0) {
            this.id = type.getName();
        }
        this.params = new HashMap<String, Field>();
        this.methods = new ArrayList<InvokableMethod>();
        this.injectableFields = new ArrayList<Field>();
        this.initMethods();
        this.initFields();
    }

    @Override
    public AutomationService getService() {
        return this.service;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    protected void initMethods() {
        for (Method method : this.type.getMethods()) {
            OperationMethod anno = method.getAnnotation(OperationMethod.class);
            if (anno == null) continue;
            InvokableMethod im = new InvokableMethod(this, method, anno);
            this.methods.add(im);
            if (anno.collector() == OutputCollector.class) continue;
            im = new InvokableIteratorMethod(this, method, anno);
            this.methods.add(im);
        }
        Collections.sort(this.methods);
    }

    protected void initFields() {
        for (Field field : this.type.getDeclaredFields()) {
            Param param = field.getAnnotation(Param.class);
            if (param != null) {
                field.setAccessible(true);
                this.params.put(param.name(), field);
                continue;
            }
            if (!field.isAnnotationPresent(Context.class)) continue;
            field.setAccessible(true);
            this.injectableFields.add(field);
        }
    }

    @Override
    public Object newInstance(OperationContext ctx, Map<String, Object> args) throws Exception {
        Object obj = this.type.newInstance();
        this.inject(ctx, args, obj);
        return obj;
    }

    public void inject(OperationContext ctx, Map<String, Object> args, Object target) throws Exception {
        Object obj;
        for (Map.Entry<String, Field> entry : this.params.entrySet()) {
            obj = args.get(entry.getKey());
            if (obj instanceof Expression) {
                obj = ((Expression)obj).eval(ctx);
            }
            if (obj == null && ctx.containsKey("ChainParameters")) {
                obj = ((Map)ctx.get("ChainParameters")).get(entry.getKey());
            }
            if (obj == null) {
                if (!entry.getValue().getAnnotation(Param.class).required()) continue;
                throw new OperationException("Failed to inject parameter '" + entry.getKey() + "'. Seems it is missing from the context. Operation: " + this.getId());
            }
            Field field = entry.getValue();
            Class<?> cl = obj.getClass();
            if (!field.getType().isAssignableFrom(cl)) {
                obj = this.service.getAdaptedValue(ctx, obj, field.getType());
            }
            field.set(target, obj);
        }
        for (Field field : this.injectableFields) {
            obj = ctx.getAdapter(field.getType());
            field.set(target, obj);
        }
    }

    @Override
    public InvokableMethod[] getMethodsMatchingInput(Class<?> in) {
        ArrayList<Match> result = new ArrayList<Match>();
        for (InvokableMethod m : this.methods) {
            int priority = m.inputMatch(in);
            if (priority <= 0) continue;
            result.add(new Match(m, priority));
        }
        int size = result.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return new InvokableMethod[]{((Match)result.get((int)0)).method};
        }
        Collections.sort(result);
        InvokableMethod[] ar = new InvokableMethod[result.size()];
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = ((Match)result.get((int)i)).method;
        }
        return ar;
    }

    @Override
    public OperationDocumentation getDocumentation() {
        Operation op = this.type.getAnnotation(Operation.class);
        OperationDocumentation doc = new OperationDocumentation(op.id());
        doc.label = op.label();
        doc.requires = op.requires();
        doc.category = op.category();
        doc.since = op.since();
        if (doc.requires.length() == 0) {
            doc.requires = null;
        }
        if (doc.label.length() == 0) {
            doc.label = doc.id;
        }
        doc.description = op.description();
        LinkedList<OperationDocumentation.Param> paramsAccumulator = new LinkedList<OperationDocumentation.Param>();
        for (Field field : this.params.values()) {
            Param p = field.getAnnotation(Param.class);
            OperationDocumentation.Param param = new OperationDocumentation.Param();
            param.name = p.name();
            param.type = this.getParamDocumentationType(field.getType());
            param.widget = p.widget();
            if (param.widget.length() == 0) {
                param.widget = null;
            }
            param.order = p.order();
            param.values = p.values();
            param.isRequired = p.required();
            paramsAccumulator.add(param);
        }
        Collections.sort(paramsAccumulator);
        doc.params = paramsAccumulator.toArray(new OperationDocumentation.Param[paramsAccumulator.size()]);
        ArrayList<String> result = new ArrayList<String>(this.methods.size() * 2);
        HashSet<String> collectedSigs = new HashSet<String>();
        for (InvokableMethod m : this.methods) {
            String in = this.getParamDocumentationType(m.getInputType(), m.isIterable());
            String out = this.getParamDocumentationType(m.getOutputType());
            String sigKey = in + ":" + out;
            if (collectedSigs.contains(sigKey)) continue;
            result.add(in);
            result.add(out);
            collectedSigs.add(sigKey);
        }
        doc.signature = result.toArray(new String[result.size()]);
        return doc;
    }

    @Override
    public String getContributingComponent() {
        return this.contributingComponent;
    }

    protected String getParamDocumentationType(Class<?> type) {
        return this.getParamDocumentationType(type, false);
    }

    protected String getParamDocumentationType(Class<?> type, boolean isIterable) {
        String t = DocumentModel.class.isAssignableFrom(type) || DocumentRef.class.isAssignableFrom(type) ? (isIterable ? "documents" : "document") : (DocumentModelList.class.isAssignableFrom(type) || DocumentRefList.class.isAssignableFrom(type) ? "documents" : (BlobList.class.isAssignableFrom(type) ? "bloblist" : (Blob.class.isAssignableFrom(type) ? (isIterable ? "bloblist" : "blob") : (URL.class.isAssignableFrom(type) ? "resource" : (Calendar.class.isAssignableFrom(type) ? "date" : type.getSimpleName().toLowerCase())))));
        return t;
    }

    public String toString() {
        return "OperationTypeImpl [id=" + this.id + ", type=" + this.type + ", params=" + this.params + "]";
    }

    @Override
    public List<InvokableMethod> getMethods() {
        return this.methods;
    }

    static class Match
    implements Comparable<Match> {
        protected InvokableMethod method;
        int priority;

        Match(InvokableMethod method, int priority) {
            this.method = method;
            this.priority = priority;
        }

        @Override
        public int compareTo(Match o) {
            return o.priority - this.priority;
        }

        public String toString() {
            return "Match(" + this.method + ", " + this.priority + ")";
        }
    }
}

