/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.runtime.transaction.TransactionRuntimeException;

@Operation(id="Context.RunDocumentOperationInNewTx", category="Execution Flow", label="Run Document Chain in new Tx", description="Run an operation chain in a separate tx. The 'parameters' injected are accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.")
public class RunInNewTransaction {
    public static final String ID = "Context.RunDocumentOperationInNewTx";
    private static final Log log = LogFactory.getLog(RunInNewTransaction.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Param(name="id")
    protected String chainId;
    @Param(name="isolate", required=false, values={"false"})
    protected boolean isolate = false;
    @Param(name="rollbackGlobalOnError", required=false, values={"false"})
    protected boolean rollbackGlobalOnError = false;
    @Param(name="parameters", required=false)
    protected Properties chainParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public void run() throws Exception {
        if (TransactionHelper.isTransactionMarkedRollback()) {
            return;
        }
        Map<String, Object> vars = this.isolate ? new HashMap<String, Object>(this.ctx.getVars()) : this.ctx.getVars();
        OperationContext subctx = new OperationContext(this.ctx.getCoreSession(), vars);
        subctx.setInput(this.ctx.getInput());
        TransactionManager transactionManager = TransactionHelper.lookupTransactionManager();
        Transaction globalTx = transactionManager.suspend();
        try {
            TransactionHelper.startTransaction();
            try {
                this.service.run(subctx, this.chainId, this.chainParameters);
            }
            catch (Exception e) {
                this.handleRollbackOnlyOnGlobal(globalTx, e);
            }
            finally {
                try {
                    TransactionHelper.commitOrRollbackTransaction();
                }
                catch (TransactionRuntimeException e) {
                    this.handleRollbackOnlyOnGlobal(globalTx, e);
                }
            }
        }
        finally {
            transactionManager.resume(globalTx);
        }
    }

    private void handleRollbackOnlyOnGlobal(Transaction mainTx, Throwable e) throws SystemException, OperationException {
        TransactionHelper.setTransactionRollbackOnly();
        if (this.rollbackGlobalOnError) {
            mainTx.setRollbackOnly();
            throw new OperationException("Catching error on new transaction, rollbacking global tx", e);
        }
        log.error((Object)"Caught error on new transaction, continuing global tx", e);
    }
}

