/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.model.PropertyException;

public class DataModelProperties
extends Properties {
    protected boolean loaded = false;
    protected Map<String, Serializable> properties = new HashMap<String, Serializable>();

    public DataModelProperties() {
    }

    public DataModelProperties(DataModel dm) throws PropertyException {
        this.addDataModel(dm);
    }

    public DataModelProperties(List<DataModel> dms) throws PropertyException {
        for (DataModel dm : dms) {
            this.addDataModel(dm);
        }
    }

    public void addDataModel(DataModel dm) throws PropertyException {
        for (Map.Entry entry : dm.getMap().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.contains(":")) {
                key = dm.getSchema() + ":" + key;
            }
            this.properties.put(key, (Serializable)entry.getValue());
        }
    }

    public Map<String, Serializable> getMap() {
        return this.properties;
    }
}

