/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.api.operation;

import java.util.HashMap;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;

@Operation(id="Workflow.ResumeNodeOperation", category="Workflow Context", label="Resume workflow", requires="Workflow", description="Resumes a route instance on a give node.")
public class ResumeNodeOperation {
    public static final String ID = "Workflow.ResumeNodeOperation";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Param(name="workflowInstanceId")
    protected String workflowInstanceId;
    @Param(name="nodeId", required=false)
    protected String nodeId;
    @Context
    protected DocumentRoutingService documentRoutingService;

    @OperationMethod
    public void resumeWorkflow() throws ClientException {
        if (this.nodeId == null) {
            this.nodeId = (String)this.ctx.get((Object)"nodeId");
        }
        if (this.nodeId == null) {
            throw new ClientException("Can not resume workflow instance with id " + this.workflowInstanceId + ". No current node in the context");
        }
        this.documentRoutingService.resumeInstance(this.workflowInstanceId, this.nodeId, new HashMap(), null, this.session);
    }
}

