/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.scripting.DateWrapper;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.impl.DocumentRouteElementImpl;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRouteImpl;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRunner;
import org.nuxeo.ecm.platform.routing.core.impl.GraphVariablesUtil;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.runtime.api.Framework;

public class GraphNodeImpl
extends DocumentRouteElementImpl
implements GraphNode {
    private static final Log log = LogFactory.getLog(GraphNodeImpl.class);
    private static final long serialVersionUID = 1L;
    protected final GraphRouteImpl graph;
    protected GraphNode.State localState;
    protected List<GraphNode.Transition> inputTransitions;
    protected List<GraphNode.Transition> outputTransitions;
    protected List<GraphNode.Button> taskButtons;

    public GraphNodeImpl(DocumentModel doc, GraphRouteImpl graph) {
        super(doc, new GraphRunner());
        this.graph = graph;
        this.inputTransitions = new ArrayList<GraphNode.Transition>(2);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getId()).toString();
    }

    protected boolean getBoolean(String propertyName) {
        return Boolean.TRUE.equals(this.getProperty(propertyName));
    }

    protected void incrementProp(String prop) {
        try {
            Long count = (Long)this.getProperty(prop);
            if (count == null) {
                count = 0L;
            }
            this.document.setPropertyValue(prop, (Serializable)Long.valueOf(count + 1L));
            this.saveDocument();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected CoreSession getSession() {
        return this.document.getCoreSession();
    }

    protected void saveDocument() throws ClientException {
        this.getSession().saveDocument(this.document);
    }

    @Override
    public String getId() {
        return (String)this.getProperty("rnode:nodeId");
    }

    @Override
    public GraphNode.State getState() {
        try {
            if (this.localState != null) {
                return this.localState;
            }
            String s = this.document.getCurrentLifeCycleState();
            return GraphNode.State.fromString(s);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void setState(GraphNode.State state) {
        try {
            if (state == null) {
                throw new NullPointerException("null state");
            }
            String lc = state.getLifeCycleState();
            if (lc == null) {
                this.localState = state;
                return;
            }
            this.localState = null;
            String oldLc = this.document.getCurrentLifeCycleState();
            if (lc.equals(oldLc)) {
                return;
            }
            this.document.followTransition(state.getTransition());
            this.saveDocument();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isStart() {
        return this.getBoolean("rnode:start");
    }

    @Override
    public boolean isStop() {
        return this.getBoolean("rnode:stop");
    }

    @Override
    public void setCanceled() {
        log.debug((Object)("Canceling " + this));
        this.incrementProp("rnode:canceled");
    }

    @Override
    public long getCanceledCount() {
        Long c = (Long)this.getProperty("rnode:canceled");
        return c == null ? 0L : c;
    }

    @Override
    public boolean isMerge() {
        String merge = (String)this.getProperty("rnode:merge");
        return StringUtils.isNotEmpty((String)merge);
    }

    @Override
    public String getInputChain() {
        return (String)this.getProperty("rnode:inputChain");
    }

    @Override
    public String getOutputChain() {
        return (String)this.getProperty("rnode:outputChain");
    }

    @Override
    public boolean hasTask() {
        return this.getBoolean("rnode:hasTask");
    }

    @Override
    public List<String> getTaskAssignees() {
        return (List)this.getProperty("rnode:taskAssignees");
    }

    public String getTaskAssigneesVar() {
        return (String)this.getProperty("rnode:taskAssigneesExpr");
    }

    @Override
    public Date getTaskDueDate() {
        Calendar cal = (Calendar)this.getProperty("rnode:taskDueDate");
        return cal == null ? null : cal.getTime();
    }

    @Override
    public String getTaskDirective() {
        return (String)this.getProperty("rnode:taskDirective");
    }

    @Override
    public String getTaskAssigneesPermission() {
        return (String)this.getProperty("rnode:taskAssigneesPermission");
    }

    @Override
    public String getTaskLayout() {
        return (String)this.getProperty("rnode:taskLayout");
    }

    @Override
    public String getTaskNotificationTemplate() {
        return (String)this.getProperty("rnode:taskNotificationTemplate");
    }

    @Override
    public String getTaskDueDateExpr() {
        return (String)this.getProperty("rnode:taskDueDateExpr");
    }

    @Override
    public void starting() {
        try {
            for (GraphNode.Transition t : this.inputTransitions) {
                t.setResult(false);
                this.getSession().saveDocument(t.source.getDocument());
            }
            this.incrementProp("rnode:count");
            this.document.setPropertyValue("rnode:startDate", (Serializable)Calendar.getInstance());
            this.saveDocument();
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void ending() {
        try {
            this.document.setPropertyValue("rnode:endDate", (Serializable)Calendar.getInstance());
            this.saveDocument();
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public Map<String, Serializable> getVariables() {
        return GraphVariablesUtil.getVariables(this.document, "rnode:variablesFacet");
    }

    public void setVariables(Map<String, Serializable> map) {
        GraphVariablesUtil.setVariables(this.document, "rnode:variablesFacet", map);
    }

    @Override
    public void setAllVariables(Map<String, Object> map) {
        Serializable oldValue;
        Serializable value;
        String key;
        Map<String, Serializable> graphVariables = this.graph.getVariables();
        Map<String, Serializable> nodeVariables = this.getVariables();
        boolean changedNodeVariables = false;
        boolean changedGraphVariables = false;
        if (map.get("NodeVariables") != null) {
            for (Map.Entry es : ((Map)map.get("NodeVariables")).entrySet()) {
                key = (String)es.getKey();
                value = (Serializable)es.getValue();
                if (!nodeVariables.containsKey(key) || GraphNodeImpl.equality(value, oldValue = nodeVariables.get(key))) continue;
                changedNodeVariables = true;
                nodeVariables.put(key, value);
            }
        }
        if (map.get("WorkflowVariables") != null) {
            for (Map.Entry es : ((Map)map.get("WorkflowVariables")).entrySet()) {
                key = (String)es.getKey();
                value = (Serializable)es.getValue();
                if (!graphVariables.containsKey(key) || GraphNodeImpl.equality(value, oldValue = graphVariables.get(key))) continue;
                changedGraphVariables = true;
                graphVariables.put(key, value);
            }
        }
        if (changedNodeVariables) {
            this.setVariables(nodeVariables);
        }
        if (changedGraphVariables) {
            this.graph.setVariables(graphVariables);
        }
    }

    public static boolean equality(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof List && o2.getClass().isArray()) {
            return Arrays.equals(((List)o1).toArray(), (Object[])o2);
        }
        if (o1.getClass().isArray() && o2 instanceof List) {
            return Arrays.equals((Object[])o1, ((List)o2).toArray());
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        return o1.equals(o2);
    }

    protected OperationContext getContext() {
        OperationContext context = new OperationContext(this.getSession());
        context.putAll(this.getWorkflowContextualInfo(false));
        context.setCommit(false);
        DocumentModelList documents = this.graph.getAttachedDocumentModels();
        context.setInput((Object)documents);
        return context;
    }

    @Override
    public Map<String, Serializable> getWorkflowContextualInfo(boolean detached) {
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        context.put("WorkflowVariables", (Serializable)((Object)this.graph.getVariables()));
        context.put("workflowInitiator", (Serializable)((Object)this.getWorkflowInitiator()));
        context.put("workflowStartTime", this.getWorkflowStartTime());
        DocumentModelList documents = this.graph.getAttachedDocumentModels();
        if (detached) {
            for (DocumentModel documentModel : documents) {
                try {
                    documentModel.detach(true);
                }
                catch (ClientException e) {
                    log.error((Object)e);
                    throw new ClientRuntimeException((Throwable)e);
                }
            }
        }
        context.put("workflowDocuments", (Serializable)documents);
        context.put("documents", (Serializable)documents);
        String button = (String)this.getProperty("rnode:button");
        Map<String, Serializable> nodeVariables = this.getVariables();
        nodeVariables.put("button", (Serializable)((Object)button));
        context.put("NodeVariables", (Serializable)((Object)nodeVariables));
        context.put("nodeId", (Serializable)((Object)this.getId()));
        String state = this.getState().name().toLowerCase();
        context.put("nodeState", (Serializable)((Object)state));
        context.put("state", (Serializable)((Object)state));
        context.put("nodeStartTime", this.getNodeStartTime());
        context.put("nodeEndTime", this.getNodeEndTime());
        context.put("nodeLastActor", (Serializable)((Object)this.getNodeLastActor()));
        context.put("comment", (Serializable)((Object)""));
        return context;
    }

    protected String getWorkflowInitiator() {
        try {
            return (String)((Object)this.graph.getDocument().getPropertyValue("docri:initiator"));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected Calendar getWorkflowStartTime() {
        try {
            return (Calendar)this.graph.getDocument().getPropertyValue("dc:created");
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected Calendar getNodeStartTime() {
        try {
            return (Calendar)this.getDocument().getPropertyValue("rnode:startDate");
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected Calendar getNodeEndTime() {
        try {
            return (Calendar)this.getDocument().getPropertyValue("rnode:endDate");
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected String getNodeLastActor() {
        try {
            return (String)((Object)this.getDocument().getPropertyValue("rnode:lastActor"));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void executeChain(String chainId) throws DocumentRouteException {
        this.executeChain(chainId, null);
    }

    @Override
    public void executeTransitionChain(GraphNode.Transition transition) throws DocumentRouteException {
        this.executeChain(transition.chain, transition.id);
    }

    public void executeChain(String chainId, String transitionId) throws DocumentRouteException {
        if (StringUtils.isEmpty((String)chainId)) {
            return;
        }
        OperationContext context = this.getContext();
        if (transitionId != null) {
            context.put("transition", (Object)transitionId);
        }
        AutomationService automationService = (AutomationService)Framework.getLocalService(AutomationService.class);
        try {
            automationService.run(context, chainId);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocumentRouteException("Error running chain: " + chainId, (Throwable)e);
        }
        this.setAllVariables((Map<String, Object>)context);
    }

    @Override
    public void initAddInputTransition(GraphNode.Transition transition) {
        this.inputTransitions.add(transition);
    }

    protected List<GraphNode.Transition> computeOutputTransitions() {
        try {
            ListProperty props = (ListProperty)this.document.getProperty("rnode:transitions");
            ArrayList<GraphNode.Transition> trans = new ArrayList<GraphNode.Transition>(props.size());
            for (Property p : props) {
                trans.add(new GraphNode.Transition(this, p));
            }
            return trans;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<GraphNode.Transition> getOutputTransitions() {
        if (this.outputTransitions == null) {
            this.outputTransitions = this.computeOutputTransitions();
        }
        return this.outputTransitions;
    }

    @Override
    public List<GraphNode.Transition> evaluateTransitions() throws DocumentRouteException {
        try {
            ArrayList<GraphNode.Transition> trueTrans = new ArrayList<GraphNode.Transition>();
            OperationContext context = this.getContext();
            for (GraphNode.Transition t : this.getOutputTransitions()) {
                context.put("transition", (Object)t.id);
                Expression expr = Scripting.newExpression((String)t.condition);
                Object res = null;
                try {
                    res = expr.eval(context);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DocumentRouteException("Error evaluating condition: " + t.condition, (Throwable)e);
                }
                if (!(res instanceof Boolean)) {
                    throw new DocumentRouteException("Condition for transition " + t + " of node '" + this.getId() + "' of graph '" + this.graph.getName() + "' does not evaluate to a boolean: " + t.condition);
                }
                boolean bool = Boolean.TRUE.equals(res);
                t.setResult(bool);
                if (!bool) continue;
                trueTrans.add(t);
                if (!this.executeOnlyFirstTransition()) continue;
                break;
            }
            this.saveDocument();
            return trueTrans;
        }
        catch (DocumentRouteException e) {
            throw e;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<String> evaluateTaskAssignees() throws DocumentRouteException {
        ArrayList<String> taskAssignees = new ArrayList<String>();
        OperationContext context = this.getContext();
        String taskAssigneesVar = this.getTaskAssigneesVar();
        if (StringUtils.isEmpty((String)taskAssigneesVar)) {
            return taskAssignees;
        }
        Expression expr = Scripting.newExpression((String)taskAssigneesVar);
        Object[] res = null;
        try {
            res = expr.eval(context);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocumentRouteException("Error evaluating task assignees: " + taskAssigneesVar, (Throwable)e);
        }
        if (res instanceof List) {
            res = ((List)res).toArray();
        }
        if (res instanceof Object[]) {
            Object[] list = res;
            String[] tmp = new String[list.length];
            try {
                System.arraycopy(list, 0, tmp, 0, list.length);
                res = tmp;
            }
            catch (ArrayStoreException e) {
                // empty catch block
            }
        }
        if (!(res instanceof String) && !(res instanceof String[])) {
            throw new DocumentRouteException("Can not evaluate task assignees from " + taskAssigneesVar);
        }
        if (res instanceof String) {
            taskAssignees.add((String)res);
        } else {
            taskAssignees.addAll(Arrays.asList((String[])res));
        }
        return taskAssignees;
    }

    @Override
    public boolean canMerge() {
        try {
            int n = 0;
            List<GraphNode.Transition> inputTransitions = this.getInputTransitions();
            for (GraphNode.Transition t : inputTransitions) {
                if (!t.result) continue;
                ++n;
            }
            String merge = (String)this.getProperty("rnode:merge");
            if ("one".equals(merge)) {
                return n > 0;
            }
            if ("all".equals(merge)) {
                return n == inputTransitions.size();
            }
            throw new ClientRuntimeException("Illegal merge mode '" + merge + "' for node " + this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<GraphNode.Transition> getInputTransitions() {
        return this.inputTransitions;
    }

    @Override
    public void cancelTasks() {
        CoreSession session = this.getSession();
        TaskService taskService = (TaskService)Framework.getLocalService(TaskService.class);
        try {
            List tasks = taskService.getAllTaskInstances(this.getDocumentRoute(session).getDocument().getId(), this.getId(), session);
            for (Task task : tasks) {
                ((DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class)).finishTask(session, (DocumentRoute)this.graph, task, true);
            }
            session.save();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<GraphNode.Button> getTaskButtons() {
        if (this.taskButtons == null) {
            this.taskButtons = this.computeTaskButtons();
        }
        return this.taskButtons;
    }

    protected List<GraphNode.Button> computeTaskButtons() {
        try {
            ListProperty props = (ListProperty)this.document.getProperty("rnode:taskButtons");
            ArrayList<GraphNode.Button> btns = new ArrayList<GraphNode.Button>(props.size());
            for (Property p : props) {
                btns.add(new GraphNode.Button(this, p));
            }
            Collections.sort(btns);
            return btns;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void setButton(String status) {
        try {
            this.document.setPropertyValue("rnode:button", (Serializable)((Object)status));
            CoreSession session = this.document.getCoreSession();
            session.saveDocument(this.document);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void setLastActor(String actor) {
        try {
            this.document.setPropertyValue("rnode:lastActor", (Serializable)((Object)actor));
            this.saveDocument();
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected void addTaskAssignees(List<String> taskAssignees) {
        List<String> allTasksAssignees = this.getTaskAssignees();
        allTasksAssignees.addAll(taskAssignees);
        try {
            this.document.setPropertyValue("rnode:taskAssignees", (Serializable)((Object)allTasksAssignees));
            this.saveDocument();
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getTaskDocType() {
        String taskDocType = (String)this.getProperty("rnode:taskDocType");
        if (StringUtils.isEmpty((String)taskDocType)) {
            taskDocType = "TaskDoc";
        }
        return taskDocType;
    }

    protected Date evaluateDueDate() throws DocumentRouteException {
        OperationContext context = this.getContext();
        String taskDueDateExpr = this.getTaskDueDateExpr();
        if (StringUtils.isEmpty((String)taskDueDateExpr)) {
            return new Date();
        }
        Expression expr = Scripting.newExpression((String)taskDueDateExpr);
        Object res = null;
        try {
            res = expr.eval(context);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocumentRouteException("Error evaluating task due date: " + taskDueDateExpr, (Throwable)e);
        }
        if (res instanceof DateWrapper) {
            return ((DateWrapper)res).getDate();
        }
        if (res instanceof Date) {
            return (Date)res;
        }
        if (res instanceof Calendar) {
            return ((Calendar)res).getTime();
        }
        if (res instanceof String) {
            return DateParser.parseW3CDateTime((String)((String)res));
        }
        throw new DocumentRouteException("The following expression can not be evaluated to a date: " + taskDueDateExpr);
    }

    @Override
    public Date computeTaskDueDate() throws DocumentRouteException {
        Date dueDate = this.evaluateDueDate();
        try {
            this.document.setPropertyValue("rnode:taskDueDate", (Serializable)dueDate);
            CoreSession session = this.document.getCoreSession();
            session.saveDocument(this.document);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return dueDate;
    }

    @Override
    public boolean executeOnlyFirstTransition() {
        return this.getBoolean("rnode:executeOnlyFirstTransition");
    }
}

