/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.SupportedPermissions;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AclCapabilitiesDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoTypeHelper;
import org.nuxeo.ecm.core.opencmis.impl.util.TypeManagerImpl;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public class NuxeoRepository {
    public static final String NUXEO_VERSION_PROP = "org.nuxeo.distribution.version";
    public static final String NUXEO_URL_PROP = "nuxeo.url";
    private static final String NUXEO_CONTEXT_PATH_PROP = "org.nuxeo.ecm.contextPath";
    private static final String NUXEO_CONTEXT_PATH_DEFAULT = "/nuxeo";
    private static final String X_FORWARDED_HOST = "x-forwarded-host";
    private static final String NUXEO_VH_HEADER = "nuxeo-virtual-host";
    protected final String repositoryId;
    protected final String rootFolderId;
    protected TypeManagerImpl typeManager;

    public NuxeoRepository(String repositoryId, String rootFolderId) {
        this.repositoryId = repositoryId;
        this.rootFolderId = rootFolderId;
    }

    public String getId() {
        return this.repositoryId;
    }

    public TypeManagerImpl getTypeManager() {
        if (this.typeManager == null) {
            this.typeManager = NuxeoRepository.initializeTypes();
        }
        return this.typeManager;
    }

    protected static TypeManagerImpl initializeTypes() {
        SchemaManager schemaManager;
        try {
            schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.toString(), e);
        }
        HashMap<String, List<String>> typesChildren = new HashMap<String, List<String>>();
        for (DocumentType dt : schemaManager.getDocumentTypes()) {
            Type st = dt.getSuperType();
            if (st == null) continue;
            String name = st.getName();
            LinkedList<String> siblings = (LinkedList<String>)typesChildren.get(name);
            if (siblings == null) {
                siblings = new LinkedList<String>();
                typesChildren.put(name, siblings);
            }
            siblings.add(dt.getName());
        }
        HashSet<String> done = new HashSet<String>();
        TypeManagerImpl typeManager = new TypeManagerImpl();
        typeManager.addTypeDefinition(NuxeoTypeHelper.constructCmisBase(BaseTypeId.CMIS_DOCUMENT, schemaManager));
        typeManager.addTypeDefinition(NuxeoTypeHelper.constructCmisBase(BaseTypeId.CMIS_FOLDER, schemaManager));
        typeManager.addTypeDefinition(NuxeoTypeHelper.constructCmisBase(BaseTypeId.CMIS_RELATIONSHIP, schemaManager));
        NuxeoRepository.addTypesRecursively(typeManager, "Document", typesChildren, done, schemaManager);
        NuxeoRepository.addTypesRecursively(typeManager, "Folder", typesChildren, done, schemaManager);
        NuxeoRepository.addTypesRecursively(typeManager, "Relation", typesChildren, done, schemaManager);
        return typeManager;
    }

    protected static void addTypesRecursively(TypeManagerImpl typeManager, String name, Map<String, List<String>> typesChildren, Set<String> done, SchemaManager schemaManager) {
        List<String> children;
        if (done.contains(name)) {
            return;
        }
        done.add(name);
        DocumentType dt = schemaManager.getDocumentType(name);
        String parentTypeId = NuxeoTypeHelper.getParentTypeId(dt);
        if (parentTypeId != null) {
            TypeDefinitionContainer parentType = typeManager.getTypeById(parentTypeId);
            if (parentType == null) {
                parentTypeId = BaseTypeId.CMIS_DOCUMENT.value();
            } else if (parentType.getTypeDefinition().getBaseTypeId() != BaseTypeId.CMIS_FOLDER && dt.isFolder()) {
                parentTypeId = BaseTypeId.CMIS_FOLDER.value();
            }
            typeManager.addTypeDefinition(NuxeoTypeHelper.construct(dt, parentTypeId));
        }
        if ((children = typesChildren.get(name)) == null) {
            return;
        }
        for (String sub : children) {
            NuxeoRepository.addTypesRecursively(typeManager, sub, typesChildren, done, schemaManager);
        }
    }

    public String getRootFolderId() {
        return this.rootFolderId;
    }

    public RepositoryInfo getRepositoryInfo(String latestChangeLogToken, CallContext callContext) {
        RepositoryInfoImpl repositoryInfo = new RepositoryInfoImpl();
        repositoryInfo.setId(this.repositoryId);
        repositoryInfo.setName("Nuxeo Repository " + this.repositoryId);
        repositoryInfo.setDescription("Nuxeo Repository " + this.repositoryId);
        repositoryInfo.setCmisVersionSupported("1.1");
        repositoryInfo.setPrincipalAnonymous("Guest");
        repositoryInfo.setPrincipalAnyone("Everyone");
        repositoryInfo.setThinClientUri(NuxeoRepository.getBaseURL(callContext));
        repositoryInfo.setChangesIncomplete(Boolean.FALSE);
        repositoryInfo.setChangesOnType(Arrays.asList(BaseTypeId.CMIS_DOCUMENT, BaseTypeId.CMIS_FOLDER));
        repositoryInfo.setLatestChangeLogToken(latestChangeLogToken);
        repositoryInfo.setVendorName("Nuxeo");
        repositoryInfo.setProductName("Nuxeo OpenCMIS Connector");
        String version = Framework.getProperty((String)NUXEO_VERSION_PROP, (String)"5.5 dev");
        repositoryInfo.setProductVersion(version);
        repositoryInfo.setRootFolder(this.rootFolderId);
        RepositoryCapabilitiesImpl caps = new RepositoryCapabilitiesImpl();
        repositoryInfo.setCapabilities((RepositoryCapabilities)caps);
        AclCapabilitiesDataImpl aclCaps = new AclCapabilitiesDataImpl();
        repositoryInfo.setAclCapabilities((AclCapabilities)aclCaps);
        caps.setAllVersionsSearchable(Boolean.TRUE);
        caps.setCapabilityAcl(CapabilityAcl.NONE);
        caps.setCapabilityChanges(CapabilityChanges.OBJECTIDSONLY);
        caps.setCapabilityContentStreamUpdates(CapabilityContentStreamUpdates.PWCONLY);
        caps.setCapabilityJoin(CapabilityJoin.INNERANDOUTER);
        caps.setCapabilityQuery(CapabilityQuery.BOTHCOMBINED);
        caps.setCapabilityRendition(CapabilityRenditions.READ);
        caps.setIsPwcSearchable(Boolean.TRUE);
        caps.setIsPwcUpdatable(Boolean.TRUE);
        caps.setSupportsGetDescendants(Boolean.TRUE);
        caps.setSupportsGetFolderTree(Boolean.TRUE);
        caps.setSupportsMultifiling(Boolean.FALSE);
        caps.setSupportsUnfiling(Boolean.FALSE);
        caps.setSupportsVersionSpecificFiling(Boolean.FALSE);
        aclCaps.setAclPropagation(AclPropagation.REPOSITORYDETERMINED);
        aclCaps.setPermissionDefinitionData(new ArrayList(0));
        aclCaps.setPermissionMappingData(new HashMap());
        aclCaps.setSupportedPermissions(SupportedPermissions.BASIC);
        return repositoryInfo;
    }

    public TypeDefinition getTypeDefinition(String typeId) {
        TypeDefinitionContainer typec = this.getTypeManager().getTypeById(typeId);
        return typec == null ? null : typec.getTypeDefinition();
    }

    public TypeDefinitionList getTypeChildren(String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount) {
        return this.getTypeManager().getTypeChildren(typeId, includePropertyDefinitions, maxItems, skipCount);
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String typeId, int depth, Boolean includePropertyDefinitions) {
        return this.getTypeManager().getTypeDescendants(typeId, depth, includePropertyDefinitions);
    }

    private static String getBaseURL(CallContext callContext) {
        HttpServletRequest request = (HttpServletRequest)callContext.get("httpServletRequest");
        if (request != null) {
            String baseURL = NuxeoRepository.getServerURL(request);
            String contextPath = request.getContextPath();
            if (contextPath == null) {
                contextPath = Framework.getProperty((String)NUXEO_CONTEXT_PATH_PROP, (String)NUXEO_CONTEXT_PATH_DEFAULT);
            }
            return baseURL + contextPath + '/';
        }
        return Framework.getProperty((String)NUXEO_URL_PROP);
    }

    private static String getServerURL(HttpServletRequest request) {
        String url = null;
        String nuxeoVH = request.getHeader(NUXEO_VH_HEADER);
        if (nuxeoVH != null && nuxeoVH.startsWith("http")) {
            url = nuxeoVH;
        } else {
            String scheme = request.getScheme();
            String serverName = request.getServerName();
            int serverPort = request.getServerPort();
            String forwardedHost = request.getHeader(X_FORWARDED_HOST);
            if (forwardedHost != null) {
                if (forwardedHost.contains(":")) {
                    String[] split = forwardedHost.split(":");
                    serverName = split[0];
                    serverPort = Integer.parseInt(split[1]);
                } else {
                    serverName = forwardedHost;
                    serverPort = 80;
                }
            }
            url = NuxeoRepository.buildURL(scheme, serverName, serverPort);
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private static String buildURL(String scheme, String serverName, int serverPort) {
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(serverName);
        if (serverPort != 0 && ("http".equals(scheme) && serverPort != 80 || "https".equals(scheme) && serverPort != 443)) {
            sb.append(':');
            sb.append(serverPort);
        }
        return sb.toString();
    }
}

