/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.tube.server;

import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.tube.AbstractWssTube;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WssTube
extends AbstractWssTube {
    public WssTube(Tube next) {
        super(next);
    }

    protected WssTube(AbstractFilterTubeImpl that, TubeCloner cloner) {
        super(that, cloner);
    }

    public WssTube copy(TubeCloner cloner) {
        return new WssTube(this, cloner);
    }

    public NextAction processResponse(Packet packet) {
        Message message = packet.getMessage();
        if (message == null) {
            return super.processResponse(packet);
        }
        try {
            long created = System.currentTimeMillis();
            long expires = created + 86400000L;
            Document document = XMLUtils.newDomDocument();
            Element wsseSecurityElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
            Element wsuTimestampElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
            wsseSecurityElement.appendChild(wsuTimestampElement);
            Element tsCreatedElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
            tsCreatedElement.setTextContent(DateTimeHelper.formatXmlDateTime(created));
            wsuTimestampElement.appendChild(tsCreatedElement);
            Element tsExpiresElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
            tsExpiresElement.setTextContent(DateTimeHelper.formatXmlDateTime(expires));
            wsuTimestampElement.appendChild(tsExpiresElement);
            HeaderList headers = message.getHeaders();
            headers.add(Headers.create((Element)wsseSecurityElement));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.processResponse(packet);
    }
}

