/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.el;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.MapELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.nuxeo.ecm.platform.el.DocumentModelResolver;

public class ExpressionContext
extends ELContext {
    private final ELResolver resolver = new MyResolver();
    private final FunctionMapper functionMapper = new MyFunctionMapper();
    private final VariableMapper variableMapper = new MyVariableMapper();

    public ELResolver getELResolver() {
        return this.resolver;
    }

    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    public VariableMapper getVariableMapper() {
        return this.variableMapper;
    }

    private static class MyResolver
    extends CompositeELResolver {
        private MyResolver() {
            this.add((ELResolver)new DocumentModelResolver());
            this.add((ELResolver)new MapELResolver());
            this.add((ELResolver)new ArrayELResolver());
            this.add((ELResolver)new BeanELResolver());
        }
    }

    private static class MyFunctionMapper
    extends FunctionMapper {
        private final Map<String, Method> map = new HashMap<String, Method>();

        private MyFunctionMapper() {
        }

        public void setFunction(String prefix, String localName, Method method) {
            this.map.put(prefix + ":" + localName, method);
        }

        public Method resolveFunction(String prefix, String localName) {
            return this.map.get(prefix + ":" + localName);
        }
    }

    private static class MyVariableMapper
    extends VariableMapper {
        protected final Map<String, ValueExpression> map = new HashMap<String, ValueExpression>();

        private MyVariableMapper() {
        }

        public ValueExpression resolveVariable(String variable) {
            return this.map.get(variable);
        }

        public ValueExpression setVariable(String variable, ValueExpression expression) {
            return this.map.put(variable, expression);
        }
    }
}

