/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.map.ReferenceMap;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.Selection;
import org.nuxeo.ecm.core.storage.sql.SelectionType;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;

public class SelectionContext {
    private final SelectionType selType;
    private final Serializable criterion;
    private final RowMapper mapper;
    private final PersistenceContext context;
    private final Map<Serializable, Selection> softMap;
    public final Map<Serializable, Selection> hardMap;
    private final Set<Serializable> modifiedInTransaction;
    private final Counter cacheHitCount = Metrics.defaultRegistry().newCounter(SelectionContext.class, "cache-hit");
    private final Timer cacheGetTimer = Metrics.defaultRegistry().newTimer(SelectionContext.class, "cache-get", TimeUnit.MICROSECONDS, TimeUnit.SECONDS);

    public SelectionContext(SelectionType selType, Serializable criterion, RowMapper mapper, PersistenceContext context) {
        this.selType = selType;
        this.criterion = criterion;
        this.mapper = mapper;
        this.context = context;
        this.softMap = new ReferenceMap(0, 1);
        this.hardMap = new HashMap<Serializable, Selection>();
        this.modifiedInTransaction = new HashSet<Serializable>();
        Metrics.defaultRegistry().newGauge(SelectionContext.class, "cache-size", (Gauge)new Gauge<Integer>(){

            public Integer getValue() {
                return SelectionContext.this.softMap == null ? 0 : SelectionContext.this.softMap.size();
            }
        });
    }

    public int clearCaches() {
        int n = this.softMap.size();
        this.softMap.clear();
        this.modifiedInTransaction.clear();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Selection getSelection(Serializable selId) {
        TimerContext timerContext = this.cacheGetTimer.time();
        try {
            Selection selection = this.softMap.get(selId);
            if (selection != null) {
                this.cacheHitCount.inc();
                Selection selection2 = selection;
                return selection2;
            }
            selection = this.hardMap.get(selId);
            if (selection != null) {
                this.cacheHitCount.inc();
                Selection selection3 = selection;
                return selection3;
            }
        }
        finally {
            timerContext.stop();
        }
        return new Selection(selId, this.selType.tableName, false, this.selType.filterKey, this.context, this.softMap, this.hardMap);
    }

    public boolean applicable(SimpleFragment fragment) throws StorageException {
        Serializable crit;
        if (!fragment.row.tableName.equals(this.selType.tableName)) {
            return false;
        }
        return this.selType.criterionKey == null || this.criterion.equals(crit = fragment.get(this.selType.criterionKey));
    }

    public void recordCreated(SimpleFragment fragment) throws StorageException {
        Serializable id = fragment.getId();
        Serializable selId = fragment.get(this.selType.selKey);
        if (selId != null) {
            this.getSelection(selId).addCreated(id);
            this.modifiedInTransaction.add(selId);
        }
    }

    public void newSelection(Serializable selId) {
        new Selection(selId, this.selType.tableName, true, this.selType.filterKey, this.context, this.softMap, this.hardMap);
    }

    public void recordExisting(SimpleFragment fragment, boolean invalidate) throws StorageException {
        Serializable selId = fragment.get(this.selType.selKey);
        if (selId != null) {
            this.getSelection(selId).addExisting(fragment.getId());
            if (invalidate) {
                this.modifiedInTransaction.add(selId);
            }
        }
    }

    public void recordRemoved(SimpleFragment fragment) throws StorageException {
        this.recordRemoved(fragment.getId(), fragment.get(this.selType.selKey));
    }

    public void recordRemoved(Serializable id, Serializable selId) throws StorageException {
        if (selId != null) {
            this.getSelection(selId).remove(id);
            this.modifiedInTransaction.add(selId);
        }
    }

    public void recordRemovedSelection(Serializable selId) throws StorageException {
        this.softMap.remove(selId);
        this.hardMap.remove(selId);
        this.modifiedInTransaction.add(selId);
    }

    public SimpleFragment getSelectionFragment(Serializable selId, String filter) throws StorageException {
        SimpleFragment fragment = this.getSelection(selId).getFragmentByValue((Serializable)((Object)filter));
        if (fragment == SimpleFragment.UNKNOWN) {
            List<Row> rows = this.mapper.readSelectionRows(this.selType, selId, (Serializable)((Object)filter), this.criterion, true);
            Row row = rows.isEmpty() ? null : rows.get(0);
            fragment = (SimpleFragment)this.context.getFragmentFromFetchedRow(row, false);
        }
        return fragment;
    }

    public List<SimpleFragment> getSelectionFragments(Serializable selId, String filter) throws StorageException {
        Selection selection = this.getSelection(selId);
        List<SimpleFragment> fragments = selection.getFragmentsByValue((Serializable)((Object)filter));
        if (fragments == null) {
            List<Row> rows = this.mapper.readSelectionRows(this.selType, selId, null, this.criterion, false);
            List<Fragment> frags = this.context.getFragmentsFromFetchedRows(rows, false);
            fragments = new ArrayList<SimpleFragment>(frags.size());
            ArrayList<Serializable> ids = new ArrayList<Serializable>(frags.size());
            for (Fragment fragment : frags) {
                fragments.add((SimpleFragment)fragment);
                ids.add(fragment.getId());
            }
            selection.addExistingComplete(ids);
            fragments = selection.getFragmentsByValue((Serializable)((Object)filter));
        }
        return fragments;
    }

    public void postSave() {
        for (Selection selection : this.hardMap.values()) {
            selection.flush();
        }
        this.hardMap.clear();
    }

    public void markInvalidated(Set<RowId> modified) {
        for (RowId rowId : modified) {
            if (!this.selType.invalidationTableName.equals(rowId.tableName)) continue;
            Serializable id = rowId.id;
            Selection selection = this.softMap.get(id);
            if (selection != null) {
                selection.setIncomplete();
            }
            if ((selection = this.hardMap.get(id)) != null) {
                selection.setIncomplete();
            }
            this.modifiedInTransaction.add(id);
        }
    }

    public void gatherInvalidations(Invalidations invalidations) {
        for (Serializable id : this.modifiedInTransaction) {
            invalidations.addModified(new RowId(this.selType.invalidationTableName, id));
        }
        this.modifiedInTransaction.clear();
    }

    public void processReceivedInvalidations(Set<RowId> modified) throws StorageException {
        for (RowId rowId : modified) {
            if (!this.selType.invalidationTableName.equals(rowId.tableName)) continue;
            Serializable id = rowId.id;
            this.softMap.remove(id);
            this.hardMap.remove(id);
        }
    }
}

