/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.InvalidationsPropagator;
import org.nuxeo.ecm.core.storage.sql.InvalidationsQueue;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.SelectionType;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;

public class SoftRefCachingRowMapper
implements RowMapper {
    private static final Log log = LogFactory.getLog(SoftRefCachingRowMapper.class);
    private static final String ABSENT = "__ABSENT__\u0000\u0000\u0000";
    private final Map<RowId, Row> cache;
    private Model model;
    private RowMapper rowMapper;
    private final Invalidations localInvalidations;
    private final InvalidationsQueue cacheQueue;
    private InvalidationsPropagator cachePropagator;
    private InvalidationsQueue eventQueue;
    private InvalidationsPropagator eventPropagator;
    private SessionImpl session;
    protected boolean forRemoteClient = false;
    private final Counter cacheHitCount = Metrics.defaultRegistry().newCounter(SoftRefCachingRowMapper.class, "cache-hit");
    private final Counter cacheSize = Metrics.defaultRegistry().newCounter(SoftRefCachingRowMapper.class, "cache-size");
    private final Timer cacheGetTimer = Metrics.defaultRegistry().newTimer(SoftRefCachingRowMapper.class, "cache-get", TimeUnit.MICROSECONDS, TimeUnit.SECONDS);
    private final Counter sorRows = Metrics.defaultRegistry().newCounter(SoftRefCachingRowMapper.class, "sor-rows");
    private final Timer sorGetTimer = Metrics.defaultRegistry().newTimer(SoftRefCachingRowMapper.class, "sor-get", TimeUnit.MICROSECONDS, TimeUnit.SECONDS);

    public SoftRefCachingRowMapper() {
        this.cache = new ReferenceMap(0, 1);
        this.localInvalidations = new Invalidations();
        this.cacheQueue = new InvalidationsQueue("mapper-" + this);
    }

    public void initialize(Model model, RowMapper rowMapper, InvalidationsPropagator cachePropagator, InvalidationsPropagator eventPropagator, InvalidationsQueue repositoryEventQueue, Map<String, String> properties) {
        this.model = model;
        this.rowMapper = rowMapper;
        this.cachePropagator = cachePropagator;
        cachePropagator.addQueue(this.cacheQueue);
        this.eventQueue = repositoryEventQueue;
        this.eventPropagator = eventPropagator;
        eventPropagator.addQueue(repositoryEventQueue);
    }

    public void close() throws StorageException {
        this.cachePropagator.removeQueue(this.cacheQueue);
        this.eventPropagator.removeQueue(this.eventQueue);
    }

    @Override
    public Serializable generateNewId() throws StorageException {
        return this.rowMapper.generateNewId();
    }

    protected static boolean isAbsent(Row row) {
        return row.tableName == ABSENT;
    }

    protected void cachePut(Row row) {
        if ((row = row.clone()).isCollection() && row.values.length > 0 && row.values[0] instanceof ACLRow) {
            row.values = this.sortACLRows((ACLRow[])row.values);
        }
        this.cache.put(new RowId(row), row);
        this.cacheSize.inc();
    }

    protected ACLRow[] sortACLRows(ACLRow[] acls) {
        ArrayList<ACLRow> list = new ArrayList<ACLRow>(Arrays.asList(acls));
        Collections.sort(list, ACLRow.ACLRowPositionComparator.INSTANCE);
        ACLRow[] res = new ACLRow[acls.length];
        return list.toArray(res);
    }

    protected void cachePutAbsent(RowId rowId) {
        this.cache.put(new RowId(rowId), new Row(ABSENT, (Serializable)null));
        this.cacheSize.inc();
    }

    protected void cachePutAbsentIfNull(RowId rowId, Row row) {
        if (row != null) {
            this.cachePut(row);
        } else {
            this.cachePutAbsent(rowId);
        }
    }

    protected void cachePutAbsentIfRowId(RowId rowId) {
        if (rowId instanceof Row) {
            this.cachePut((Row)rowId);
        } else {
            this.cachePutAbsent(rowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row cacheGet(RowId rowId) {
        TimerContext context = this.cacheGetTimer.time();
        try {
            Row row = this.cache.get(rowId);
            if (row != null && !SoftRefCachingRowMapper.isAbsent(row)) {
                row = row.clone();
            }
            if (row != null) {
                this.cacheHitCount.inc();
            }
            Row row2 = row;
            return row2;
        }
        finally {
            context.stop();
        }
    }

    protected void cacheRemove(RowId rowId) {
        this.cache.remove(rowId);
    }

    @Override
    public Invalidations.InvalidationsPair receiveInvalidations() throws StorageException {
        Invalidations.InvalidationsPair invals = this.rowMapper.receiveInvalidations();
        Invalidations invalidations = this.cacheQueue.getInvalidations();
        if (invals != null) {
            invalidations.add(invals.cacheInvalidations);
        }
        Invalidations events = this.eventQueue.getInvalidations();
        if (invals != null) {
            events.add(invals.eventInvalidations);
        }
        if (invalidations.all) {
            this.clearCache();
        }
        if (invalidations.modified != null) {
            for (RowId rowId : invalidations.modified) {
                this.cacheRemove(rowId);
            }
        }
        if (invalidations.deleted != null) {
            for (RowId rowId : invalidations.deleted) {
                this.cachePutAbsent(rowId);
            }
        }
        if (invalidations.isEmpty() && events.isEmpty()) {
            return null;
        }
        return new Invalidations.InvalidationsPair(invalidations.isEmpty() ? null : invalidations, events.isEmpty() ? null : events);
    }

    @Override
    public void sendInvalidations(Invalidations invalidations) throws StorageException {
        if (!this.localInvalidations.isEmpty()) {
            if (invalidations == null) {
                invalidations = new Invalidations();
            }
            invalidations.add(this.localInvalidations);
            this.localInvalidations.clear();
        }
        if (invalidations != null && !invalidations.isEmpty()) {
            this.rowMapper.sendInvalidations(invalidations);
            this.cachePropagator.propagateInvalidations(invalidations, this.cacheQueue);
            this.eventPropagator.propagateInvalidations(invalidations, this.eventQueue);
            if (!this.forRemoteClient) {
                this.session.sendInvalidationEvent(invalidations, true);
            }
        }
    }

    public void setEventQueue(InvalidationsQueue eventQueue) {
        this.eventQueue = eventQueue;
        this.eventPropagator.addQueue(eventQueue);
        this.forRemoteClient = true;
    }

    public void setSession(SessionImpl session) {
        this.session = session;
    }

    @Override
    public void clearCache() {
        this.cacheSize.dec((long)this.cache.size());
        this.cache.clear();
        this.localInvalidations.clear();
        this.rowMapper.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.rowMapper.rollback(xid);
        }
        finally {
            this.cacheSize.dec((long)this.cache.size());
            this.cache.clear();
            this.localInvalidations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends RowId> read(Collection<RowId> rowIds, boolean cacheOnly) throws StorageException {
        ArrayList<? extends RowId> res = new ArrayList<RowId>(rowIds.size());
        LinkedList<RowId> todo = new LinkedList<RowId>();
        for (RowId rowId : rowIds) {
            Row row = this.cacheGet(rowId);
            if (row == null) {
                if (cacheOnly) {
                    res.add(new RowId(rowId));
                    continue;
                }
                todo.add(rowId);
                continue;
            }
            if (SoftRefCachingRowMapper.isAbsent(row)) {
                res.add(new RowId(rowId));
                continue;
            }
            res.add(row);
        }
        if (!todo.isEmpty()) {
            TimerContext context = this.sorGetTimer.time();
            try {
                List<? extends RowId> fetched = this.rowMapper.read(todo, cacheOnly);
                for (RowId rowId : fetched) {
                    this.cachePutAbsentIfRowId(rowId);
                }
                res.addAll(fetched);
                this.sorRows.inc((long)fetched.size());
            }
            finally {
                context.stop();
            }
        }
        return res;
    }

    @Override
    public void write(RowMapper.RowBatch batch) throws StorageException {
        for (Row row : batch.creates) {
            this.cachePut(row);
            this.localInvalidations.addModified(new RowId(row));
        }
        for (RowMapper.RowUpdate rowu : batch.updates) {
            this.cachePut(rowu.row);
            this.localInvalidations.addModified(new RowId(rowu.row));
        }
        for (RowId rowId : batch.deletes) {
            if (rowId instanceof Row) {
                throw new AssertionError();
            }
            this.cachePutAbsent(rowId);
            this.localInvalidations.addDeleted(rowId);
        }
        for (RowId rowId : batch.deletesDependent) {
            if (rowId instanceof Row) {
                throw new AssertionError();
            }
            this.cachePutAbsent(rowId);
            this.localInvalidations.addDeleted(rowId);
        }
        this.rowMapper.write(batch);
    }

    @Override
    public Row readSimpleRow(RowId rowId) throws StorageException {
        Row row = this.cacheGet(rowId);
        if (row == null) {
            row = this.rowMapper.readSimpleRow(rowId);
            this.cachePutAbsentIfNull(rowId, row);
            return row;
        }
        if (SoftRefCachingRowMapper.isAbsent(row)) {
            return null;
        }
        return row;
    }

    @Override
    public Serializable[] readCollectionRowArray(RowId rowId) throws StorageException {
        Row row = this.cacheGet(rowId);
        if (row == null) {
            Serializable[] array = this.rowMapper.readCollectionRowArray(rowId);
            assert (array != null);
            row = new Row(rowId.tableName, rowId.id, array);
            this.cachePut(row);
            return row.values;
        }
        if (SoftRefCachingRowMapper.isAbsent(row)) {
            return null;
        }
        return row.values;
    }

    @Override
    public List<Row> readSelectionRows(SelectionType selType, Serializable selId, Serializable filter, Serializable criterion, boolean limitToOne) throws StorageException {
        List<Row> rows = this.rowMapper.readSelectionRows(selType, selId, filter, criterion, limitToOne);
        for (Row row : rows) {
            this.cachePut(row);
        }
        return rows;
    }

    @Override
    public RowMapper.CopyResult copy(RowMapper.IdWithTypes source, Serializable destParentId, String destName, Row overwriteRow) throws StorageException {
        RowMapper.CopyResult result = this.rowMapper.copy(source, destParentId, destName, overwriteRow);
        Invalidations invalidations = result.invalidations;
        if (invalidations.modified != null) {
            for (RowId rowId : invalidations.modified) {
                this.cacheRemove(rowId);
                this.localInvalidations.addModified(new RowId(rowId));
            }
        }
        if (invalidations.deleted != null) {
            for (RowId rowId : invalidations.deleted) {
                this.cacheRemove(rowId);
                this.localInvalidations.addDeleted(rowId);
            }
        }
        return result;
    }

    @Override
    public List<RowMapper.NodeInfo> remove(RowMapper.NodeInfo rootInfo) throws StorageException {
        List<RowMapper.NodeInfo> infos = this.rowMapper.remove(rootInfo);
        for (RowMapper.NodeInfo info : infos) {
            for (String fragmentName : this.model.getTypeFragments(new RowMapper.IdWithTypes(info.id, info.primaryType, null))) {
                RowId rowId = new RowId(fragmentName, info.id);
                this.cacheRemove(rowId);
                this.localInvalidations.addDeleted(rowId);
            }
        }
        this.cachePutAbsent(new RowId("hierarchy", rootInfo.id));
        return infos;
    }
}

