/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.MetaTagHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.el.ValueExpressionLiteral;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public class WidgetTagHandler
extends MetaTagHandler {
    private static final Log log = LogFactory.getLog(WidgetTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute widget;
    protected final TagAttribute name;
    protected final TagAttribute category;
    protected final TagAttribute definition;
    protected final TagAttribute mode;
    protected final TagAttribute layoutName;
    protected final TagAttribute resolveOnly;
    protected final TagAttribute value;
    protected final TagAttribute[] vars;
    protected final String[] reservedVarsArray = new String[]{"id", "widget", "name", "category", "definition", "mode", "layoutName", "value", "resolveOnly"};

    public WidgetTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.widget = this.getAttribute("widget");
        this.name = this.getAttribute("name");
        this.definition = this.getAttribute("definition");
        this.category = this.getAttribute("category");
        this.mode = this.getAttribute("mode");
        this.layoutName = this.getAttribute("layoutName");
        this.resolveOnly = this.getAttribute("resolveOnly");
        this.value = this.getAttribute("value");
        this.vars = this.tag.getAttributes().getAll();
        if (this.name == null && this.widget == null && this.definition == null) {
            throw new TagException(this.tag, "At least one of attributes 'name', 'widget' or 'definition' is required");
        }
        if (this.widget == null && (this.name != null || this.definition != null) && this.mode == null) {
            throw new TagException(this.tag, "Attribute 'mode' is required when using attribute 'name' or 'definition' so that the widget instance can be resolved");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        String valueName = null;
        if (this.value != null) {
            valueName = this.value.getValue();
        }
        if (ComponentTagUtils.isStrictValueReference(valueName)) {
            valueName = ComponentTagUtils.getBareValueName((String)valueName);
        }
        boolean widgetInstanceBuilt = false;
        Widget widgetInstance = null;
        if (this.widget != null) {
            widgetInstance = (Widget)this.widget.getObject(ctx, Widget.class);
            if (widgetInstance != null && valueName != null) {
                widgetInstance.setValueName(valueName);
            }
        } else {
            WidgetDefinition widgetDef;
            WebLayoutManager layoutService;
            try {
                layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            if (layoutService == null) {
                throw new FacesException("Layout service not found");
            }
            String modeValue = this.mode.getValue(ctx);
            String layoutNameValue = null;
            if (this.layoutName != null) {
                layoutNameValue = this.layoutName.getValue(ctx);
            }
            if (this.name != null) {
                String nameValue = this.name.getValue(ctx);
                String catValue = null;
                if (this.category != null) {
                    catValue = this.category.getValue(ctx);
                }
                widgetInstance = layoutService.getWidget(ctx, nameValue, catValue, modeValue, valueName, layoutNameValue);
                widgetInstanceBuilt = true;
            } else if (this.definition != null && (widgetDef = (WidgetDefinition)this.definition.getObject(ctx, WidgetDefinition.class)) != null) {
                widgetInstance = layoutService.getWidget(ctx, widgetDef, modeValue, valueName, layoutNameValue);
                widgetInstanceBuilt = true;
            }
        }
        if (widgetInstance != null) {
            List<String> reservedVars = Arrays.asList(this.reservedVarsArray);
            for (TagAttribute var : this.vars) {
                String localName = var.getLocalName();
                if (reservedVars.contains(localName)) continue;
                widgetInstance.setProperty(localName, (Serializable)((Object)var.getValue()));
            }
            VariableMapper orig = ctx.getVariableMapper();
            if (widgetInstanceBuilt) {
                FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, this.config);
                WidgetTagHandler.generateWidgetIdsRecursive(helper, widgetInstance);
                VariableMapperWrapper vm = new VariableMapperWrapper(orig);
                ctx.setVariableMapper((VariableMapper)vm);
                ExpressionFactory eFactory = ctx.getExpressionFactory();
                ValueExpression widgetVe = eFactory.createValueExpression((Object)widgetInstance, Widget.class);
                vm.setVariable(RenderVariables.widgetVariables.widget.name(), widgetVe);
                for (Map.Entry ctrl : widgetInstance.getControls().entrySet()) {
                    String key = (String)ctrl.getKey();
                    String name = String.format("%s_%s", RenderVariables.widgetVariables.widgetControl.name(), key);
                    String value = String.format("#{%s.controls.%s}", RenderVariables.widgetVariables.widget.name(), key);
                    vm.setVariable(name, eFactory.createValueExpression((ELContext)ctx, value, Object.class));
                }
            }
            try {
                boolean resolveOnlyBool = false;
                if (this.resolveOnly != null) {
                    resolveOnlyBool = this.resolveOnly.getBoolean(ctx);
                }
                if (resolveOnlyBool) {
                    this.nextHandler.apply(ctx, parent);
                } else {
                    WidgetTagHandler.applyWidgetHandler(ctx, parent, this.config, widgetInstance, this.value, true, this.nextHandler);
                }
            }
            finally {
                ctx.setVariableMapper(orig);
            }
        }
    }

    public static void generateWidgetIdsRecursive(FaceletHandlerHelper helper, Widget widget) {
        if (widget == null) {
            return;
        }
        widget.setId(helper.generateWidgetId(widget.getName()));
        Widget[] subWidgets = widget.getSubWidgets();
        if (subWidgets != null) {
            for (Widget subWidget : subWidgets) {
                WidgetTagHandler.generateWidgetIdsRecursive(helper, subWidget);
            }
        }
    }

    public static void applyWidgetHandler(FaceletContext ctx, UIComponent parent, TagConfig config, Widget widget, TagAttribute value, boolean fillVariables, FaceletHandler nextHandler) throws IOException {
        WebLayoutManager layoutService;
        if (widget == null) {
            return;
        }
        try {
            layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, config);
        FaceletHandler handler = layoutService.getFaceletHandler(ctx, config, widget, nextHandler);
        if (handler == null) {
            return;
        }
        if (fillVariables) {
            HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
            Object valueExpr = value == null ? new ValueExpressionLiteral(null, Object.class) : value.getValueExpression(ctx, Object.class);
            variables.put(RenderVariables.globalVariables.value.name(), (ValueExpression)valueExpr);
            variables.put(String.format("%s_%s", RenderVariables.globalVariables.value.name(), widget.getLevel()), (ValueExpression)valueExpr);
            variables.put(RenderVariables.globalVariables.document.name(), (ValueExpression)valueExpr);
            FaceletHandler handlerWithVars = helper.getAliasTagHandler(widget.getTagConfigId(), variables, null, handler);
            handlerWithVars.apply(ctx, parent);
        } else {
            handler.apply(ctx, parent);
        }
    }
}

