/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets.plugins;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.tag.CompositeFaceletHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributes;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.ui.DecorateHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.LeafFaceletHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.ValueExpressionHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.plugins.AbstractWidgetTypeHandler;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.tag.handler.TagConfigFactory;
import org.nuxeo.runtime.api.Framework;

public class TemplateWidgetTypeHandler
extends AbstractWidgetTypeHandler {
    private static final Log log = LogFactory.getLog(TemplateWidgetTypeHandler.class);
    private static final long serialVersionUID = 6886289896957398368L;
    public static final String TEMPLATE_PROPERTY_NAME = "template";
    public static final String BIND_VALUE_IF_NO_FIELD_PROPERTY_NAME = "bindValueIfNoField";

    @Override
    public FaceletHandler getFaceletHandler(FaceletContext ctx, TagConfig tagConfig, Widget widget, FaceletHandler[] subHandlers) throws WidgetException {
        String template = this.getTemplateValue(widget);
        LeafFaceletHandler leaf = new LeafFaceletHandler();
        if (template == null) {
            log.error((Object)("Missing template property for widget " + widget.getName() + " in layout " + widget.getLayoutName()));
            return leaf;
        }
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, tagConfig);
        String widgetId = widget.getId();
        TagAttributes attributes = helper.getTagAttributes(widgetId, widget);
        TagAttribute templateAttr = this.getTemplateAttribute(helper);
        if (templateAttr == null) {
            templateAttr = helper.createAttribute(TEMPLATE_PROPERTY_NAME, template);
        }
        attributes = FaceletHandlerHelper.addTagAttribute(attributes, templateAttr);
        String widgetTagConfigId = widget.getTagConfigId();
        LeafFaceletHandler nextHandler = leaf;
        if (subHandlers != null) {
            nextHandler = new CompositeFaceletHandler(subHandlers);
        }
        TagConfig config = TagConfigFactory.createTagConfig((TagConfig)tagConfig, (String)widgetTagConfigId, (TagAttributes)attributes, (FaceletHandler)nextHandler);
        Map<String, ValueExpression> variables = this.getVariablesForRendering(ctx, helper, widget, subHandlers, widgetTagConfigId, template);
        ArrayList<String> blockedPatterns = new ArrayList<String>();
        blockedPatterns.add(RenderVariables.widgetVariables.field.name() + "*");
        blockedPatterns.add(RenderVariables.widgetVariables.fieldOrValue.name());
        blockedPatterns.add(RenderVariables.widgetVariables.widgetProperty.name() + "_*");
        blockedPatterns.add(RenderVariables.widgetVariables.widgetControl.name() + "_*");
        DecorateHandler includeHandler = new DecorateHandler(config);
        FaceletHandler handler = helper.getAliasTagHandler(widgetTagConfigId, variables, blockedPatterns, (FaceletHandler)includeHandler);
        return handler;
    }

    protected Map<String, ValueExpression> getVariablesForRendering(FaceletContext ctx, FaceletHandlerHelper helper, Widget widget, FaceletHandler[] subHandlers, String widgetTagConfigId, String template) {
        String value;
        String name;
        String key;
        WebLayoutManager layoutService;
        HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        FieldDefinition[] fieldDefs = widget.getFieldDefinitions();
        FieldDefinition firstField = null;
        if (fieldDefs != null && fieldDefs.length > 0) {
            for (int i = 0; i < fieldDefs.length; ++i) {
                if (i == 0) {
                    this.addFieldVariable(variables, ctx, widget, fieldDefs[i], null);
                    firstField = fieldDefs[i];
                }
                this.addFieldVariable(variables, ctx, widget, fieldDefs[i], i);
            }
        } else if (this.getBindValueIfNoFieldValue(widget)) {
            this.addFieldVariable(variables, ctx, widget, null, null);
            this.addFieldVariable(variables, ctx, widget, null, 0);
        }
        String computedValue = ValueExpressionHelper.createExpressionString(widget.getValueName(), firstField);
        variables.put(RenderVariables.widgetVariables.fieldOrValue.name(), eFactory.createValueExpression((ELContext)ctx, computedValue, Object.class));
        try {
            layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        if (layoutService == null) {
            throw new FacesException("Layout service not found");
        }
        for (Map.Entry prop : widget.getProperties().entrySet()) {
            key = (String)prop.getKey();
            name = String.format("%s_%s", RenderVariables.widgetVariables.widgetProperty.name(), key);
            Serializable valueInstance = (Serializable)prop.getValue();
            value = !layoutService.referencePropertyAsExpression(key, valueInstance, widget.getType(), widget.getMode(), template) ? (String)((Object)valueInstance) : String.format("#{%s.properties.%s}", RenderVariables.widgetVariables.widget.name(), key);
            variables.put(name, eFactory.createValueExpression((ELContext)ctx, value, Object.class));
        }
        for (Map.Entry ctrl : widget.getControls().entrySet()) {
            key = (String)ctrl.getKey();
            name = String.format("%s_%s", RenderVariables.widgetVariables.widgetControl.name(), key);
            value = String.format("#{%s.controls.%s}", RenderVariables.widgetVariables.widget.name(), key);
            variables.put(name, eFactory.createValueExpression((ELContext)ctx, value, Object.class));
        }
        return variables;
    }

    protected void addFieldVariable(Map<String, ValueExpression> variables, FaceletContext ctx, Widget widget, FieldDefinition fieldDef, Integer index) {
        String computedName = index == null ? RenderVariables.widgetVariables.field.name() : String.format("%s_%s", RenderVariables.widgetVariables.field.name(), index);
        String computedValue = ValueExpressionHelper.createExpressionString(widget.getValueName(), fieldDef);
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        variables.put(computedName, eFactory.createValueExpression((ELContext)ctx, computedValue, Object.class));
    }

    protected String getTemplateValue(Widget widget) {
        String template = this.getProperty(TEMPLATE_PROPERTY_NAME);
        if (template == null) {
            template = (String)((Object)widget.getProperty(TEMPLATE_PROPERTY_NAME));
        }
        return template;
    }

    protected boolean getBindValueIfNoFieldValue(Widget widget) {
        Object value = this.getProperty(BIND_VALUE_IF_NO_FIELD_PROPERTY_NAME);
        if (value == null) {
            value = widget.getProperty(BIND_VALUE_IF_NO_FIELD_PROPERTY_NAME);
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return Boolean.TRUE.equals(value);
        }
        return Boolean.TRUE.equals(Boolean.valueOf(value.toString()));
    }

    protected TagAttribute getTemplateAttribute(FaceletHandlerHelper helper) {
        return null;
    }
}

