/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.error;

import com.phloc.commons.ICloneable;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceErrorGroup;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.IClearable;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ResourceErrorGroup
implements IResourceErrorGroup,
ICloneable<ResourceErrorGroup>,
IClearable {
    private final List<IResourceError> m_aErrors = new ArrayList<IResourceError>();

    public ResourceErrorGroup() {
    }

    public ResourceErrorGroup(IResourceError ... iResourceErrorArray) {
        if (iResourceErrorArray == null) {
            throw new NullPointerException("resourceErrors");
        }
        for (IResourceError iResourceError : iResourceErrorArray) {
            if (iResourceError == null) {
                throw new NullPointerException("resourceError");
            }
            this.m_aErrors.add(iResourceError);
        }
    }

    public ResourceErrorGroup(@Nonnull Iterable<? extends IResourceError> iterable) {
        if (iterable == null) {
            throw new NullPointerException("resourceErrors");
        }
        for (IResourceError iResourceError : iterable) {
            if (iResourceError == null) {
                throw new NullPointerException("resourceError");
            }
            this.m_aErrors.add(iResourceError);
        }
    }

    @Nonnull
    public ResourceErrorGroup addResourceError(@Nonnull IResourceError iResourceError) {
        if (iResourceError == null) {
            throw new NullPointerException("resourceError");
        }
        this.m_aErrors.add(iResourceError);
        return this;
    }

    @Nonnull
    public ResourceErrorGroup addResourceErrorGroup(@Nonnull IResourceErrorGroup iResourceErrorGroup) {
        if (iResourceErrorGroup == null) {
            throw new NullPointerException("resourceErrorGroup");
        }
        this.m_aErrors.addAll(iResourceErrorGroup.getAllResourceErrors());
        return this;
    }

    @Override
    public boolean containsOnlySuccess() {
        if (this.m_aErrors.isEmpty()) {
            return false;
        }
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isFailure()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneSuccess() {
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isSuccess()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnegative
    public int getSuccessCount() {
        int n = 0;
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isSuccess()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean containsOnlyFailure() {
        if (this.m_aErrors.isEmpty()) {
            return false;
        }
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isSuccess()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneFailure() {
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isFailure()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnegative
    public int getFailureCount() {
        int n = 0;
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isFailure()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean containsOnlyError() {
        if (this.m_aErrors.isEmpty()) {
            return false;
        }
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isNoError()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneError() {
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnegative
    public int getErrorCount() {
        int n = 0;
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isError()) continue;
            ++n;
        }
        return n;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ResourceErrorGroup getAllFailures() {
        ResourceErrorGroup resourceErrorGroup = new ResourceErrorGroup();
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isFailure()) continue;
            resourceErrorGroup.addResourceError(iResourceError);
        }
        return resourceErrorGroup;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ResourceErrorGroup getAllErrors() {
        ResourceErrorGroup resourceErrorGroup = new ResourceErrorGroup();
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isError()) continue;
            resourceErrorGroup.addResourceError(iResourceError);
        }
        return resourceErrorGroup;
    }

    @Override
    @Nonnull
    public EErrorLevel getMostSevereErrorLevel() {
        EErrorLevel eErrorLevel = EErrorLevel.SUCCESS;
        for (IResourceError iResourceError : this.m_aErrors) {
            if (eErrorLevel != null && !iResourceError.getErrorLevel().isMoreSevereThan(eErrorLevel)) continue;
            eErrorLevel = iResourceError.getErrorLevel();
        }
        return eErrorLevel;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aErrors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aErrors.isEmpty();
    }

    @Override
    @Nonnull
    public ResourceErrorGroup getClone() {
        return new ResourceErrorGroup(this.m_aErrors);
    }

    @Override
    @Nonnull
    public Iterator<IResourceError> iterator() {
        return this.m_aErrors.iterator();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IResourceError> getAllResourceErrors() {
        return ContainerHelper.newList(this.m_aErrors);
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aErrors.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aErrors.clear();
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ResourceErrorGroup)) {
            return false;
        }
        ResourceErrorGroup resourceErrorGroup = (ResourceErrorGroup)object;
        return ((Object)this.m_aErrors).equals(resourceErrorGroup.m_aErrors);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aErrors)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("errors", this.m_aErrors).toString();
    }
}

