/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.jaxb.utils;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.error.IResourceErrorGroup;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.IWritableResource;
import com.phloc.commons.jaxb.JAXBContextCache;
import com.phloc.commons.jaxb.validation.AbstractValidationEventHandler;
import com.phloc.commons.jaxb.validation.CollectingLoggingValidationEventHandlerFactory;
import com.phloc.commons.jaxb.validation.CollectingValidationEventHandler;
import com.phloc.commons.jaxb.validation.IValidationEventHandlerFactory;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.xml.XMLFactory;
import com.phloc.commons.xml.schema.XMLSchemaCache;
import com.phloc.commons.xml.transform.ResourceStreamResult;
import com.phloc.commons.xml.transform.TransformSourceFactory;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public abstract class AbstractJAXBMarshaller<JAXBTYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractJAXBMarshaller.class);
    private final Class<JAXBTYPE> m_aType;
    private final IReadableResource[] m_aXSDs;
    private IValidationEventHandlerFactory m_aVEHFactory = new CollectingLoggingValidationEventHandlerFactory();
    private ValidationEventHandler m_aLastEventHandler;

    protected AbstractJAXBMarshaller(@Nonnull Class<JAXBTYPE> clazz, @Nonnull @Nonempty List<? extends IReadableResource> list) {
        if (clazz == null) {
            throw new NullPointerException("type");
        }
        this.m_aType = clazz;
        this.m_aXSDs = ArrayHelper.newArray(list, IReadableResource.class);
    }

    public final void setValidationEventHandlerFactory(@Nullable IValidationEventHandlerFactory iValidationEventHandlerFactory) {
        this.m_aVEHFactory = iValidationEventHandlerFactory;
    }

    @Nullable
    public final IValidationEventHandlerFactory getValidationEventHandlerFactory() {
        return this.m_aVEHFactory;
    }

    @Nullable
    public final ValidationEventHandler getLastValidationEventHandler() {
        return this.m_aLastEventHandler;
    }

    @Nullable
    public final CollectingValidationEventHandler getCollectingValidationEventHandler() {
        ValidationEventHandler validationEventHandler = this.m_aLastEventHandler;
        while (validationEventHandler != null) {
            if (validationEventHandler instanceof CollectingValidationEventHandler) {
                return (CollectingValidationEventHandler)validationEventHandler;
            }
            if (validationEventHandler instanceof AbstractValidationEventHandler) {
                validationEventHandler = ((AbstractValidationEventHandler)validationEventHandler).getWrappedHandler();
                continue;
            }
            validationEventHandler = null;
        }
        return null;
    }

    @Nullable
    public final IResourceErrorGroup getLastValidationErrors() {
        CollectingValidationEventHandler collectingValidationEventHandler = this.getCollectingValidationEventHandler();
        return collectingValidationEventHandler == null ? null : collectingValidationEventHandler.getResourceErrors();
    }

    @Nonnull
    public final EChange clearLastValidationErrors() {
        CollectingValidationEventHandler collectingValidationEventHandler = this.getCollectingValidationEventHandler();
        return collectingValidationEventHandler == null ? EChange.UNCHANGED : collectingValidationEventHandler.clearResourceErrors();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public final List<IReadableResource> getOriginalXSDs() {
        return ContainerHelper.newList(this.m_aXSDs);
    }

    @OverrideOnDemand
    protected boolean useJAXContextCache() {
        return true;
    }

    @Nullable
    @OverrideOnDemand
    protected Schema createValidationSchema() {
        return ArrayHelper.isEmpty(this.m_aXSDs) ? null : XMLSchemaCache.getInstance().getSchema(this.m_aXSDs);
    }

    @Nonnull
    private Unmarshaller _createUnmarshaller() throws JAXBException {
        Package package_ = this.m_aType.getPackage();
        JAXBContext jAXBContext = this.useJAXContextCache() ? (JAXBContext)JAXBContextCache.getInstance().getFromCache(package_) : JAXBContext.newInstance((String)package_.getName());
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        if (this.m_aVEHFactory != null) {
            this.m_aLastEventHandler = this.m_aVEHFactory.create(unmarshaller.getEventHandler());
            unmarshaller.setEventHandler(this.m_aLastEventHandler);
        } else {
            this.m_aLastEventHandler = null;
        }
        Schema schema = this.createValidationSchema();
        if (schema != null) {
            unmarshaller.setSchema(schema);
        }
        return unmarshaller;
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return this.read(TransformSourceFactory.create(file));
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull IReadableResource iReadableResource) {
        if (iReadableResource == null) {
            throw new NullPointerException("resource");
        }
        return this.read(TransformSourceFactory.create(iReadableResource));
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        return this.read(TransformSourceFactory.create(node));
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull Source source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        try {
            Unmarshaller unmarshaller = this._createUnmarshaller();
            return (JAXBTYPE)unmarshaller.unmarshal(source, this.m_aType).getValue();
        }
        catch (UnmarshalException unmarshalException) {
            s_aLogger.error("Unmarshal exception reading document", (Throwable)unmarshalException);
        }
        catch (JAXBException jAXBException) {
            s_aLogger.warn("JAXB Exception reading document", (Throwable)jAXBException);
        }
        return null;
    }

    @Nonnull
    private Marshaller _createMarshaller() throws JAXBException {
        Package package_ = this.m_aType.getPackage();
        JAXBContext jAXBContext = this.useJAXContextCache() ? (JAXBContext)JAXBContextCache.getInstance().getFromCache(package_) : JAXBContext.newInstance((String)package_.getName());
        Marshaller marshaller = jAXBContext.createMarshaller();
        if (this.m_aVEHFactory != null) {
            this.m_aLastEventHandler = this.m_aVEHFactory.create(marshaller.getEventHandler());
            marshaller.setEventHandler(this.m_aLastEventHandler);
        } else {
            this.m_aLastEventHandler = null;
        }
        Schema schema = this.createValidationSchema();
        if (schema != null) {
            marshaller.setSchema(schema);
        }
        return marshaller;
    }

    @Nonnull
    protected abstract JAXBElement<JAXBTYPE> wrapObject(@Nonnull JAXBTYPE var1);

    @Nullable
    public final Document write(@Nonnull JAXBTYPE JAXBTYPE) {
        if (JAXBTYPE == null) {
            throw new NullPointerException("object");
        }
        Document document = XMLFactory.newDocument();
        return this.write(JAXBTYPE, new DOMResult(document)).isSuccess() ? document : null;
    }

    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull File file) {
        return this.write(JAXBTYPE, new StreamResult(file));
    }

    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull IWritableResource iWritableResource) {
        return this.write(JAXBTYPE, new ResourceStreamResult(iWritableResource));
    }

    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull Result result) {
        if (JAXBTYPE == null) {
            throw new NullPointerException("object");
        }
        if (result == null) {
            throw new NullPointerException("result");
        }
        try {
            Marshaller marshaller = this._createMarshaller();
            JAXBElement<JAXBTYPE> jAXBElement = this.wrapObject(JAXBTYPE);
            marshaller.marshal(jAXBElement, result);
            return ESuccess.SUCCESS;
        }
        catch (MarshalException marshalException) {
            s_aLogger.error("Marshal exception writing object", (Throwable)marshalException);
        }
        catch (JAXBException jAXBException) {
            s_aLogger.warn("JAXB Exception writing object", (Throwable)jAXBException);
        }
        return ESuccess.FAILURE;
    }
}

