/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntIterator;

public abstract class AbstractIntCollection
implements IntCollection {
    protected AbstractIntCollection() {
    }

    @Override
    @Nonnull
    public abstract IntIterator iterator();

    @Override
    @Nonnegative
    public abstract int size();

    @Override
    public boolean add(int n) {
        throw new UnsupportedOperationException("add(int) is not supported.");
    }

    @Override
    public boolean addAll(@Nonnull IntCollection intCollection) {
        boolean bl = false;
        IntIterator intIterator = intCollection.iterator();
        while (intIterator.hasNext()) {
            bl |= this.add(intIterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            intIterator.next();
            intIterator.remove();
        }
    }

    @Override
    public boolean contains(int n) {
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intIterator.next() != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nonnull IntCollection intCollection) {
        IntIterator intIterator = intCollection.iterator();
        while (intIterator.hasNext()) {
            if (this.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public boolean removeElement(int n) {
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intIterator.next() != n) continue;
            intIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@Nonnull IntCollection intCollection) {
        boolean bl = false;
        IntIterator intIterator = intCollection.iterator();
        while (intIterator.hasNext()) {
            bl |= this.removeElement(intIterator.next());
        }
        return bl;
    }

    @Override
    public boolean retainAll(@Nonnull IntCollection intCollection) {
        boolean bl = false;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intCollection.contains(intIterator.next())) continue;
            intIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public int[] toArray() {
        int[] nArray = new int[this.size()];
        int n = 0;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            nArray[n++] = intIterator.next();
        }
        return nArray;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public int[] toArray(@Nonnull int[] nArray) {
        if (nArray.length < this.size()) {
            return this.toArray();
        }
        int n = 0;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            nArray[n++] = intIterator.next();
        }
        return nArray;
    }
}

