/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.collections.primitives.IntListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableIntIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableIntList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableIntListIterator;

public final class IntCollections {
    public static final IntList EMPTY_INT_LIST = IntCollections.unmodifiableIntList(new ArrayIntList(0));
    public static final IntIterator EMPTY_INT_ITERATOR = IntCollections.unmodifiableIntIterator(EMPTY_INT_LIST.iterator());
    public static final IntListIterator EMPTY_INT_LIST_ITERATOR = IntCollections.unmodifiableIntListIterator(EMPTY_INT_LIST.listIterator());

    private IntCollections() {
    }

    @Nonnull
    public static IntList singletonIntList(int n) {
        ArrayIntList arrayIntList = new ArrayIntList(1);
        arrayIntList.add(n);
        return UnmodifiableIntList.wrap(arrayIntList);
    }

    @Nonnull
    public static IntIterator singletonIntIterator(int n) {
        return IntCollections.singletonIntList(n).iterator();
    }

    @Nonnull
    public static IntListIterator singletonIntListIterator(int n) {
        return IntCollections.singletonIntList(n).listIterator();
    }

    @Nonnull
    public static IntList unmodifiableIntList(@Nonnull IntList intList) throws NullPointerException {
        if (null == intList) {
            throw new NullPointerException();
        }
        return UnmodifiableIntList.wrap(intList);
    }

    @Nonnull
    public static IntIterator unmodifiableIntIterator(@Nonnull IntIterator intIterator) {
        if (null == intIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableIntIterator.wrap(intIterator);
    }

    @Nonnull
    public static IntListIterator unmodifiableIntListIterator(@Nonnull IntListIterator intListIterator) {
        if (null == intListIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableIntListIterator.wrap(intListIterator);
    }

    @Nonnull
    public static IntList getEmptyIntList() {
        return EMPTY_INT_LIST;
    }

    @Nonnull
    public static IntIterator getEmptyIntIterator() {
        return EMPTY_INT_ITERATOR;
    }

    @Nonnull
    public static IntListIterator getEmptyIntListIterator() {
        return EMPTY_INT_LIST_ITERATOR;
    }
}

