/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.math.BigInteger;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RenditionDataImpl;

public class RenditionImpl
extends RenditionDataImpl
implements Rendition {
    private static final long serialVersionUID = 1L;
    private final Session session;
    private final String objectId;

    public RenditionImpl(Session session, String objectId, String streamId, String renditionDocumentId, String kind, long length, String mimeType, String title, int height, int width) {
        super(streamId, mimeType, BigInteger.valueOf(length), kind, title, BigInteger.valueOf(width), BigInteger.valueOf(height), renditionDocumentId);
        this.session = session;
        this.objectId = objectId;
    }

    public long getLength() {
        return this.length == null ? -1L : this.length.longValue();
    }

    public long getHeight() {
        return this.height == null ? -1L : this.height.longValue();
    }

    public long getWidth() {
        return this.width == null ? -1L : this.width.longValue();
    }

    public Document getRenditionDocument() {
        return this.getRenditionDocument(this.session.getDefaultContext());
    }

    public Document getRenditionDocument(OperationContext context) {
        if (this.renditionDocumentId == null) {
            return null;
        }
        CmisObject rendDoc = this.session.getObject(this.renditionDocumentId, context);
        if (!(rendDoc instanceof Document)) {
            return null;
        }
        return (Document)rendDoc;
    }

    public ContentStream getContentStream() {
        BigInteger bigLength;
        ContentStream contentStream;
        if (this.objectId == null || this.streamId == null) {
            return null;
        }
        try {
            contentStream = this.session.getBinding().getObjectService().getContentStream(this.session.getRepositoryInfo().getId(), this.objectId, this.streamId, null, null, null);
        }
        catch (CmisConstraintException e) {
            return null;
        }
        if (contentStream == null) {
            return null;
        }
        String filename = contentStream.getFileName();
        if (filename == null) {
            filename = this.getTitle();
        }
        if ((bigLength = contentStream.getBigLength()) == null) {
            bigLength = this.getBigLength();
        }
        long length = bigLength == null ? -1L : bigLength.longValue();
        return this.session.getObjectFactory().createContentStream(filename, length, contentStream.getMimeType(), contentStream.getStream());
    }
}

