/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.rest.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.automation.server.AutomationServerComponent;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;

@Provider
@Consumes(value={"application/json+nxentity", "application/json"})
public class JSONDocumentModelReader
implements MessageBodyReader<DocumentModel> {
    @Context
    HttpServletRequest request;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DocumentModel.class.isAssignableFrom(type);
    }

    public DocumentModel readFrom(Class<DocumentModel> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String content = IOUtils.toString((InputStream)entityStream);
        if (content.isEmpty()) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            return this.readRequest(content, httpHeaders);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DocumentModel readRequest(String content, MultivaluedMap<String, String> httpHeaders) throws Exception {
        JsonParser jp = AutomationServerComponent.me.getFactory().createJsonParser(content);
        jp.nextToken();
        JsonToken tok = jp.nextToken();
        SimpleDocumentModel tmp = new SimpleDocumentModel();
        String id = null;
        String type = null;
        while (tok != JsonToken.END_OBJECT) {
            String entityType;
            String key = jp.getCurrentName();
            jp.nextToken();
            if ("uid".equals(key)) {
                id = (String)jp.readValueAs(String.class);
            } else if ("properties".equals(key)) {
                this.readProperties(jp, (DocumentModel)tmp);
            } else if ("type".equals(key)) {
                type = (String)jp.readValueAs(String.class);
            } else if ("entity-type".equals(key) && !"document".equals(entityType = (String)jp.readValueAs(String.class))) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            tok = jp.nextToken();
        }
        CoreSession session = SessionFactory.getSession((HttpServletRequest)this.request);
        DocumentModelImpl doc = null;
        if (StringUtils.isNotBlank(id)) {
            if (!session.exists((DocumentRef)new IdRef(id))) throw new WebApplicationException(Response.Status.NOT_FOUND);
            doc = session.getDocument((DocumentRef)new IdRef(id));
        } else {
            if (!StringUtils.isNotBlank(type)) throw new WebApplicationException(Response.Status.BAD_REQUEST);
            doc = DocumentModelFactory.createDocumentModel(type);
        }
        for (String schema : tmp.getSchemas()) {
            DataModel dataModel = doc.getDataModel(schema);
            DataModel fromDataModel = tmp.getDataModel(schema);
            for (String field : fromDataModel.getDirtyFields()) {
                Serializable data = (Serializable)fromDataModel.getData(field);
                if (data == null || "null".equals(data)) continue;
                dataModel.setData(field, (Object)data);
            }
        }
        return doc;
    }

    protected void readProperties(JsonParser jp, DocumentModel doc) throws Exception {
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            tok = jp.nextToken();
            if (tok == JsonToken.START_ARRAY) {
                doc.setPropertyValue(key, (Serializable)((Object)this.readArrayProperty(jp)));
            } else if (tok == JsonToken.START_OBJECT) {
                doc.setPropertyValue(key, (Serializable)((Object)this.readObjectProperty(jp)));
            } else if (tok == JsonToken.VALUE_NULL) {
                doc.setPropertyValue(key, (Serializable)((Object)((String)null)));
            } else {
                doc.setPropertyValue(key, (Serializable)((Object)jp.getText()));
            }
            tok = jp.nextToken();
        }
    }

    protected Map<String, Serializable> readObjectProperty(JsonParser jp) throws Exception {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        this.readProperties(jp, map);
        return map;
    }

    protected void readProperties(JsonParser jp, Map<String, Serializable> map) throws Exception {
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            tok = jp.nextToken();
            if (tok == JsonToken.START_ARRAY) {
                map.put(key, (Serializable)((Object)this.readArrayProperty(jp)));
            } else if (tok == JsonToken.START_OBJECT) {
                map.put(key, (Serializable)((Object)this.readObjectProperty(jp)));
            } else if (tok == JsonToken.VALUE_NULL) {
                map.put(key, (Serializable)((Object)((String)null)));
            } else {
                map.put(key, (Serializable)((Object)jp.getText()));
            }
            tok = jp.nextToken();
        }
    }

    protected List<Serializable> readArrayProperty(JsonParser jp) throws Exception {
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_ARRAY) {
            if (tok == JsonToken.START_ARRAY) {
                list.add((Serializable)((Object)this.readArrayProperty(jp)));
            } else if (tok == JsonToken.START_OBJECT) {
                list.add((Serializable)((Object)this.readObjectProperty(jp)));
            } else {
                list.add((Serializable)((Object)jp.getText()));
            }
            tok = jp.nextToken();
        }
        return list;
    }
}

