/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.rest.jaxrs.adapters;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.jaxrs.ExceptionHandler;
import org.nuxeo.ecm.automation.server.jaxrs.ExecutionRequest;
import org.nuxeo.ecm.automation.server.jaxrs.ResponseHelper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="op", type="OperationService")
@Produces(value={"application/json+nxentity", "application/json"})
public class OperationAdapter
extends DefaultAdapter {
    public static final String NAME = "op";

    @POST
    @Path(value="{operationName}")
    public Response doPost(@PathParam(value="operationName") String oid, @Context HttpServletRequest request, ExecutionRequest xreq) {
        try {
            AutomationServer srv = (AutomationServer)Framework.getLocalService(AutomationServer.class);
            if (!srv.accept(oid, this.isChain(oid), request)) {
                return ResponseHelper.notFound();
            }
            AutomationService service = (AutomationService)Framework.getLocalService(AutomationService.class);
            DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
            if (doc != null) {
                xreq.setInput((Object)doc);
            } else {
                DocumentModelList docs = (DocumentModelList)this.getTarget().getAdapter(DocumentModelList.class);
                xreq.setInput((Object)docs);
            }
            OperationContext ctx = xreq.createContext(request, this.getContext().getCoreSession());
            ctx.putAll(xreq.getParams());
            OperationChain chain = this.getOperationChain(service, oid, xreq.getParams());
            return Response.ok((Object)service.run(ctx, chain)).build();
        }
        catch (Throwable e) {
            throw ExceptionHandler.newException((String)("Failed to execute operation: " + oid), (Throwable)e);
        }
    }

    private boolean isChain(String oid) {
        return oid.startsWith("Chain.");
    }

    private OperationChain getOperationChain(AutomationService service, String oid, Map<String, Object> params) throws OperationNotFoundException {
        if (this.isChain(oid)) {
            return service.getOperationChain(this.getRealChainId(oid));
        }
        OperationChain chain = new OperationChain("operation");
        OperationParameters oparams = new OperationParameters(oid, params);
        chain.add(oparams);
        return chain;
    }

    private String getRealChainId(String oid) {
        return this.isChain(oid) ? oid.substring(6) : oid;
    }
}

