/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.rest.jaxrs.adapters;

import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import org.nuxeo.ecm.automation.core.operations.services.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

public abstract class PaginableAdapter
extends DefaultAdapter {
    protected Long page;
    protected Long pageSize;
    protected String maxResults;

    protected void initialize(Object ... args) {
        super.initialize(args);
        HttpServletRequest request = this.ctx.getRequest();
        this.page = this.extractLongParam(request, "page", 0L);
        this.pageSize = this.extractLongParam(request, "pageSize", 50L);
        this.maxResults = request.getParameter("maxResults");
    }

    public <A> A getAdapter(Class<A> adapter) {
        if (adapter.isAssignableFrom(DocumentModelList.class)) {
            try {
                return adapter.cast(this.getDocs());
            }
            catch (ClientException e) {
                return null;
            }
        }
        return (A)super.getAdapter(adapter);
    }

    protected abstract PageProviderDefinition getPageProviderDefinition();

    protected Object[] getParams() {
        return new Object[0];
    }

    @GET
    public DocumentModelList getDocs() throws ClientException {
        PageProviderDefinition ppDefinition = this.getPageProviderDefinition();
        if (ppDefinition == null) {
            throw new ClientException("Page provider given not found");
        }
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.ctx.getCoreSession());
        return new PaginableDocumentModelListImpl(pps.getPageProvider("", ppDefinition, null, null, this.pageSize, this.page, props, this.getParams()), "restdocid");
    }

    protected Long extractLongParam(HttpServletRequest request, String paramName, Long defaultValue) {
        String strParam = request.getParameter(paramName);
        return strParam == null ? defaultValue : Long.parseLong(strParam);
    }
}

