/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.rest.jaxrs.adapters;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.automation.rest.jaxrs.adapters.PaginableAdapter;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;

@WebAdapter(name="search", type="SearchService")
@Produces(value={"application/json+nxentity", "application/json"})
public class SearchAdapter
extends PaginableAdapter {
    public static final String NAME = "search";

    private String extractQueryFromRequest(HttpServletRequest request) {
        String query = request.getParameter("query");
        if (query == null) {
            DocumentModel doc;
            String fullText = request.getParameter("fullText");
            if (fullText == null) {
                throw new IllegalParameterException("Expecting a query or a fullText parameter");
            }
            String orderBy = request.getParameter("orderBy");
            String orderClause = "";
            if (orderBy != null) {
                orderClause = " ORDER BY " + orderBy;
            }
            String path = (doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class)).isFolder() ? doc.getPathAsString() : doc.getPath().removeLastSegments(1).toString();
            query = "SELECT * FROM Document WHERE (ecm:fulltext = \"" + fullText + "\") AND (ecm:isCheckedInVersion = 0) AND (ecm:path STARTSWITH \"" + path + "\")" + orderClause;
        }
        return query;
    }

    @Override
    protected PageProviderDefinition getPageProviderDefinition() {
        String query = this.extractQueryFromRequest(this.ctx.getRequest());
        CoreQueryPageProviderDescriptor desc = new CoreQueryPageProviderDescriptor();
        desc.setPattern(query);
        if (this.maxResults != null && !this.maxResults.isEmpty() && !this.maxResults.equals("-1")) {
            desc.getProperties().put("maxResults", this.maxResults);
        }
        return desc;
    }
}

