/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.download;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBlob;
import org.nuxeo.ecm.platform.web.common.ServletHelper;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.BufferingServletOutputStream;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DownloadServlet
extends HttpServlet {
    private static final String NXDOWNLOADINFO_PREFIX = "nxdownloadinfo";
    private static final String NXBIGFILE_PREFIX = "nxbigfile";
    protected static final int BUFFER_SIZE = 524288;
    protected static final int MIN_BUFFER_SIZE = 65536;
    protected static final Blob BLOB_NOT_FOUND = new StringBlob("404");
    private static final long serialVersionUID = 986876871L;
    private static final Log log = LogFactory.getLog(DownloadServlet.class);

    private static CoreSession getCoreSession(String repoName) throws Exception {
        RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
        Repository repo = rm.getRepository(repoName);
        if (repo == null) {
            throw new ClientException("Unable to get " + repoName + " repository");
        }
        return repo.open();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestURI;
        try {
            requestURI = new URI(req.getRequestURI()).getPath();
        }
        catch (URISyntaxException e1) {
            requestURI = req.getRequestURI();
        }
        if (requestURI.contains("/nxbigfile/")) {
            this.handleDownloadSingleDocument(req, resp, requestURI);
        } else if (requestURI.contains("/nxdownloadinfo/")) {
            this.handleGetDownloadInfo(req, resp, requestURI);
        } else if (requestURI.contains("/nxbigzipfile/")) {
            this.handleDownloadTemporaryZip(req, resp, requestURI);
        }
    }

    /*
     * Loose catch block
     */
    private Blob resolveBlob(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws ServletException {
        String completePath;
        int idx;
        String[] alternatePath;
        String filePath = requestURI.replace(VirtualHostHelper.getContextPath((ServletRequest)req) + "/" + NXBIGFILE_PREFIX + "/", "");
        String[] pathParts = filePath.split("/");
        String repoName = pathParts[0];
        String docId = pathParts[1];
        String fieldPath = "blobholder:0";
        if (pathParts.length > 2) {
            fieldPath = pathParts[2];
        }
        String fileName = null;
        if (pathParts.length > 3) {
            fileName = pathParts[3];
        }
        if ((alternatePath = filePath.split(docId)).length > 1 && (idx = (completePath = alternatePath[1]).lastIndexOf(47)) > 0) {
            fieldPath = completePath.substring(1, idx);
            fileName = completePath.substring(idx + 1);
        }
        CoreSession session = null;
        boolean tx = false;
        try {
            if (!TransactionHelper.isTransactionActive()) {
                tx = TransactionHelper.startTransaction();
            }
            session = DownloadServlet.getCoreSession(repoName);
            DocumentModel doc = session.getDocument((DocumentRef)new IdRef(docId));
            Blob blob = null;
            if (fieldPath != null) {
                if ((fieldPath = fieldPath.replace(';', ':')).startsWith("blobholder")) {
                    BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
                    if (bh == null) {
                        Blob blob2 = null;
                        return blob2;
                    }
                    String bhPath = fieldPath.replace("blobholder:", "");
                    if ("".equals(bhPath) || "0".equals(bhPath)) {
                        blob = bh.getBlob();
                    } else {
                        int idxbh = Integer.parseInt(bhPath);
                        blob = (Blob)bh.getBlobs().get(idxbh);
                    }
                } else {
                    try {
                        blob = (Blob)doc.getPropertyValue(fieldPath);
                    }
                    catch (PropertyNotFoundException e) {
                        log.debug((Object)e.getMessage());
                        Blob blob3 = BLOB_NOT_FOUND;
                        if (session != null) {
                            CoreInstance.getInstance().close(session);
                        }
                        if (tx) {
                            TransactionHelper.commitOrRollbackTransaction();
                        }
                        return blob3;
                    }
                    catch (ClientException e) {
                        Blob blob4;
                        block28: {
                            log.debug((Object)e.getMessage());
                            blob4 = null;
                            if (session == null) break block28;
                            CoreInstance.getInstance().close(session);
                        }
                        if (tx) {
                            TransactionHelper.commitOrRollbackTransaction();
                        }
                        return blob4;
                    }
                }
            }
            if (fileName != null && !fileName.isEmpty()) {
                blob.setFilename(fileName);
            }
            Blob blob5 = blob;
            return blob5;
            {
                catch (Exception e) {
                    if (tx) {
                        TransactionHelper.setTransactionRollbackOnly();
                    }
                    throw new ServletException((Throwable)e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (session != null) {
                CoreInstance.getInstance().close(session);
            }
            if (tx) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    private void handleGetDownloadInfo(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws ServletException {
        String downloadUrl = requestURI.replace(NXDOWNLOADINFO_PREFIX, NXBIGFILE_PREFIX);
        Blob blob = this.resolveBlob(req, resp, downloadUrl);
        if (!this.isBlobFound(blob, resp)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        resp.setContentType("text/plain");
        try {
            sb.append(blob.getMimeType());
            sb.append(":");
            sb.append(URLEncoder.encode(blob.getFilename(), "UTF-8"));
            sb.append(":");
            sb.append(VirtualHostHelper.getServerURL((ServletRequest)req));
            sb.append(downloadUrl.substring(1));
            resp.getWriter().write(sb.toString());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private boolean isBlobFound(Blob blob, HttpServletResponse resp) throws ServletException {
        if (blob == null) {
            try {
                resp.sendError(204, "No Blob found");
                return false;
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (BLOB_NOT_FOUND.equals(blob)) {
            try {
                resp.sendError(404, "No Blob found");
                return false;
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return true;
    }

    private void handleDownloadSingleDocument(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws ServletException {
        Blob blob = this.resolveBlob(req, resp, requestURI);
        if (!this.isBlobFound(blob, resp)) {
            return;
        }
        try {
            this.downloadBlob(req, resp, blob, null);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void downloadBlob(HttpServletRequest req, HttpServletResponse resp, Blob blob, String fileName) throws IOException, ServletException {
        block25: {
            InputStream in = blob.getStream();
            ServletOutputStream out = resp.getOutputStream();
            try {
                String previousToken;
                String digest = null;
                if (blob instanceof SQLBlob) {
                    digest = ((SQLBlob)blob).getBinary().getDigest();
                }
                if ((previousToken = req.getHeader("If-None-Match")) != null && previousToken.equals(digest)) {
                    resp.sendError(304);
                    break block25;
                }
                resp.setHeader("ETag", digest);
                if (fileName == null || fileName.length() == 0) {
                    fileName = blob.getFilename() != null && blob.getFilename().length() > 0 ? blob.getFilename() : "file";
                }
                resp.setHeader("Content-Disposition", ServletHelper.getRFC2231ContentDisposition(req, fileName));
                resp.setContentType(blob.getMimeType());
                long fileSize = blob.getLength();
                if (fileSize <= 0L) break block25;
                String range = req.getHeader("Range");
                ByteRange byteRange = null;
                if (range != null) {
                    try {
                        byteRange = DownloadServlet.parseRange(range, fileSize);
                    }
                    catch (ClientException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (byteRange != null) {
                    resp.setHeader("Accept-Ranges", "bytes");
                    resp.setHeader("Content-Range", "bytes " + byteRange.getStart() + "-" + byteRange.getEnd() + "/" + fileSize);
                    long length = byteRange.getLength();
                    if (length < Integer.MAX_VALUE) {
                        resp.setContentLength((int)length);
                    }
                    resp.setStatus(206);
                    DownloadServlet.writeStream(in, (OutputStream)out, byteRange);
                } else {
                    if (fileSize < Integer.MAX_VALUE) {
                        resp.setContentLength((int)fileSize);
                    }
                    DownloadServlet.writeStream(in, (OutputStream)out, new ByteRange(0L, fileSize - 1L));
                }
            }
            catch (IOException ioe) {
                this.handleClientDisconnect(ioe);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                if (resp != null) {
                    try {
                        resp.flushBuffer();
                    }
                    catch (IOException ioe) {
                        this.handleClientDisconnect(ioe);
                    }
                }
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    public void handleClientDisconnect(IOException ioe) throws IOException {
        if (!ExceptionHelper.isClientAbortError(ioe)) {
            throw ioe;
        }
        log.debug((Object)("Client disconnected: " + ioe.getMessage()));
    }

    private void handleDownloadTemporaryZip(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws IOException, ServletException {
        String filePath = requestURI.replace(VirtualHostHelper.getContextPath((ServletRequest)req) + "/nxbigzipfile/", "");
        String[] pathParts = filePath.split("/");
        String tmpFileName = pathParts[0];
        File tmpZip = new File(System.getProperty("java.io.tmpdir") + "/" + tmpFileName);
        FileBlob zipBlob = new FileBlob(tmpZip);
        try {
            this.downloadBlob(req, resp, (Blob)zipBlob, "clipboard.zip");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            tmpZip.delete();
        }
    }

    public static void writeStream(InputStream in, OutputStream out, ByteRange range) throws IOException {
        long read;
        long offset;
        BufferingServletOutputStream.stopBuffering(out);
        byte[] buffer = new byte[524288];
        in.skip(offset);
        for (offset = range.getStart(); offset <= range.getEnd() && (read = (long)in.read(buffer)) != -1L; offset += 524288L) {
            read = Math.min(read, range.getEnd() - offset + 1L);
            out.write(buffer, 0, (int)read);
            out.flush();
        }
    }

    public static ByteRange parseRange(String range, long fileSize) throws ClientException {
        if (!range.startsWith("bytes=") || range.indexOf(44) >= 0) {
            throw new ClientException("Cannot parse range : " + range);
        }
        int sepIndex = range.indexOf(45, 6);
        if (sepIndex < 0) {
            throw new ClientException("Cannot parse range : " + range);
        }
        String start = range.substring(6, sepIndex).trim();
        String end = range.substring(sepIndex + 1).trim();
        long rangeStart = 0L;
        long rangeEnd = fileSize - 1L;
        if (start.isEmpty()) {
            if (end.isEmpty()) {
                throw new ClientException("Cannot parse range : " + range);
            }
            rangeStart = fileSize - (long)Integer.parseInt(end);
            if (rangeStart < 0L) {
                rangeStart = 0L;
            }
        } else {
            rangeStart = Integer.parseInt(start);
            if (!end.isEmpty()) {
                rangeEnd = Integer.parseInt(end);
            }
        }
        if (rangeStart > rangeEnd) {
            throw new ClientException("Cannot parse range : " + range);
        }
        return new ByteRange(rangeStart, rangeEnd);
    }

    public static class ByteRange {
        private long start;
        private long end;

        public ByteRange(long rangeStart, long rangeEnd) {
            this.start = rangeStart;
            this.end = rangeEnd;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public long getLength() {
            return this.end - this.start + 1L;
        }
    }
}

