/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelListener;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelRowEvent;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;

@Name(value="orderableDocumentActions")
@Scope(value=ScopeType.CONVERSATION)
public class OrderableDocumentActions
implements SelectDataModelListener,
Serializable {
    private static final Log log = LogFactory.getLog(OrderableDocumentActions.class);
    public static final String CURRENT_DOC_ORDERED_CHILDREN_QM = "CURRENT_DOC_ORDERED_CHILDREN";
    public static final String CHILDREN_DOCUMENT_LIST = "CHILDREN_DOCUMENT_LIST";
    public static final String SECTION_TYPE = "Section";
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(required=false, create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(required=false, create=true)
    protected transient ResultsProvidersCache resultsProvidersCache;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;

    @Factory(value="currentOrderedChildrenSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel getCurrentOrderedChildrenSelectModel() throws ClientException {
        DocumentModelList documents = this.getCurrentDocumentChildrenPage();
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        SelectDataModelImpl model = new SelectDataModelImpl(CHILDREN_DOCUMENT_LIST, (List)documents, selectedDocuments);
        model.addSelectModelListener((SelectDataModelListener)this);
        return model;
    }

    protected DocumentModelList getCurrentDocumentChildrenPage() throws ClientException {
        if (this.documentManager == null) {
            log.error((Object)"documentManager not initialized");
            return new DocumentModelListImpl();
        }
        PagedDocumentsProvider resultsProvider = this.getOrderedChildrenProvider();
        return resultsProvider.getCurrentPage();
    }

    protected PagedDocumentsProvider getOrderedChildrenProvider() throws ClientException {
        return this.resultsProvidersCache.get(CURRENT_DOC_ORDERED_CHILDREN_QM);
    }

    @Factory(value="sectionOrderedChildrenSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel getSectionOrderedChildrenSelectModel() throws ClientException {
        DocumentModelList documents = this.getCurrentDocumentChildrenPage();
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
        SelectDataModelImpl model = new SelectDataModelImpl(CHILDREN_DOCUMENT_LIST, (List)documents, selectedDocuments);
        model.addSelectModelListener((SelectDataModelListener)this);
        return model;
    }

    public void processSelectRowEvent(SelectDataModelRowEvent event) {
        Boolean selection = event.getSelected();
        DocumentModel data = (DocumentModel)event.getRowData();
        if (selection.booleanValue()) {
            this.documentsListsManager.addToWorkingList("CURRENT_SELECTION", data);
        } else {
            this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION", data);
        }
    }

    public boolean getCanMoveDown() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!this.isOrderable(currentDocument)) {
            return false;
        }
        if (SECTION_TYPE.equals(currentDocument.getType())) {
            return this.getCanMoveDown(currentDocument, "CURRENT_SELECTION_SECTIONS");
        }
        return this.getCanMoveDown(currentDocument, "CURRENT_SELECTION");
    }

    protected boolean getCanMoveDown(DocumentModel container, String documentsListName) throws ClientException {
        List docs = this.documentsListsManager.getWorkingList(documentsListName);
        if (docs.isEmpty() || docs.size() > 1) {
            return false;
        }
        DocumentModel selectedDocument = (DocumentModel)docs.get(0);
        List children = this.documentManager.getChildrenRefs(container.getRef(), null);
        int selectedDocumentIndex = children.indexOf(new IdRef(selectedDocument.getId()));
        int nextIndex = selectedDocumentIndex + 1;
        return nextIndex != children.size();
    }

    public String moveDown() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return null;
        }
        if (SECTION_TYPE.equals(currentDocument.getType())) {
            return this.moveDown(currentDocument, "CURRENT_SELECTION_SECTIONS");
        }
        return this.moveDown(currentDocument, "CURRENT_SELECTION");
    }

    protected String moveDown(DocumentModel container, String documentsListName) throws ClientException {
        DocumentModel selectedDocument = (DocumentModel)this.documentsListsManager.getWorkingList(documentsListName).get(0);
        List children = this.documentManager.getChildrenRefs(container.getRef(), null);
        int selectedDocumentIndex = children.indexOf(new IdRef(selectedDocument.getId()));
        int nextIndex = selectedDocumentIndex + 1;
        DocumentRef nextDocumentRef = (DocumentRef)children.get(nextIndex);
        this.documentManager.orderBefore(container.getRef(), this.documentManager.getDocument(nextDocumentRef).getName(), selectedDocument.getName());
        this.documentManager.save();
        this.notifyChildrenChanged(container);
        this.addFacesMessage("feedback.order.movedDown");
        return null;
    }

    protected void notifyChildrenChanged(DocumentModel containerDocument) throws ClientException {
        if (containerDocument != null) {
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{containerDocument});
        }
    }

    public boolean getCanMoveUp() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!this.isOrderable(currentDocument)) {
            return false;
        }
        if (SECTION_TYPE.equals(currentDocument.getType())) {
            return this.getCanMoveUp(currentDocument, "CURRENT_SELECTION_SECTIONS");
        }
        return this.getCanMoveUp(currentDocument, "CURRENT_SELECTION");
    }

    protected boolean getCanMoveUp(DocumentModel container, String documentsListName) throws ClientException {
        List docs = this.documentsListsManager.getWorkingList(documentsListName);
        if (docs.isEmpty() || docs.size() > 1) {
            return false;
        }
        DocumentModel selectedDocument = (DocumentModel)docs.get(0);
        List children = this.documentManager.getChildrenRefs(container.getRef(), null);
        int selectedDocumentIndex = children.indexOf(new IdRef(selectedDocument.getId()));
        int previousIndex = selectedDocumentIndex - 1;
        return previousIndex >= 0;
    }

    public String moveUp() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return null;
        }
        if (SECTION_TYPE.equals(currentDocument.getType())) {
            return this.moveUp(currentDocument, "CURRENT_SELECTION_SECTIONS");
        }
        return this.moveUp(currentDocument, "CURRENT_SELECTION");
    }

    protected String moveUp(DocumentModel container, String documentsListName) throws ClientException {
        DocumentModel selectedDocument = (DocumentModel)this.documentsListsManager.getWorkingList(documentsListName).get(0);
        List children = this.documentManager.getChildrenRefs(container.getRef(), null);
        int selectedDocumentIndex = children.indexOf(new IdRef(selectedDocument.getId()));
        int previousIndex = selectedDocumentIndex - 1;
        DocumentRef previousDocumentRef = (DocumentRef)children.get(previousIndex);
        this.documentManager.orderBefore(container.getRef(), selectedDocument.getName(), this.documentManager.getDocument(previousDocumentRef).getName());
        this.documentManager.save();
        this.notifyChildrenChanged(container);
        this.addFacesMessage("feedback.order.movedUp");
        return null;
    }

    public boolean getCanMoveToTop() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!this.isOrderable(currentDocument)) {
            return false;
        }
        if (SECTION_TYPE.equals(currentDocument.getType())) {
            return this.getCanMoveToTop(currentDocument, "CURRENT_SELECTION_SECTIONS");
        }
        return this.getCanMoveToTop(currentDocument, "CURRENT_SELECTION");
    }

    protected boolean getCanMoveToTop(DocumentModel container, String documentsListName) throws ClientException {
        List docs = this.documentsListsManager.getWorkingList(documentsListName);
        if (docs.isEmpty() || docs.size() > 1) {
            return false;
        }
        DocumentModel selectedDocument = (DocumentModel)docs.get(0);
        List children = this.documentManager.getChildrenRefs(container.getRef(), null);
        int selectedDocumentIndex = children.indexOf(new IdRef(selectedDocument.getId()));
        return selectedDocumentIndex > 0;
    }

    public String moveToTop() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return null;
        }
        if (SECTION_TYPE.equals(currentDocument.getType())) {
            return this.moveToTop(currentDocument, "CURRENT_SELECTION_SECTIONS");
        }
        return this.moveToTop(currentDocument, "CURRENT_SELECTION");
    }

    protected String moveToTop(DocumentModel container, String documentsListName) throws ClientException {
        DocumentModel selectedDocument = (DocumentModel)this.documentsListsManager.getWorkingList(documentsListName).get(0);
        List children = this.documentManager.getChildrenRefs(container.getRef(), null);
        DocumentRef firstDocumentRef = (DocumentRef)children.get(0);
        this.documentManager.orderBefore(container.getRef(), selectedDocument.getName(), this.documentManager.getDocument(firstDocumentRef).getName());
        this.documentManager.save();
        this.notifyChildrenChanged(container);
        this.addFacesMessage("feedback.order.movedToTop");
        return null;
    }

    public boolean getCanMoveToBottom() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!this.isOrderable(currentDocument)) {
            return false;
        }
        if (SECTION_TYPE.equals(currentDocument.getType())) {
            return this.getCanMoveToBottom(currentDocument, "CURRENT_SELECTION_SECTIONS");
        }
        return this.getCanMoveToBottom(currentDocument, "CURRENT_SELECTION");
    }

    protected boolean getCanMoveToBottom(DocumentModel container, String documentsListName) throws ClientException {
        List docs = this.documentsListsManager.getWorkingList(documentsListName);
        if (docs.isEmpty() || docs.size() > 1) {
            return false;
        }
        DocumentModel selectedDocument = (DocumentModel)docs.get(0);
        List children = this.documentManager.getChildrenRefs(container.getRef(), null);
        int selectedDocumentIndex = children.indexOf(new IdRef(selectedDocument.getId()));
        return selectedDocumentIndex < children.size() - 1;
    }

    public String moveToBottom() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return null;
        }
        if (SECTION_TYPE.equals(currentDocument.getType())) {
            return this.moveToBottom(currentDocument, "CURRENT_SELECTION_SECTIONS");
        }
        return this.moveToBottom(currentDocument, "CURRENT_SELECTION");
    }

    protected String moveToBottom(DocumentModel container, String documentsListName) throws ClientException {
        DocumentRef containerRef = container.getRef();
        DocumentModel selectedDocument = (DocumentModel)this.documentsListsManager.getWorkingList(documentsListName).get(0);
        this.documentManager.orderBefore(containerRef, selectedDocument.getName(), null);
        this.documentManager.save();
        this.notifyChildrenChanged(container);
        this.addFacesMessage("feedback.order.movedToBottom");
        return null;
    }

    protected boolean isOrderable(DocumentModel doc) {
        return doc.hasFacet("Orderable");
    }

    protected void addFacesMessage(String messageLabel) {
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get(messageLabel), new Object[0]);
    }

    @Observer(value={"documentSelectionChanged", "domainSelectionChanged", "contentRootSelectionChanged", "documentChildrenChanged"}, create=false)
    public void invalidateProviderOnDocumentChanged() {
        this.resultsProvidersCache.invalidate(CURRENT_DOC_ORDERED_CHILDREN_QM);
    }
}

