/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.GregorianCalendar;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.server.impl.atompub.XMLDocumentBase;

public abstract class AtomDocumentBase
extends XMLDocumentBase {
    private static final String ID_PREFIX = "http://chemistry.apache.org/";
    private static final String ID_DUMMY = "http://chemistry.apache.org/no-id";

    public String generateAtomId(String input) {
        if (input == null) {
            return ID_DUMMY;
        }
        try {
            return ID_PREFIX + Base64.encodeBytes((byte[])input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return ID_DUMMY;
        }
    }

    public void writeId(String id) throws XMLStreamException {
        XMLUtils.write((XMLStreamWriter)this.getWriter(), (String)"atom", (String)"http://www.w3.org/2005/Atom", (String)"id", (String)id);
    }

    public void writeTitle(String title) throws XMLStreamException {
        XMLUtils.write((XMLStreamWriter)this.getWriter(), (String)"atom", (String)"http://www.w3.org/2005/Atom", (String)"title", (String)title);
    }

    public void writeAuthor(String author) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("atom", "author", "http://www.w3.org/2005/Atom");
        XMLUtils.write((XMLStreamWriter)xsw, (String)"atom", (String)"http://www.w3.org/2005/Atom", (String)"name", (String)author);
        xsw.writeEndElement();
    }

    public void writeUpdated(GregorianCalendar updated) throws XMLStreamException {
        XMLUtils.write((XMLStreamWriter)this.getWriter(), (String)"app", (String)"http://www.w3.org/2007/app", (String)"edited", (GregorianCalendar)updated);
        XMLUtils.write((XMLStreamWriter)this.getWriter(), (String)"atom", (String)"http://www.w3.org/2005/Atom", (String)"updated", (GregorianCalendar)updated);
    }

    public void writeUpdated(long updated) throws XMLStreamException {
        String updatedStr = DateTimeHelper.formatHttpDateTime((long)updated);
        XMLUtils.write((XMLStreamWriter)this.getWriter(), (String)"app", (String)"http://www.w3.org/2007/app", (String)"edited", (String)updatedStr);
        XMLUtils.write((XMLStreamWriter)this.getWriter(), (String)"atom", (String)"http://www.w3.org/2005/Atom", (String)"updated", (String)updatedStr);
    }

    public void writePublished(GregorianCalendar published) throws XMLStreamException {
        XMLUtils.write((XMLStreamWriter)this.getWriter(), (String)"atom", (String)"http://www.w3.org/2005/Atom", (String)"published", (GregorianCalendar)published);
    }

    public void writePublished(long published) throws XMLStreamException {
        XMLUtils.write((XMLStreamWriter)this.getWriter(), (String)"atom", (String)"http://www.w3.org/2005/Atom", (String)"published", (String)DateTimeHelper.formatHttpDateTime((long)published));
    }

    public void writePathSegment(String pathSegment) throws XMLStreamException {
        XMLUtils.write((XMLStreamWriter)this.getWriter(), (String)"cmisra", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (String)"pathSegment", (String)pathSegment);
    }

    public void writeRelativePathSegment(String relativePathSegment) throws XMLStreamException {
        XMLUtils.write((XMLStreamWriter)this.getWriter(), (String)"cmisra", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (String)"relativePathSegment", (String)relativePathSegment);
    }

    public void writeCollection(String href, String collectionType, String text, String ... accept) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("app", "collection", "http://www.w3.org/2007/app");
        xsw.writeAttribute("href", href);
        if (collectionType != null) {
            XMLUtils.write((XMLStreamWriter)xsw, (String)"cmisra", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (String)"collectionType", (String)collectionType);
        }
        xsw.writeStartElement("atom", "title", "http://www.w3.org/2005/Atom");
        xsw.writeAttribute("type", "text");
        xsw.writeCharacters(text);
        xsw.writeEndElement();
        for (String ct : accept) {
            XMLUtils.write((XMLStreamWriter)xsw, (String)"app", (String)"http://www.w3.org/2007/app", (String)"accept", (String)ct);
        }
        xsw.writeEndElement();
    }

    public void writeLink(String rel, String href, String type, String id) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("atom", "link", "http://www.w3.org/2005/Atom");
        xsw.writeAttribute("rel", rel);
        xsw.writeAttribute("href", href);
        if (type != null) {
            xsw.writeAttribute("type", type);
        }
        if (id != null) {
            xsw.writeAttribute("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "id", id);
        }
        xsw.writeEndElement();
    }

    public void writeServiceLink(String href, String repositoryId) throws XMLStreamException {
        try {
            this.writeLink("service", href + "?repositoryId=" + URLEncoder.encode(repositoryId, "UTF-8"), "application/atomsvc+xml", null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void writeSelfLink(String href, String type, String id) throws XMLStreamException {
        this.writeLink("self", href, type, id);
    }

    public void writeEnclosureLink(String href) throws XMLStreamException {
        this.writeLink("enclosure", href, "application/atom+xml;type=entry", null);
    }

    public void writeEditLink(String href) throws XMLStreamException {
        this.writeLink("edit", href, "application/atom+xml;type=entry", null);
    }

    public void writeAlternateLink(String href, String type, String kind, String title, BigInteger length) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("atom", "link", "http://www.w3.org/2005/Atom");
        xsw.writeAttribute("rel", "alternate");
        xsw.writeAttribute("href", href);
        if (type != null) {
            xsw.writeAttribute("type", type);
        }
        if (kind != null) {
            xsw.writeAttribute("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "renditionKind", kind);
        }
        if (title != null) {
            xsw.writeAttribute("title", title);
        }
        if (length != null) {
            xsw.writeAttribute("length", length.toString());
        }
        xsw.writeEndElement();
    }

    public void writeWorkingCopyLink(String href) throws XMLStreamException {
        this.writeLink("working-copy", href, "application/atom+xml;type=entry", null);
    }

    public void writeUpLink(String href, String type) throws XMLStreamException {
        this.writeLink("up", href, type, null);
    }

    public void writeDownLink(String href, String type) throws XMLStreamException {
        this.writeLink("down", href, type, null);
    }

    public void writeVersionHistoryLink(String href) throws XMLStreamException {
        this.writeLink("version-history", href, "application/atom+xml;type=feed", null);
    }

    public void writeCurrentVerionsLink(String href) throws XMLStreamException {
        this.writeLink("current-version", href, "application/atom+xml;type=entry", null);
    }

    public void writeEditMediaLink(String href, String type) throws XMLStreamException {
        this.writeLink("edit-media", href, type, null);
    }

    public void writeDescribedByLink(String href) throws XMLStreamException {
        this.writeLink("describedby", href, "application/atom+xml;type=entry", null);
    }

    public void writeAllowableActionsLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/allowableactions", href, "application/cmisallowableactions+xml", null);
    }

    public void writeAclLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/acl", href, "application/cmisacl+xml", null);
    }

    public void writePoliciesLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/policies", href, "application/atom+xml;type=feed", null);
    }

    public void writeRelationshipsLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/relationships", href, "application/atom+xml;type=feed", null);
    }

    public void writeRelationshipSourceLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/source", href, "application/atom+xml;type=entry", null);
    }

    public void writeRelationshipTargetLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/target", href, "application/atom+xml;type=entry", null);
    }

    public void writeFolderTreeLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", href, "application/atom+xml;type=feed", null);
    }

    public void writeTypeUpLink(String href, String type) throws XMLStreamException {
        this.writeLink("up", href, type, null);
    }

    public void writeTypeDownLink(String href, String type) throws XMLStreamException {
        this.writeLink("down", href, type, null);
    }

    public void writeViaLink(String href) throws XMLStreamException {
        this.writeLink("via", href, "application/atom+xml;type=entry", null);
    }

    public void writeFirstLink(String href) throws XMLStreamException {
        this.writeLink("first", href, "application/atom+xml;type=feed", null);
    }

    public void writeLastLink(String href) throws XMLStreamException {
        this.writeLink("last", href, "application/atom+xml;type=feed", null);
    }

    public void writePreviousLink(String href) throws XMLStreamException {
        this.writeLink("previous", href, "application/atom+xml;type=feed", null);
    }

    public void writeNextLink(String href) throws XMLStreamException {
        this.writeLink("next", href, "application/atom+xml;type=feed", null);
    }
}

