/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;

public class HttpUtils {
    public static String getStringParameter(HttpServletRequest request, String name) {
        if (name == null) {
            return null;
        }
        Map parameters = request.getParameterMap();
        for (Map.Entry parameter : parameters.entrySet()) {
            if (!name.equalsIgnoreCase((String)parameter.getKey())) continue;
            if (parameter.getValue() == null) {
                return null;
            }
            return ((String[])parameter.getValue())[0];
        }
        return null;
    }

    public static String[] splitPath(HttpServletRequest request) {
        int prefixLength = request.getContextPath().length() + request.getServletPath().length();
        String p = request.getRequestURI().substring(prefixLength);
        if (p.length() == 0) {
            return new String[0];
        }
        String[] result = p.substring(1).split("/");
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = URLDecoder.decode(result[i], "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

