/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.jsf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewLayout;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderChangedListener;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public class ContentViewImpl
implements ContentView,
PageProviderChangedListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ContentViewImpl.class);
    protected String name;
    protected PageProvider<?> pageProvider;
    protected String title;
    protected boolean translateTitle;
    protected String emptySentence;
    protected boolean translateEmptySentence;
    protected String iconPath;
    protected boolean showTitle;
    protected String selectionList;
    protected String pagination;
    protected List<String> actionCategories;
    protected ContentViewLayout searchLayout;
    protected List<ContentViewLayout> resultLayouts;
    protected List<String> flags;
    protected ContentViewLayout currentResultLayout;
    protected List<String> currentResultLayoutColumns;
    protected String cacheKey;
    protected Integer cacheSize;
    protected List<String> refreshEventNames;
    protected List<String> resetEventNames;
    protected boolean useGlobalPageSize;
    protected boolean showPageSizeSelector;
    protected boolean showRefreshCommand;
    protected boolean showFilterForm;
    protected Long currentPageSize;
    protected String[] queryParameters;
    protected DocumentModel searchDocumentModel;
    protected String searchDocumentModelBinding;
    protected String searchDocumentModelType;
    protected String resultColumnsBinding;
    protected String pageSizeBinding;
    protected String sortInfosBinding;

    public ContentViewImpl(String name, String title, boolean translateTitle, String iconPath, String selectionList, String pagination, List<String> actionCategories, ContentViewLayout searchLayout, List<ContentViewLayout> resultLayouts, List<String> flags, String cacheKey, Integer cacheSize, List<String> refreshEventNames, List<String> resetEventNames, boolean useGlobalPageSize, String[] queryParameters, String searchDocumentModelBinding, String searchDocumentModelType, String resultColumnsBinding, String sortInfosBinding, String pageSizeBinding, boolean showTitle, boolean showPageSizeSelector, boolean showRefreshCommand, boolean showFilterForm, String emptySentence, boolean translateEmptySentence) {
        this.name = name;
        this.title = title;
        this.translateTitle = translateTitle;
        this.iconPath = iconPath;
        this.selectionList = selectionList;
        this.pagination = pagination;
        this.actionCategories = actionCategories;
        this.searchLayout = searchLayout;
        this.resultLayouts = resultLayouts;
        this.flags = flags;
        this.cacheKey = cacheKey;
        this.cacheSize = cacheSize;
        if (cacheSize != null && cacheSize <= 0) {
            this.cacheKey = "static_key_no_cache";
        }
        this.refreshEventNames = refreshEventNames;
        this.resetEventNames = resetEventNames;
        this.useGlobalPageSize = useGlobalPageSize;
        this.queryParameters = queryParameters;
        this.searchDocumentModelBinding = searchDocumentModelBinding;
        this.searchDocumentModelType = searchDocumentModelType;
        this.resultColumnsBinding = resultColumnsBinding;
        this.pageSizeBinding = pageSizeBinding;
        this.sortInfosBinding = sortInfosBinding;
        this.showTitle = showTitle;
        this.showPageSizeSelector = showPageSizeSelector;
        this.showRefreshCommand = showRefreshCommand;
        this.showFilterForm = showFilterForm;
        this.emptySentence = emptySentence;
        this.translateEmptySentence = translateEmptySentence;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean getTranslateTitle() {
        return this.translateTitle;
    }

    @Override
    public String getIconPath() {
        return this.iconPath;
    }

    @Override
    public String getSelectionListName() {
        return this.selectionList;
    }

    @Override
    public String getPagination() {
        return this.pagination;
    }

    @Override
    public List<String> getActionsCategories() {
        return this.actionCategories;
    }

    @Override
    public ContentViewLayout getSearchLayout() {
        return this.searchLayout;
    }

    @Override
    public List<ContentViewLayout> getResultLayouts() {
        return this.resultLayouts;
    }

    @Override
    public ContentViewLayout getCurrentResultLayout() {
        if (this.currentResultLayout == null && this.resultLayouts != null && !this.resultLayouts.isEmpty()) {
            this.currentResultLayout = this.resultLayouts.get(0);
        }
        return this.currentResultLayout;
    }

    @Override
    public void setCurrentResultLayout(ContentViewLayout layout) {
        this.currentResultLayout = layout;
    }

    @Override
    public void setCurrentResultLayout(String resultLayoutName) {
        if (resultLayoutName != null) {
            for (ContentViewLayout layout : this.resultLayouts) {
                if (!resultLayoutName.equals(layout.getName())) continue;
                this.setCurrentResultLayout(layout);
            }
        }
    }

    @Override
    public PageProvider<?> getPageProvider(DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Object ... params) throws ClientException {
        boolean setSearchDoc = false;
        DocumentModel finalSearchDocument = null;
        if (searchDocument != null) {
            setSearchDoc = true;
            finalSearchDocument = searchDocument;
        } else if (this.searchDocumentModel == null) {
            setSearchDoc = true;
            if (this.pageProvider != null) {
                finalSearchDocument = this.pageProvider.getSearchDocumentModel();
            }
            if (finalSearchDocument == null) {
                finalSearchDocument = this.getSearchDocumentModel();
                setSearchDoc = false;
            }
        } else {
            finalSearchDocument = this.searchDocumentModel;
        }
        if (setSearchDoc) {
            this.setSearchDocumentModel(finalSearchDocument);
        }
        if (params == null) {
            params = this.getQueryParameters();
        }
        if (sortInfos == null) {
            sortInfos = this.resolveSortInfos();
        }
        if (pageSize != null && pageSize < 0L) {
            pageSize = null;
        }
        if (currentPage != null && currentPage < 0L) {
            currentPage = null;
        }
        if (pageSize == null) {
            if (this.currentPageSize != null && this.currentPageSize >= 0L) {
                pageSize = this.currentPageSize;
            }
            if (pageSize == null) {
                pageSize = this.resolvePageSize();
            }
        }
        if (this.pageProvider == null || this.pageProvider.hasChangedParameters(params)) {
            ContentViewService service = (ContentViewService)Framework.getLocalService(ContentViewService.class);
            if (service == null) {
                throw new ClientException("Could not resolve ContentViewService");
            }
            this.pageProvider = service.getPageProvider(this.getName(), sortInfos, pageSize, currentPage, finalSearchDocument, params);
        } else {
            if (pageSize != null) {
                this.pageProvider.setPageSize(pageSize.longValue());
            }
            if (currentPage != null) {
                this.pageProvider.setCurrentPage(currentPage.longValue());
            }
        }
        this.pageProvider.setPageProviderChangedListener((PageProviderChangedListener)this);
        return this.pageProvider;
    }

    @Override
    public PageProvider<?> getPageProviderWithParams(Object ... params) throws ClientException {
        return this.getPageProvider(null, null, null, null, params);
    }

    @Override
    public PageProvider<?> getPageProvider() throws ClientException {
        return this.getPageProviderWithParams(null);
    }

    @Override
    public PageProvider<?> getCurrentPageProvider() {
        return this.pageProvider;
    }

    @Override
    public void resetPageProvider() {
        this.pageProvider = null;
    }

    @Override
    public void refreshPageProvider() {
        if (this.pageProvider != null) {
            this.pageProvider.refresh();
        }
    }

    @Override
    public void refreshAndRewindPageProvider() {
        if (this.pageProvider != null) {
            this.pageProvider.refresh();
            this.pageProvider.firstPage();
        }
    }

    @Override
    public String getCacheKey() {
        FacesContext context = FacesContext.getCurrentInstance();
        Object value = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)this.cacheKey);
        if (value != null && !(value instanceof String)) {
            log.error((Object)String.format("Error processing expression '%s', result is not a String: %s", this.cacheKey, value));
        }
        return (String)value;
    }

    @Override
    public Integer getCacheSize() {
        return this.cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getQueryParameters() {
        if (this.queryParameters == null) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Object previousSearchDocValue = this.addSearchDocumentToELContext(context);
        try {
            Object[] res = new Object[this.queryParameters.length];
            for (int i = 0; i < this.queryParameters.length; ++i) {
                res[i] = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)this.queryParameters[i]);
            }
            Object[] objectArray = res;
            return objectArray;
        }
        finally {
            this.removeSearchDocumentFromELContext(context, previousSearchDocValue);
        }
    }

    @Override
    public List<String> getRefreshEventNames() {
        return this.refreshEventNames;
    }

    @Override
    public List<String> getResetEventNames() {
        return this.resetEventNames;
    }

    @Override
    public boolean getUseGlobalPageSize() {
        return this.useGlobalPageSize;
    }

    @Override
    public Long getCurrentPageSize() {
        if (this.currentPageSize != null && this.currentPageSize >= 0L) {
            return this.currentPageSize;
        }
        if (this.pageProvider != null) {
            return this.pageProvider.getPageSize();
        }
        return null;
    }

    @Override
    public void setCurrentPageSize(Long pageSize) {
        this.currentPageSize = pageSize;
        this.raiseEvent("contentViewPageSizeChanged");
    }

    @Override
    public DocumentModel getSearchDocumentModel() {
        if (this.searchDocumentModel == null) {
            String docType;
            if (this.searchDocumentModelBinding != null) {
                FacesContext context = FacesContext.getCurrentInstance();
                Object value = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)this.searchDocumentModelBinding);
                if (value != null && !(value instanceof DocumentModel)) {
                    log.error((Object)String.format("Error processing expression '%s', result is not a DocumentModel: %s", this.searchDocumentModelBinding, value));
                } else {
                    this.setSearchDocumentModel((DocumentModel)value);
                }
            }
            if (this.searchDocumentModel == null && (docType = this.getSearchDocumentModelType()) != null) {
                DocumentModelImpl bareDoc = DocumentModelFactory.createDocumentModel((String)docType);
                this.setSearchDocumentModel((DocumentModel)bareDoc);
            }
        }
        return this.searchDocumentModel;
    }

    @Override
    public void setSearchDocumentModel(DocumentModel searchDocumentModel) {
        this.searchDocumentModel = searchDocumentModel;
        if (this.pageProvider != null) {
            this.pageProvider.setSearchDocumentModel(searchDocumentModel);
        }
    }

    @Override
    public void resetSearchDocumentModel() {
        this.searchDocumentModel = null;
        if (this.pageProvider != null) {
            this.pageProvider.setSearchDocumentModel(null);
        }
    }

    @Override
    public String getSearchDocumentModelType() {
        return this.searchDocumentModelType;
    }

    @Override
    public List<String> getFlags() {
        return this.flags;
    }

    @Override
    public List<String> getResultLayoutColumns() {
        return this.getCurrentResultLayoutColumns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCurrentResultLayoutColumns() {
        if (this.currentResultLayoutColumns != null) {
            return this.currentResultLayoutColumns;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Object previousSearchDocValue = this.addSearchDocumentToELContext(context);
        try {
            Object value = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)this.resultColumnsBinding);
            if (value != null && !(value instanceof List)) {
                log.error((Object)String.format("Error processing expression '%s', result is not a List: %s", this.resultColumnsBinding, value));
            }
            List list = (List)value;
            return list;
        }
        finally {
            this.removeSearchDocumentFromELContext(context, previousSearchDocValue);
        }
    }

    @Override
    public void setCurrentResultLayoutColumns(List<String> resultColumns) {
        this.currentResultLayoutColumns = resultColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SortInfo> resolveSortInfos() {
        if (this.sortInfosBinding == null) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Object previousSearchDocValue = this.addSearchDocumentToELContext(context);
        try {
            ArrayList<SortInfo> arrayList;
            Object value = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)this.sortInfosBinding);
            if (value != null && !(value instanceof List)) {
                log.error((Object)String.format("Error processing expression '%s', result is not a List: %s", this.sortInfosBinding, value));
            }
            if (value == null) {
                List<SortInfo> list = null;
                return list;
            }
            ArrayList<SortInfo> res = new ArrayList<SortInfo>();
            List listValue = (List)value;
            for (Object listItem : listValue) {
                if (listItem instanceof SortInfo) {
                    res.add((SortInfo)listItem);
                    continue;
                }
                if (listItem instanceof Map) {
                    Map map;
                    SortInfo sortInfo;
                    if (listItem instanceof MapProperty) {
                        try {
                            listItem = ((MapProperty)listItem).getValue();
                        }
                        catch (ClassCastException | PropertyException e) {
                            log.error((Object)("Cannot resolve sort info item: " + listItem), e);
                        }
                    }
                    if ((sortInfo = SortInfo.asSortInfo((Map)(map = (Map)listItem))) != null) {
                        res.add(sortInfo);
                        continue;
                    }
                    log.error((Object)("Cannot resolve sort info item: " + listItem));
                    continue;
                }
                log.error((Object)("Cannot resolve sort info item: " + listItem));
            }
            if (res.isEmpty()) {
                arrayList = null;
                return arrayList;
            }
            arrayList = res;
            return arrayList;
        }
        finally {
            this.removeSearchDocumentFromELContext(context, previousSearchDocValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Long resolvePageSize() {
        if (this.pageSizeBinding == null) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Object previousSearchDocValue = this.addSearchDocumentToELContext(context);
        try {
            Object value = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)this.pageSizeBinding);
            if (value == null) {
                Long l = null;
                return l;
            }
            if (value instanceof String) {
                try {
                    Long l = Long.valueOf((String)value);
                    return l;
                }
                catch (NumberFormatException e) {
                    log.error((Object)String.format("Error processing expression '%s', result is not a Long: %s", this.pageSizeBinding, value));
                }
            } else if (value instanceof Number) {
                Long l = ((Number)value).longValue();
                return l;
            }
            Long l = null;
            return l;
        }
        finally {
            this.removeSearchDocumentFromELContext(context, previousSearchDocValue);
        }
    }

    protected Object addSearchDocumentToELContext(FacesContext facesContext) {
        if (facesContext == null) {
            log.error((Object)String.format("Faces context is null: cannot expose variable '%s' for content view '%s'", "searchDocument", this.getName()));
            return null;
        }
        ExternalContext econtext = facesContext.getExternalContext();
        if (econtext != null) {
            Map requestMap = econtext.getRequestMap();
            Object previousValue = requestMap.get("searchDocument");
            requestMap.put("searchDocument", this.searchDocumentModel);
            return previousValue;
        }
        log.error((Object)String.format("External context is null: cannot expose variable '%s' for content view '%s'", "searchDocument", this.getName()));
        return null;
    }

    protected void removeSearchDocumentFromELContext(FacesContext facesContext, Object previousValue) {
        if (facesContext == null) {
            return;
        }
        ExternalContext econtext = facesContext.getExternalContext();
        if (econtext != null) {
            Map requestMap = econtext.getRequestMap();
            requestMap.remove("searchDocument");
            if (previousValue != null) {
                requestMap.put("searchDocument", previousValue);
            }
        } else {
            log.error((Object)String.format("External context is null: cannot dispose variable '%s' for content view '%s'", "searchDocument", this.getName()));
        }
    }

    @Override
    public boolean getShowPageSizeSelector() {
        return this.showPageSizeSelector;
    }

    @Override
    public boolean getShowRefreshCommand() {
        return this.showRefreshCommand;
    }

    @Override
    public boolean getShowFilterForm() {
        return this.showFilterForm;
    }

    @Override
    public boolean getShowTitle() {
        return this.showTitle;
    }

    @Override
    public String getEmptySentence() {
        return this.emptySentence;
    }

    @Override
    public boolean getTranslateEmptySentence() {
        return this.translateEmptySentence;
    }

    public String toString() {
        return String.format("ContentViewImpl [name=%s, title=%s, translateTitle=%s, iconPath=%s, selectionList=%s, pagination=%s, actionCategories=%s, searchLayout=%s, resultLayouts=%s, currentResultLayout=%s, flags=%s, cacheKey=%s, cacheSize=%s, currentPageSize=%srefreshEventNames=%s, resetEventNames=%s,useGlobalPageSize=%s, searchDocumentModel=%s]", this.name, this.title, this.translateTitle, this.iconPath, this.selectionList, this.pagination, this.actionCategories, this.searchLayout, this.resultLayouts, this.currentResultLayout, this.flags, this.cacheKey, this.cacheSize, this.currentPageSize, this.refreshEventNames, this.resetEventNames, this.useGlobalPageSize, this.searchDocumentModel);
    }

    protected void raiseEvent(String eventName, Object ... params) {
        if (Events.exists()) {
            Events.instance().raiseEvent(eventName, params);
        }
    }

    protected void raiseEvent(String eventName) {
        this.raiseEvent(eventName, this.name);
    }

    public void pageChanged(PageProvider pageProvider) {
        this.raiseEvent("contentViewPageChanged");
    }

    public void refreshed(PageProvider pageProvider) {
        this.raiseEvent("contentViewRefresh");
    }
}

