/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.RenderingInfo;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetReference;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetSelectOption;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetSelectOptions;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.converters.LayoutConversionContext;
import org.nuxeo.ecm.platform.forms.layout.api.converters.WidgetDefinitionConverter;
import org.nuxeo.ecm.platform.forms.layout.api.impl.FieldDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutRowDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.RenderingInfoImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetReferenceImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetSelectOptionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetSelectOptionsImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetTypeConfigurationImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetTypeDefinitionComparator;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetTypeDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.ecm.platform.forms.layout.io.Base64;
import org.nuxeo.runtime.api.Framework;

public class JSONLayoutExporter {
    private static final Log log = LogFactory.getLog(JSONLayoutExporter.class);
    public static final String ENCODED_VALUES_ENCODING = "UTF-8";

    public static String encode(JSONObject jsonObject) throws UnsupportedEncodingException {
        String json = jsonObject.toString();
        String encodedValues = Base64.encodeBytes(json.getBytes(), 10);
        return URLEncoder.encode(encodedValues, ENCODED_VALUES_ENCODING);
    }

    public static JSONObject decode(String json) throws UnsupportedEncodingException {
        String decodedValues = URLDecoder.decode(json, ENCODED_VALUES_ENCODING);
        json = new String(Base64.decode(decodedValues));
        return JSONObject.fromObject((Object)json);
    }

    public static void export(String category, LayoutDefinition layoutDef, LayoutConversionContext ctx, List<WidgetDefinitionConverter> widgetConverters, OutputStream out) throws IOException {
        JSONObject res = JSONLayoutExporter.exportToJson(category, layoutDef, ctx, widgetConverters);
        out.write(res.toString(2).getBytes(ENCODED_VALUES_ENCODING));
    }

    public static void export(WidgetTypeDefinition def, OutputStream out) throws IOException {
        JSONObject res = JSONLayoutExporter.exportToJson(def);
        out.write(res.toString(2).getBytes(ENCODED_VALUES_ENCODING));
    }

    public static void export(List<WidgetTypeDefinition> defs, OutputStream out) throws IOException {
        JSONObject res = new JSONObject();
        if (defs != null) {
            Collections.sort(defs, new WidgetTypeDefinitionComparator(false));
        }
        for (WidgetTypeDefinition def : defs) {
            res.element(def.getName(), (Map)JSONLayoutExporter.exportToJson(def));
        }
        out.write(res.toString(2).getBytes(ENCODED_VALUES_ENCODING));
    }

    public static JSONObject exportToJson(WidgetTypeDefinition def) {
        WidgetTypeConfiguration conf;
        JSONObject json = new JSONObject();
        json.element("name", (Object)def.getName());
        json.element("handlerClassName", (Object)def.getHandlerClassName());
        JSONObject props = JSONLayoutExporter.exportStringPropsToJson(def.getProperties());
        if (!props.isEmpty()) {
            json.element("properties", (Map)props);
        }
        if ((conf = def.getConfiguration()) != null) {
            json.element("configuration", (Map)JSONLayoutExporter.exportToJson(conf));
        }
        return json;
    }

    public static WidgetTypeDefinition importWidgetTypeDefinition(JSONObject jsonDef) {
        String name = jsonDef.optString("name");
        String handlerClass = jsonDef.optString("handlerClassName");
        Map<String, String> properties = JSONLayoutExporter.importStringProps(jsonDef.optJSONObject("properties"));
        WidgetTypeConfiguration conf = JSONLayoutExporter.importWidgetTypeConfiguration(jsonDef.optJSONObject("configuration"));
        return new WidgetTypeDefinitionImpl(name, handlerClass, properties, conf);
    }

    public static JSONObject exportToJson(WidgetTypeConfiguration conf) {
        JSONObject confProps;
        JSONObject json = new JSONObject();
        json.element("title", (Object)conf.getTitle());
        json.element("description", (Object)conf.getDescription());
        String demoId = conf.getDemoId();
        if (demoId != null) {
            JSONObject demoInfo = new JSONObject();
            demoInfo.element("id", (Object)demoId);
            demoInfo.element("previewEnabled", conf.isDemoPreviewEnabled());
            json.element("demo", (Map)demoInfo);
        }
        json.element("sinceVersion", (Object)conf.getSinceVersion());
        String deprVersion = conf.getDeprecatedVersion();
        if (!StringUtils.isBlank((String)deprVersion)) {
            json.element("deprecatedVersion", (Object)deprVersion);
        }
        if (!(confProps = JSONLayoutExporter.exportPropsToJson(conf.getConfProperties())).isEmpty()) {
            json.element("confProperties", (Map)confProps);
        }
        JSONArray supportedModes = new JSONArray();
        List confSupportedModes = conf.getSupportedModes();
        if (confSupportedModes != null) {
            supportedModes.addAll((Collection)confSupportedModes);
        }
        if (!supportedModes.isEmpty()) {
            json.element("supportedModes", (Collection)supportedModes);
        }
        if (conf.isAcceptingSubWidgets()) {
            json.element("acceptingSubWidgets", conf.isAcceptingSubWidgets());
        }
        if (conf.isHandlingLabels()) {
            json.element("handlingLabels", conf.isHandlingLabels());
        }
        if (conf.isContainingForm()) {
            json.element("containingForm", true);
        }
        JSONObject fields = new JSONObject();
        fields.element("list", conf.isList());
        fields.element("complex", conf.isComplex());
        JSONArray supportedTypes = new JSONArray();
        List confSupportedTypes = conf.getSupportedFieldTypes();
        if (confSupportedTypes != null) {
            supportedTypes.addAll((Collection)confSupportedTypes);
        }
        if (!supportedTypes.isEmpty()) {
            fields.element("supportedTypes", (Collection)supportedTypes);
        }
        JSONArray defaultTypes = new JSONArray();
        List confDefaultTypes = conf.getDefaultFieldTypes();
        if (confDefaultTypes != null) {
            defaultTypes.addAll((Collection)confDefaultTypes);
        }
        if (!defaultTypes.isEmpty()) {
            fields.element("defaultTypes", (Collection)defaultTypes);
        }
        JSONArray defaultFieldDefs = new JSONArray();
        List fieldDefs = conf.getDefaultFieldDefinitions();
        if (fieldDefs != null) {
            for (FieldDefinition fieldDef : fieldDefs) {
                defaultFieldDefs.add((Object)JSONLayoutExporter.exportToJson(fieldDef));
            }
        }
        if (!defaultFieldDefs.isEmpty()) {
            fields.element("defaultConfiguration", (Collection)defaultFieldDefs);
        }
        json.element("fields", (Map)fields);
        JSONArray cats = new JSONArray();
        List confCats = conf.getCategories();
        if (confCats != null) {
            cats.addAll((Collection)confCats);
        }
        if (!cats.isEmpty()) {
            json.element("categories", (Collection)cats);
        }
        JSONObject props = new JSONObject();
        Map confLayouts = conf.getPropertyLayouts();
        if (confLayouts != null) {
            ArrayList modes = new ArrayList(confLayouts.keySet());
            Collections.sort(modes);
            JSONObject layouts = new JSONObject();
            for (String mode : modes) {
                JSONArray modeLayouts = new JSONArray();
                for (LayoutDefinition layoutDef : (List)confLayouts.get(mode)) {
                    modeLayouts.add((Object)JSONLayoutExporter.exportToJson(null, layoutDef));
                }
                layouts.element(mode, (Collection)modeLayouts);
            }
            if (!layouts.isEmpty()) {
                props.element("layouts", (Map)layouts);
            }
        }
        if (!props.isEmpty()) {
            json.element("properties", (Map)props);
        }
        return json;
    }

    public static WidgetTypeConfiguration importWidgetTypeConfiguration(JSONObject conf) {
        JSONObject layouts;
        WidgetTypeConfigurationImpl res = new WidgetTypeConfigurationImpl();
        if (conf == null) {
            return res;
        }
        res.setTitle(conf.getString("title"));
        res.setDescription(conf.optString("description"));
        res.setSinceVersion(conf.optString("sinceVersion"));
        res.setDeprecatedVersion(conf.optString("deprecatedVersion"));
        JSONObject demoInfo = conf.optJSONObject("demo");
        String demoId = null;
        boolean demoPreviewEnabled = false;
        if (demoInfo != null && !demoInfo.isNullObject()) {
            demoId = demoInfo.optString("id");
            demoPreviewEnabled = demoInfo.optBoolean("previewEnabled");
        }
        res.setDemoId(demoId);
        res.setDemoPreviewEnabled(demoPreviewEnabled);
        res.setProperties(JSONLayoutExporter.importProps(conf.optJSONObject("confProperties")));
        ArrayList confSupportedModes = new ArrayList();
        JSONArray supportedModes = conf.optJSONArray("supportedModes");
        if (supportedModes != null) {
            confSupportedModes.addAll(supportedModes);
        }
        res.setSupportedModes(confSupportedModes);
        res.setAcceptingSubWidgets(conf.optBoolean("acceptingSubWidgets", false));
        res.setHandlingLabels(conf.optBoolean("handlingLabels", false));
        res.setContainingForm(conf.optBoolean("containingForm", false));
        JSONObject fields = conf.optJSONObject("fields");
        boolean list = false;
        boolean complex = false;
        ArrayList confSupportedTypes = new ArrayList();
        ArrayList confDefaultTypes = new ArrayList();
        ArrayList<FieldDefinition> defaultFieldDefinitions = new ArrayList<FieldDefinition>();
        if (fields != null && !fields.isNullObject()) {
            JSONArray jfields;
            JSONArray defaultTypes;
            list = fields.optBoolean("list", false);
            complex = fields.optBoolean("complex", false);
            JSONArray supportedTypes = fields.optJSONArray("supportedTypes");
            if (supportedTypes != null) {
                confSupportedTypes.addAll(supportedTypes);
            }
            if ((defaultTypes = fields.optJSONArray("defaultTypes")) != null) {
                confDefaultTypes.addAll(defaultTypes);
            }
            if ((jfields = fields.optJSONArray("defaultConfiguration")) != null) {
                for (Object item : jfields) {
                    defaultFieldDefinitions.add(JSONLayoutExporter.importFieldDefinition((JSONObject)item));
                }
            }
        }
        res.setList(list);
        res.setComplex(complex);
        res.setSupportedFieldTypes(confSupportedTypes);
        res.setDefaultFieldTypes(confDefaultTypes);
        res.setDefaultFieldDefinitions(defaultFieldDefinitions);
        JSONArray cats = conf.optJSONArray("categories");
        ArrayList confCats = new ArrayList();
        if (cats != null) {
            confCats.addAll(cats);
        }
        res.setCategories(confCats);
        JSONObject props = conf.optJSONObject("properties");
        HashMap confLayouts = new HashMap();
        if (props != null && !props.isNullObject() && (layouts = props.optJSONObject("layouts")) != null && !layouts.isNullObject()) {
            for (Object item : layouts.keySet()) {
                String mode = (String)item;
                ArrayList<LayoutDefinition> layoutDefs = new ArrayList<LayoutDefinition>();
                JSONArray modeLayouts = layouts.getJSONArray(mode);
                if (modeLayouts != null && !mode.isEmpty()) {
                    for (Object subitem : modeLayouts) {
                        layoutDefs.add(JSONLayoutExporter.importLayoutDefinition((JSONObject)subitem));
                    }
                }
                confLayouts.put(mode, layoutDefs);
            }
        }
        res.setPropertyLayouts(confLayouts);
        return res;
    }

    public static JSONObject exportToJson(String category, LayoutDefinition layoutDef) {
        return JSONLayoutExporter.exportToJson(category, layoutDef, null, null);
    }

    public static JSONObject exportToJson(String category, LayoutDefinition layoutDef, LayoutConversionContext ctx, List<WidgetDefinitionConverter> widgetConverters) {
        JSONObject renderingInfos;
        JSONObject props;
        JSONObject json = new JSONObject();
        json.element("name", (Object)layoutDef.getName());
        JSONObject templates = JSONLayoutExporter.exportStringPropsToJson(layoutDef.getTemplates());
        if (!templates.isEmpty()) {
            json.element("templates", (Map)templates);
        }
        if (!(props = JSONLayoutExporter.exportPropsByModeToJson(layoutDef.getProperties())).isEmpty()) {
            json.element("properties", (Map)props);
        }
        JSONArray rows = new JSONArray();
        LayoutRowDefinition[] defRows = layoutDef.getRows();
        ArrayList<WidgetReference> widgetsToExport = new ArrayList<WidgetReference>();
        if (defRows != null) {
            for (LayoutRowDefinition layoutRowDef : defRows) {
                rows.add((Object)JSONLayoutExporter.exportToJson(layoutRowDef));
                WidgetReference[] widgets = layoutRowDef.getWidgetReferences();
                if (widgets == null) continue;
                for (WidgetReference widget : widgets) {
                    widgetsToExport.add(widget);
                }
            }
        }
        if (!rows.isEmpty()) {
            json.element("rows", (Collection)rows);
        }
        LayoutStore webLayoutManager = (LayoutStore)Framework.getLocalService(LayoutStore.class);
        JSONArray widgets = new JSONArray();
        for (WidgetReference widgetRef : widgetsToExport) {
            WidgetDefinition widgetDef = JSONLayoutExporter.exportWidgetReference(widgetRef, category, layoutDef, ctx, webLayoutManager, widgetConverters);
            if (widgetDef == null) continue;
            widgets.add((Object)JSONLayoutExporter.exportToJson(widgetDef, ctx, widgetConverters));
            WidgetReference[] subwidgetRefs = widgetDef.getSubWidgetReferences();
            if (subwidgetRefs == null) continue;
            for (WidgetReference subwidgetRef : subwidgetRefs) {
                WidgetDefinition subwidgetDef = JSONLayoutExporter.exportWidgetReference(subwidgetRef, category, layoutDef, ctx, webLayoutManager, widgetConverters);
                if (subwidgetDef == null) continue;
                widgets.add((Object)JSONLayoutExporter.exportToJson(subwidgetDef, ctx, widgetConverters));
            }
        }
        if (!widgets.isEmpty()) {
            json.element("widgets", (Collection)widgets);
        }
        if (!(renderingInfos = JSONLayoutExporter.exportRenderingInfosByModeToJson(layoutDef.getRenderingInfos())).isEmpty()) {
            json.element("renderingInfos", (Map)renderingInfos);
        }
        return json;
    }

    protected static WidgetDefinition exportWidgetReference(WidgetReference widgetRef, String category, LayoutDefinition layoutDef, LayoutConversionContext ctx, LayoutStore webLayoutManager, List<WidgetDefinitionConverter> widgetConverters) {
        String widgetName = widgetRef.getName();
        WidgetDefinition widgetDef = layoutDef.getWidgetDefinition(widgetName);
        if (widgetDef == null) {
            String cat = widgetRef.getCategory();
            if (cat == null) {
                cat = category;
            }
            widgetDef = webLayoutManager.getWidgetDefinition(cat, widgetName);
        }
        if (widgetDef == null) {
            log.error((Object)String.format("No definition found for widget '%s' in layout '%s' => cannot export", widgetName, layoutDef.getName()));
        } else if (widgetConverters != null) {
            for (WidgetDefinitionConverter conv : widgetConverters) {
                widgetDef = conv.getWidgetDefinition(widgetDef, ctx);
            }
        }
        return widgetDef;
    }

    public static LayoutDefinition importLayoutDefinition(JSONObject layoutDef) {
        String name = layoutDef.optString("name", null);
        Map<String, String> templates = JSONLayoutExporter.importStringProps(layoutDef.optJSONObject("templates"));
        Map<String, Map<String, Serializable>> properties = JSONLayoutExporter.importPropsByMode(layoutDef.optJSONObject("properties"));
        ArrayList<LayoutRowDefinition> rows = new ArrayList<LayoutRowDefinition>();
        JSONArray jrows = layoutDef.optJSONArray("rows");
        if (jrows != null) {
            for (Object item : jrows) {
                rows.add(JSONLayoutExporter.importLayoutRowDefinition((JSONObject)item));
            }
        }
        ArrayList<WidgetDefinition> widgets = new ArrayList<WidgetDefinition>();
        JSONArray jwidgets = layoutDef.optJSONArray("widgets");
        if (jwidgets != null) {
            for (Object item : jwidgets) {
                widgets.add(JSONLayoutExporter.importWidgetDefinition((JSONObject)item));
            }
        }
        Map<String, List<RenderingInfo>> renderingInfos = JSONLayoutExporter.importRenderingInfosByMode(layoutDef.optJSONObject("renderingInfos"));
        LayoutDefinitionImpl res = new LayoutDefinitionImpl(name, properties, templates, rows, widgets);
        res.setRenderingInfos(renderingInfos);
        return res;
    }

    public static JSONObject exportToJson(LayoutRowDefinition layoutRowDef) {
        JSONObject props;
        JSONObject json = new JSONObject();
        String name = layoutRowDef.getName();
        if (name != null) {
            json.element("name", (Object)name);
        }
        if (!(props = JSONLayoutExporter.exportPropsByModeToJson(layoutRowDef.getProperties())).isEmpty()) {
            json.element("properties", (Map)props);
        }
        JSONArray widgets = new JSONArray();
        WidgetReference[] defWidgets = layoutRowDef.getWidgetReferences();
        if (defWidgets != null) {
            for (WidgetReference widget : defWidgets) {
                widgets.add((Object)JSONLayoutExporter.exportToJson(widget));
            }
        }
        if (!widgets.isEmpty()) {
            json.element("widgets", (Collection)widgets);
        }
        return json;
    }

    public static LayoutRowDefinition importLayoutRowDefinition(JSONObject layoutRowDef) {
        String name = layoutRowDef.optString("name", null);
        Map<String, Map<String, Serializable>> properties = JSONLayoutExporter.importPropsByMode(layoutRowDef.optJSONObject("properties"));
        ArrayList<Object> widgets = new ArrayList<Object>();
        JSONArray jwidgets = layoutRowDef.optJSONArray("widgets");
        if (jwidgets != null) {
            for (Object item : jwidgets) {
                if (item instanceof String) {
                    widgets.add(new WidgetReferenceImpl((String)item));
                    continue;
                }
                widgets.add(JSONLayoutExporter.importWidgetReference((JSONObject)item));
            }
        }
        return new LayoutRowDefinitionImpl(name, properties, widgets, false, true);
    }

    public static JSONObject exportToJson(WidgetDefinition widgetDef, LayoutConversionContext ctx, List<WidgetDefinitionConverter> widgetConverters) {
        JSONObject renderingInfos;
        JSONObject controls;
        JSONObject widgetModeProps;
        JSONObject props;
        JSONObject helpLabels;
        JSONObject json = new JSONObject();
        json.element("name", (Object)widgetDef.getName());
        json.element("type", (Object)widgetDef.getType());
        JSONObject labels = JSONLayoutExporter.exportStringPropsToJson(widgetDef.getLabels());
        if (!labels.isEmpty()) {
            json.element("labels", (Map)labels);
        }
        if (!(helpLabels = JSONLayoutExporter.exportStringPropsToJson(widgetDef.getHelpLabels())).isEmpty()) {
            json.element("helpLabels", (Map)helpLabels);
        }
        json.element("translated", widgetDef.isTranslated());
        json.element("handlingLabels", widgetDef.isHandlingLabels());
        JSONObject widgetModes = JSONLayoutExporter.exportStringPropsToJson(widgetDef.getModes());
        if (!widgetModes.isEmpty()) {
            json.element("widgetModes", (Map)widgetModes);
        }
        JSONArray fields = new JSONArray();
        FieldDefinition[] fieldDefs = widgetDef.getFieldDefinitions();
        if (fieldDefs != null) {
            for (FieldDefinition fieldDef : fieldDefs) {
                fields.add((Object)JSONLayoutExporter.exportToJson(fieldDef));
            }
        }
        if (!fields.isEmpty()) {
            json.element("fields", (Collection)fields);
        }
        JSONArray subWidgets = new JSONArray();
        WidgetDefinition[] subWidgetDefs = widgetDef.getSubWidgetDefinitions();
        if (subWidgetDefs != null) {
            for (WidgetDefinition wDef : subWidgetDefs) {
                subWidgets.add((Object)JSONLayoutExporter.exportToJson(wDef, ctx, widgetConverters));
            }
        }
        if (!subWidgets.isEmpty()) {
            json.element("subWidgets", (Collection)subWidgets);
        }
        JSONArray subWidgetRefs = new JSONArray();
        WidgetReference[] subWidgetRefDefs = widgetDef.getSubWidgetReferences();
        if (subWidgetRefDefs != null) {
            for (WidgetReference ref : subWidgetRefDefs) {
                subWidgetRefs.add((Object)JSONLayoutExporter.exportToJson(ref));
            }
        }
        if (!subWidgetRefs.isEmpty()) {
            json.element("subWidgetRefs", (Collection)subWidgetRefs);
        }
        if (!(props = JSONLayoutExporter.exportPropsByModeToJson(widgetDef.getProperties())).isEmpty()) {
            json.element("properties", (Map)props);
        }
        if (!(widgetModeProps = JSONLayoutExporter.exportPropsByModeToJson(widgetDef.getWidgetModeProperties())).isEmpty()) {
            json.element("propertiesByWidgetMode", (Map)widgetModeProps);
        }
        if (!(controls = JSONLayoutExporter.exportPropsByModeToJson(widgetDef.getControls())).isEmpty()) {
            json.element("controls", (Map)controls);
        }
        JSONArray selectOptions = new JSONArray();
        WidgetSelectOption[] selectOptionDefs = widgetDef.getSelectOptions();
        if (selectOptionDefs != null) {
            for (WidgetSelectOption selectOptionDef : selectOptionDefs) {
                selectOptions.add((Object)JSONLayoutExporter.exportToJson(selectOptionDef));
            }
        }
        if (!selectOptions.isEmpty()) {
            json.element("selectOptions", (Collection)selectOptions);
        }
        if (!(renderingInfos = JSONLayoutExporter.exportRenderingInfosByModeToJson(widgetDef.getRenderingInfos())).isEmpty()) {
            json.element("renderingInfos", (Map)renderingInfos);
        }
        return json;
    }

    public static WidgetDefinition importWidgetDefinition(JSONObject widgetDef) {
        String name = widgetDef.getString("name");
        String type = widgetDef.getString("type");
        Map<String, String> labels = JSONLayoutExporter.importStringProps(widgetDef.optJSONObject("labels"));
        Map<String, String> helpLabels = JSONLayoutExporter.importStringProps(widgetDef.optJSONObject("helpLabels"));
        boolean translated = widgetDef.optBoolean("translated", false);
        boolean handlingLabels = widgetDef.optBoolean("handlingLabels", false);
        Map<String, String> modes = JSONLayoutExporter.importStringProps(widgetDef.optJSONObject("widgetModes"));
        ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
        JSONArray jfields = widgetDef.optJSONArray("fields");
        if (jfields != null) {
            for (Object item : jfields) {
                fieldDefinitions.add(JSONLayoutExporter.importFieldDefinition((JSONObject)item));
            }
        }
        ArrayList<WidgetDefinition> subWidgets = new ArrayList<WidgetDefinition>();
        JSONArray jsubwidgets = widgetDef.optJSONArray("subWidgets");
        if (jsubwidgets != null) {
            for (Object item : jsubwidgets) {
                subWidgets.add(JSONLayoutExporter.importWidgetDefinition((JSONObject)item));
            }
        }
        ArrayList<WidgetReference> subWidgetRefs = new ArrayList<WidgetReference>();
        JSONArray jsubwidgetRefs = widgetDef.optJSONArray("subWidgetRefs");
        if (jsubwidgetRefs != null) {
            for (Object item : jsubwidgetRefs) {
                subWidgetRefs.add(JSONLayoutExporter.importWidgetReference((JSONObject)item));
            }
        }
        Map<String, Map<String, Serializable>> properties = JSONLayoutExporter.importPropsByMode(widgetDef.optJSONObject("properties"));
        Map<String, Map<String, Serializable>> widgetModeProperties = JSONLayoutExporter.importPropsByMode(widgetDef.optJSONObject("propertiesByWidgetMode"));
        Map<String, Map<String, Serializable>> controls = JSONLayoutExporter.importPropsByMode(widgetDef.optJSONObject("controls"));
        ArrayList<WidgetSelectOption> selectOptions = new ArrayList<WidgetSelectOption>();
        JSONArray jselectOptions = widgetDef.optJSONArray("selectOptions");
        if (jselectOptions != null) {
            for (Object item : jselectOptions) {
                selectOptions.add(JSONLayoutExporter.importWidgetSelectionOption((JSONObject)item));
            }
        }
        Map<String, List<RenderingInfo>> renderingInfos = JSONLayoutExporter.importRenderingInfosByMode(widgetDef.optJSONObject("renderingInfos"));
        WidgetDefinitionImpl res = new WidgetDefinitionImpl(name, type, labels, helpLabels, translated, modes, fieldDefinitions.toArray(new FieldDefinition[0]), properties, widgetModeProperties, subWidgets.toArray(new WidgetDefinition[0]), selectOptions.toArray(new WidgetSelectOption[0]));
        res.setRenderingInfos(renderingInfos);
        res.setSubWidgetReferences(subWidgetRefs.toArray(new WidgetReference[0]));
        res.setHandlingLabels(handlingLabels);
        res.setControls(controls);
        return res;
    }

    public static JSONObject exportToJson(FieldDefinition fieldDef) {
        JSONObject json = new JSONObject();
        json.element("fieldName", (Object)fieldDef.getFieldName());
        json.element("schemaName", (Object)fieldDef.getSchemaName());
        json.element("propertyName", (Object)fieldDef.getPropertyName());
        return json;
    }

    public static FieldDefinition importFieldDefinition(JSONObject fieldDef) {
        FieldDefinitionImpl res = new FieldDefinitionImpl(fieldDef.optString("schemaName", null), fieldDef.getString("fieldName"));
        return res;
    }

    public static JSONObject exportToJson(WidgetReference widgetRef) {
        JSONObject json = new JSONObject();
        json.element("name", (Object)widgetRef.getName());
        json.element("category", (Object)widgetRef.getCategory());
        return json;
    }

    public static WidgetReference importWidgetReference(JSONObject widgetRef) {
        WidgetReferenceImpl res = new WidgetReferenceImpl(widgetRef.optString("category"), widgetRef.optString("name", null));
        return res;
    }

    public static JSONObject exportToJson(WidgetSelectOption selectOption) {
        Serializable itemRendered;
        Serializable itemDisabled;
        String itemValue;
        String itemLabel;
        String var;
        JSONObject json = new JSONObject();
        Serializable value = selectOption.getValue();
        boolean isMulti = selectOption instanceof WidgetSelectOptions;
        if (isMulti) {
            json.element("multiple", true);
        } else {
            json.element("multiple", false);
        }
        if (value != null) {
            json.element("value", (Object)value);
        }
        if ((var = selectOption.getVar()) != null) {
            json.element("var", (Object)var);
        }
        if ((itemLabel = selectOption.getItemLabel()) != null) {
            json.element("itemLabel", (Object)itemLabel);
        }
        if ((itemValue = selectOption.getItemValue()) != null) {
            json.element("itemValue", (Object)itemValue);
        }
        if ((itemDisabled = selectOption.getItemDisabled()) != null) {
            json.element("itemDisabled", (Object)itemDisabled);
        }
        if ((itemRendered = selectOption.getItemRendered()) != null) {
            json.element("itemRendered", (Object)itemRendered);
        }
        if (isMulti) {
            Boolean caseSensitive;
            WidgetSelectOptions selectOptions = (WidgetSelectOptions)selectOption;
            String ordering = selectOptions.getOrdering();
            if (ordering != null) {
                json.element("ordering", (Object)ordering);
            }
            if ((caseSensitive = selectOptions.getCaseSensitive()) != null) {
                json.element("caseSensitive", (Object)caseSensitive);
            }
        }
        return json;
    }

    public static WidgetSelectOption importWidgetSelectionOption(JSONObject selectOption) {
        boolean isMulti = selectOption.getBoolean("multiple");
        String value = selectOption.optString("value", null);
        String var = selectOption.optString("var", null);
        String itemLabel = selectOption.optString("itemLabel", null);
        String itemValue = selectOption.optString("itemValue", null);
        String itemDisabled = selectOption.optString("itemDisabled", null);
        String itemRendered = selectOption.optString("itemRendered", null);
        if (isMulti) {
            String ordering = selectOption.optString("ordering", null);
            Boolean caseSensitive = null;
            if (selectOption.has("caseSensitive")) {
                caseSensitive = new Boolean(selectOption.getBoolean("caseSensitive"));
            }
            return new WidgetSelectOptionsImpl((Serializable)((Object)value), var, itemLabel, itemValue, (Serializable)((Object)itemDisabled), (Serializable)((Object)itemRendered), ordering, caseSensitive);
        }
        return new WidgetSelectOptionImpl((Serializable)((Object)value), var, itemLabel, itemValue, (Serializable)((Object)itemDisabled), (Serializable)((Object)itemRendered));
    }

    public static JSONObject exportPropsByModeToJson(Map<String, Map<String, Serializable>> propsByMode) {
        JSONObject props = new JSONObject();
        if (propsByMode != null) {
            ArrayList<String> defModes = new ArrayList<String>(propsByMode.keySet());
            Collections.sort(defModes);
            for (String defMode : defModes) {
                props.element(defMode, (Map)JSONLayoutExporter.exportPropsToJson(propsByMode.get(defMode)));
            }
        }
        return props;
    }

    public static Map<String, Map<String, Serializable>> importPropsByMode(JSONObject propsByMode) {
        HashMap<String, Map<String, Serializable>> props = new HashMap<String, Map<String, Serializable>>();
        if (propsByMode != null && !propsByMode.isNullObject()) {
            ArrayList defModes = new ArrayList(propsByMode.keySet());
            Collections.sort(defModes);
            for (String defMode : defModes) {
                props.put(defMode, JSONLayoutExporter.importProps(propsByMode.getJSONObject(defMode)));
            }
        }
        return props;
    }

    public static JSONObject exportPropsToJson(Map<String, Serializable> defProps) {
        JSONObject props = new JSONObject();
        if (defProps != null) {
            ArrayList<String> defPropNames = new ArrayList<String>(defProps.keySet());
            Collections.sort(defPropNames);
            for (String defPropName : defPropNames) {
                JSONArray array;
                Serializable value = defProps.get(defPropName);
                if (value instanceof Collection) {
                    array = new JSONArray();
                    array.addAll((Collection)((Object)value));
                    props.element(defPropName, (Collection)array);
                    continue;
                }
                if (value instanceof Object[]) {
                    array = new JSONArray();
                    for (Object item : (Object[])value) {
                        array.add(item);
                    }
                    props.element(defPropName, (Collection)array);
                    continue;
                }
                props.element(defPropName, (Object)value);
            }
        }
        return props;
    }

    public static Map<String, Serializable> importProps(JSONObject defProps) {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        if (defProps != null && !defProps.isNullObject()) {
            ArrayList defPropNames = new ArrayList(defProps.keySet());
            Collections.sort(defPropNames);
            for (String defPropName : defPropNames) {
                Object value = defProps.opt(defPropName);
                if (value instanceof JSONArray) {
                    ArrayList listValue = new ArrayList();
                    listValue.addAll((JSONArray)value);
                    continue;
                }
                props.put(defPropName, (Serializable)((Object)value.toString()));
            }
        }
        return props;
    }

    public static JSONObject exportStringPropsToJson(Map<String, String> defProps) {
        JSONObject props = new JSONObject();
        if (defProps != null) {
            ArrayList<String> defPropNames = new ArrayList<String>(defProps.keySet());
            Collections.sort(defPropNames);
            for (String defPropName : defPropNames) {
                props.element(defPropName, (Object)defProps.get(defPropName));
            }
        }
        return props;
    }

    public static Map<String, String> importStringProps(JSONObject defProps) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (defProps != null && !defProps.isNullObject()) {
            for (Object item : defProps.keySet()) {
                String key = (String)item;
                props.put(key, defProps.getString(key));
            }
        }
        return props;
    }

    public static JSONObject exportRenderingInfosByModeToJson(Map<String, List<RenderingInfo>> infosByMode) {
        JSONObject props = new JSONObject();
        if (infosByMode != null) {
            ArrayList<String> defModes = new ArrayList<String>(infosByMode.keySet());
            Collections.sort(defModes);
            for (String defMode : defModes) {
                props.element(defMode, (Collection)JSONLayoutExporter.exportRenderingInfosToJson(infosByMode.get(defMode)));
            }
        }
        return props;
    }

    public static Map<String, List<RenderingInfo>> importRenderingInfosByMode(JSONObject infosByMode) {
        HashMap<String, List<RenderingInfo>> props = new HashMap<String, List<RenderingInfo>>();
        if (infosByMode != null && !infosByMode.isNullObject()) {
            ArrayList defModes = new ArrayList(infosByMode.keySet());
            Collections.sort(defModes);
            for (String defMode : defModes) {
                props.put(defMode, JSONLayoutExporter.importRenderingInfos(infosByMode.getJSONArray(defMode)));
            }
        }
        return props;
    }

    public static JSONArray exportRenderingInfosToJson(List<RenderingInfo> infos) {
        JSONArray jinfos = new JSONArray();
        if (infos != null) {
            for (RenderingInfo info : infos) {
                jinfos.add((Object)JSONLayoutExporter.exportToJson(info));
            }
        }
        return jinfos;
    }

    public static List<RenderingInfo> importRenderingInfos(JSONArray jinfos) {
        ArrayList<RenderingInfo> infos = new ArrayList<RenderingInfo>();
        if (jinfos != null) {
            for (Object item : jinfos) {
                infos.add(JSONLayoutExporter.importRenderingInfo((JSONObject)item));
            }
        }
        return infos;
    }

    public static JSONObject exportToJson(RenderingInfo info) {
        JSONObject json = new JSONObject();
        json.element("level", (Object)info.getLevel());
        json.element("message", (Object)info.getMessage());
        json.element("translated", info.isTranslated());
        return json;
    }

    public static RenderingInfo importRenderingInfo(JSONObject fieldDef) {
        RenderingInfoImpl res = new RenderingInfoImpl(fieldDef.optString("level", ""), fieldDef.optString("message"), fieldDef.optBoolean("translated", false));
        return res;
    }
}

