/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.events;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.ReconnectedEventBundleImpl;

public class EventCounterListener
implements PostCommitEventListener {
    public final Counter createCount = Metrics.defaultRegistry().newCounter(EventCounterListener.class, "create");
    public final Counter updateCount = Metrics.defaultRegistry().newCounter(EventCounterListener.class, "update");
    public final Counter removeCount = Metrics.defaultRegistry().newCounter(EventCounterListener.class, "remove");
    protected static final List<String> createEvents = Arrays.asList("documentCreated", "documentCreatedByCopy", "documentImported", "documentProxyPublished", "documentProxyUpdated");
    protected static final List<String> updateEvents = Arrays.asList("documentCheckedIn", "documentCheckedOut", "childrenOrderChanged", "documentLocked", "documentMoved", "documentPublished", "documentSecurityUpdated", "documentUnlocked", "documentModified", "lifecycle_transition_event");
    protected static final List<String> removeEvents = Arrays.asList("documentRemoved", "versionRemoved");

    public void handleEvent(EventBundle events) throws ClientException {
        if (events instanceof ReconnectedEventBundleImpl) {
            ReconnectedEventBundleImpl bundle = (ReconnectedEventBundleImpl)events;
            this.updateCounters(bundle.getEventNames());
        }
    }

    protected void updateCounters(List<String> eventNames) {
        int created = 0;
        int updated = 0;
        int removed = 0;
        for (String eventName : eventNames) {
            if (createEvents.contains(eventName)) {
                ++created;
                continue;
            }
            if (updateEvents.contains(eventName)) {
                ++updated;
                continue;
            }
            if (!removeEvents.contains(eventName)) continue;
            ++removed;
        }
        if (created > 0) {
            this.createCount.inc((long)created);
        }
        if (updated > 0) {
            this.updateCount.inc((long)updated);
        }
        if (removed > 0) {
            this.removeCount.inc((long)removed);
        }
    }
}

