/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;

public class SimpleDataSource
implements DataSource {
    private static final Log log = LogFactory.getLog(SimpleDataSource.class);
    public static final int MAX_CONNECTION_TRIES = 5;
    private final String url;
    private final String user;
    private final String password;

    public SimpleDataSource(String url, String driver, String user, String password) {
        url = Framework.expandVars((String)url);
        driver = Framework.expandVars((String)driver);
        user = Framework.expandVars((String)user);
        password = Framework.expandVars((String)password);
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("driver class not found", e);
        }
        this.url = url;
        this.user = user;
        this.password = password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection con = null;
        int tryNo = 0;
        while (true) {
            try {
                con = DriverManager.getConnection(this.url, this.user, this.password);
            }
            catch (SQLException e) {
                if (++tryNo >= 5) {
                    throw e;
                }
                if (e.getErrorCode() != 12519) {
                    throw e;
                }
                log.warn((Object)String.format("Connections open too fast, retrying in %ds: %s", tryNo, e.getMessage().replace("\n", " ")));
                try {
                    Thread.sleep(1000 * tryNo);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
        con.setAutoCommit(false);
        return con;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

