/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.persistence;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.runtime.model.persistence.AbstractContribution;
import org.nuxeo.runtime.model.persistence.ContributionPersistenceComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContributionBuilder
extends AbstractContribution {
    protected final DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
    protected final List<String> extensions = new ArrayList<String>();
    protected String bundle;

    public ContributionBuilder(String name) {
        super(name);
    }

    @Override
    public URL asURL() {
        return null;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean isDisabled) {
        this.disabled = isDisabled;
    }

    public void addXmlExtension(String target, String point, String content) throws Exception {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<extension target=\"" + target + "\" point=\"" + point + "\">\n").append(content).append("\n</extension>");
        this.extensions.add(buf.toString());
    }

    public void addExtension(String target, String point, Object ... contribs) throws Exception {
        if (contribs != null && contribs.length > 0) {
            this.addExtension(target, point, Arrays.asList(contribs));
        }
    }

    public void addExtension(String target, String point, List<Object> contribs) throws Exception {
        DocumentBuilder docBuilder = this.dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("extension");
        root.setAttribute("target", target);
        root.setAttribute("point", point);
        doc.appendChild(root);
        XMap xmap = new XMap();
        for (Object contrib : contribs) {
            xmap.register(contrib.getClass());
            xmap.toXML(contrib, root);
        }
        this.extensions.add(DOMSerializer.toStringOmitXml((Element)root));
    }

    @Override
    public String getContent() {
        StringBuilder buf = new StringBuilder(32768);
        buf.append("<component name=\"").append(ContributionPersistenceComponent.getComponentName(this.name)).append("\" ");
        if (this.bundle != null) {
            buf.append("bundle=\"").append(this.bundle).append("\" ");
        }
        buf.append(">\n\n");
        if (this.description != null) {
            buf.append("<documentation>\n").append(this.description).append("\n</documentation>\n\n");
        }
        for (String xt : this.extensions) {
            buf.append(xt).append("\n\n");
        }
        buf.append("</component>\n");
        return buf.toString();
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.getContent().getBytes());
    }
}

