/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.osgi.application.loader.FrameworkLoader;

public class NuxeoStarter
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(NuxeoStarter.class);
    private static final String DEFAULT_HOME = "nuxeo";
    protected final Map<String, Object> env = new HashMap<String, Object>();
    protected List<File> bundleFiles = new ArrayList<File>();
    protected String webinflib;

    public void contextInitialized(ServletContextEvent event) {
        try {
            long startTime = System.currentTimeMillis();
            this.start(event);
            long finishedTime = System.currentTimeMillis();
            Double duration = (double)(finishedTime - startTime) / 1000.0;
            log.info((Object)String.format("Nuxeo framework started in %.1f sec.", duration));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            this.stop();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void start(ServletContextEvent event) throws Exception {
        ServletContext servletContext = event.getServletContext();
        this.findBundles(servletContext);
        this.findEnv(servletContext);
        ClassLoader cl = this.getClass().getClassLoader();
        File home = new File((String)this.env.get("nuxeo.runtime.home"));
        FrameworkLoader.initialize((ClassLoader)cl, (File)home, this.bundleFiles, this.env);
        FrameworkLoader.start();
    }

    protected void stop() throws Exception {
        FrameworkLoader.stop();
    }

    protected void findBundles(ServletContext servletContext) throws Exception {
        Set ctxpaths = servletContext.getResourcePaths("/WEB-INF/lib/");
        for (String ctxpath : ctxpaths) {
            String path;
            if (!ctxpath.endsWith(".jar") || (path = servletContext.getRealPath(ctxpath)) == null) continue;
            this.bundleFiles.add(new File(path));
            this.webinflib = path.substring(0, path.lastIndexOf(47));
        }
    }

    protected void findEnv(ServletContext servletContext) {
        for (String param : Arrays.asList("nuxeo.runtime.home", "nuxeo.config.dir", "nuxeo.data.dir", "nuxeo.log.dir", "nuxeo.tmp.dir", "nuxeo.web.dir")) {
            String value = servletContext.getInitParameter(param);
            if (value == null || "".equals(value.trim())) continue;
            this.env.put(param, value);
        }
        if (!this.env.containsKey("nuxeo.config.dir")) {
            String webinf = this.webinflib.substring(0, this.webinflib.lastIndexOf(47));
            this.env.put("nuxeo.config.dir", webinf);
        }
        if (!this.env.containsKey("nuxeo.runtime.home")) {
            File home = new File(DEFAULT_HOME);
            this.env.put("nuxeo.runtime.home", home.getAbsolutePath());
        }
        if (this.getClass().getClassLoader().getClass().getName().startsWith("org.jboss.classloader")) {
            this.env.put("org.nuxeo.app.host.name", "JBoss");
        } else if (servletContext.getClass().getName().startsWith("org.apache.catalina")) {
            this.env.put("org.nuxeo.app.host.name", "Tomcat");
        }
    }
}

