/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.AbstractMutable;
import org.jboss.seam.core.ConversationEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.core.conversationEntries")
@Install(precedence=0)
@Scope(value=ScopeType.SESSION)
@BypassInterceptors
public class ConversationEntries
extends AbstractMutable
implements Serializable {
    private static final long serialVersionUID = 7996835952419813634L;
    private Map<String, ConversationEntry> conversationIdEntryMap = new HashMap<String, ConversationEntry>();

    public synchronized Collection<ConversationEntry> getConversationEntries() {
        return Collections.unmodifiableCollection(this.conversationIdEntryMap.values());
    }

    public synchronized int size() {
        return this.conversationIdEntryMap.size();
    }

    public synchronized Set<String> getConversationIds() {
        return Collections.unmodifiableSet(this.conversationIdEntryMap.keySet());
    }

    public synchronized ConversationEntry createConversationEntry(String id, List<String> stack) {
        ConversationEntry entry = new ConversationEntry(id, stack, this);
        this.conversationIdEntryMap.put(id, entry);
        this.setDirty();
        return entry;
    }

    public synchronized ConversationEntry getConversationEntry(String id) {
        return this.conversationIdEntryMap.get(id);
    }

    public synchronized ConversationEntry removeConversationEntry(String id) {
        ConversationEntry entry = this.conversationIdEntryMap.remove(id);
        if (entry != null) {
            this.setDirty();
        }
        return entry;
    }

    public synchronized ConversationEntry updateConversationId(String oldId, String newId) {
        ConversationEntry entry = this.conversationIdEntryMap.remove(oldId);
        if (entry == null) {
            return null;
        }
        entry.setId(newId);
        entry.getConversationIdStack().set(0, newId);
        this.conversationIdEntryMap.put(newId, entry);
        this.setDirty();
        return entry;
    }

    public static ConversationEntries instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No session context active");
        }
        return (ConversationEntries)Component.getInstance(ConversationEntries.class, ScopeType.SESSION);
    }

    public static ConversationEntries getInstance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No session context active");
        }
        return (ConversationEntries)Component.getInstance(ConversationEntries.class, ScopeType.SESSION, false);
    }

    public String toString() {
        return "ConversationEntries(" + this.conversationIdEntryMap.values() + ")";
    }
}

