/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import org.jboss.seam.deployment.ClassDeploymentHandler;
import org.jboss.seam.deployment.ClassDescriptor;
import org.jboss.seam.deployment.DeploymentHandler;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.deployment.FileDescriptor;
import org.jboss.seam.deployment.Scanner;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScanner
implements Scanner {
    private static final LogProvider log = Logging.getLogProvider(Scanner.class);
    private DeploymentStrategy deploymentStrategy;

    public AbstractScanner(DeploymentStrategy deploymentStrategy) {
        this.deploymentStrategy = deploymentStrategy;
        ClassFile.class.getPackage();
    }

    protected static boolean hasAnnotations(ClassFile classFile, Set<Class<? extends Annotation>> annotationTypes) {
        AnnotationsAttribute visible;
        if (annotationTypes.size() > 0 && (visible = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations")) != null) {
            for (Class<? extends Annotation> annotationType : annotationTypes) {
                if (visible.getAnnotation(annotationType.getName()) == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ClassFile loadClassFile(String name, ClassLoader classLoader) throws IOException {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        InputStream stream = classLoader.getResourceAsStream(name);
        if (stream == null) {
            throw new IllegalStateException("Cannot load " + name + " from " + classLoader + " (using getResourceAsStream() returned null)");
        }
        DataInputStream dstream = new DataInputStream(stream);
        try {
            ClassFile classFile = new ClassFile(dstream);
            return classFile;
        }
        finally {
            dstream.close();
            stream.close();
        }
    }

    @Override
    public DeploymentStrategy getDeploymentStrategy() {
        return this.deploymentStrategy;
    }

    @Override
    public long getTimestamp() {
        return Long.MAX_VALUE;
    }

    protected void handleItem(String name) {
        new Handler(name, this.deploymentStrategy.getDeploymentHandlers().entrySet(), this.deploymentStrategy.getClassLoader()).handle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Handler {
        private ClassFile classFile;
        private ClassDescriptor classDescriptor;
        private FileDescriptor fileDescriptor;
        private Set<Map.Entry<String, DeploymentHandler>> deploymentHandlers;
        private ClassLoader classLoader;
        private String name;

        public Handler(String name, Set<Map.Entry<String, DeploymentHandler>> deploymentHandlers, ClassLoader classLoader) {
            this.deploymentHandlers = deploymentHandlers;
            this.name = name;
            this.classLoader = classLoader;
        }

        protected void handle(DeploymentHandler deploymentHandler) {
            if (deploymentHandler instanceof ClassDeploymentHandler) {
                if (this.name.endsWith(".class")) {
                    ClassDeploymentHandler classDeploymentHandler = (ClassDeploymentHandler)deploymentHandler;
                    if (AbstractScanner.hasAnnotations(this.getClassFile(), classDeploymentHandler.getMetadata().getClassAnnotatedWith())) {
                        log.trace("adding class to deployable list " + this.name + " for deployment handler " + deploymentHandler.getName());
                        if (this.getClassDescriptor().getClazz() != null) {
                            classDeploymentHandler.getClasses().add(this.getClassDescriptor());
                        }
                    }
                }
            } else if (this.name.endsWith(deploymentHandler.getMetadata().getFileNameSuffix())) {
                deploymentHandler.getResources().add(this.getFileDescriptor());
            }
        }

        protected void handle() {
            log.trace("found " + this.name);
            for (Map.Entry<String, DeploymentHandler> entry : this.deploymentHandlers) {
                this.handle(entry.getValue());
            }
        }

        private ClassFile getClassFile() {
            if (this.classFile == null) {
                try {
                    this.classFile = AbstractScanner.loadClassFile(this.name, this.classLoader);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error loading class file " + this.name, e);
                }
            }
            return this.classFile;
        }

        private ClassDescriptor getClassDescriptor() {
            if (this.classDescriptor == null) {
                this.classDescriptor = new ClassDescriptor(this.name, this.classLoader);
            }
            return this.classDescriptor;
        }

        private FileDescriptor getFileDescriptor() {
            if (this.fileDescriptor == null) {
                this.fileDescriptor = new FileDescriptor(this.name, this.classLoader);
            }
            return this.fileDescriptor;
        }
    }
}

