/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.exceptions.UserAlreadyExistsException;
import org.nuxeo.ecm.webapp.security.AbstractUserGroupManagement;
import org.nuxeo.runtime.api.Framework;

@Name(value="userManagementActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class UserManagementActions
extends AbstractUserGroupManagement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserManagementActions.class);
    public static final String USERS_TAB = "USER_CENTER:UsersGroupsHome:UsersHome";
    public static final String USERS_LISTING_CHANGED = "usersListingChanged";
    public static final String USERS_SEARCH_CHANGED = "usersSearchChanged";
    public static final String USER_SELECTED_CHANGED = "selectedUserChanged";
    public static final String SELECTED_LETTER_CHANGED = "selectedLetterChanged";
    protected String selectedLetter = "";
    protected DocumentModel selectedUser;
    protected DocumentModel newUser;

    @Override
    protected String computeListingMode() throws ClientException {
        return this.userManager.getUserListingMode();
    }

    public DocumentModel getSelectedUser() {
        this.shouldResetStateOnTabChange = true;
        return this.selectedUser;
    }

    public void setSelectedUser(DocumentModel user) {
        this.fireSeamEvent(USER_SELECTED_CHANGED);
        this.selectedUser = user;
    }

    @Deprecated
    public void setSelectedUser(String userName) throws ClientException {
        this.setSelectedUser(this.refreshUser(userName));
    }

    public void setSelectedUserName(String userName) throws ClientException {
        this.setSelectedUser(this.refreshUser(userName));
    }

    public String getSelectedUserName() throws ClientException {
        return this.selectedUser.getId();
    }

    protected DocumentModel refreshUser(String userName) throws ClientException {
        return this.userManager.getUserModel(userName);
    }

    public String getSelectedLetter() {
        return this.selectedLetter;
    }

    public void setSelectedLetter(String selectedLetter) {
        if (selectedLetter != null && !selectedLetter.equals(this.selectedLetter)) {
            this.selectedLetter = selectedLetter;
            this.fireSeamEvent(SELECTED_LETTER_CHANGED);
        }
        this.selectedLetter = selectedLetter;
    }

    public DocumentModel getNewUser() throws ClientException {
        if (this.newUser == null) {
            this.newUser = this.userManager.getBareUserModel();
        }
        return this.newUser;
    }

    public boolean getAllowEditUser() throws ClientException {
        return this.getCanEditUsers(true) && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedUser);
    }

    protected boolean getCanEditUsers(boolean allowCurrentUser) throws ClientException {
        NuxeoPrincipal selectedPrincipal;
        if (this.userManager.areUsersReadOnly().booleanValue()) {
            return false;
        }
        if (this.selectedUser != null && this.userManager.getAnonymousUserId() != null && this.userManager.getAnonymousUserId().equals(this.selectedUser.getId())) {
            return false;
        }
        if (this.selectedUser != null && (selectedPrincipal = this.userManager.getPrincipal(this.selectedUser.getId())).isAdministrator() && !((NuxeoPrincipal)this.currentUser).isAdministrator()) {
            return false;
        }
        if (this.currentUser instanceof NuxeoPrincipal) {
            NuxeoPrincipal pal = (NuxeoPrincipal)this.currentUser;
            if (this.webActions.checkFilter("usersGroupsManagementAccess")) {
                return true;
            }
            if (allowCurrentUser && this.selectedUser != null && pal.getName().equals(this.selectedUser.getId())) {
                return true;
            }
        }
        return false;
    }

    public boolean getAllowChangePassword() throws ClientException {
        return this.getCanEditUsers(true) && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedUser);
    }

    public boolean getAllowCreateUser() throws ClientException {
        return this.getCanEditUsers(false);
    }

    public boolean getAllowDeleteUser() throws ClientException {
        return this.getCanEditUsers(false) && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedUser);
    }

    public void clearSearch() {
        this.searchString = null;
        this.fireSeamEvent(USERS_SEARCH_CHANGED);
    }

    public void createUser() throws ClientException {
        this.createUser(false);
    }

    public void createUser(boolean createAnotherUser) throws ClientException {
        try {
            this.setSelectedUser(this.userManager.createUser(this.newUser));
            this.newUser = null;
            this.facesMessages.add(StatusMessage.Severity.INFO, this.resourcesAccessor.getMessages().get("info.userManager.userCreated"), new Object[0]);
            if (createAnotherUser) {
                this.showCreateForm = true;
            } else {
                this.showCreateForm = false;
                this.showUserOrGroup = true;
                this.detailsMode = null;
            }
            this.fireSeamEvent(USERS_LISTING_CHANGED);
        }
        catch (UserAlreadyExistsException e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.resourcesAccessor.getMessages().get("error.userManager.userAlreadyExists"), new Object[0]);
        }
    }

    public void updateUser() throws ClientException {
        try {
            this.userManager.updateUser(this.selectedUser);
            this.detailsMode = "view";
            this.fireSeamEvent(USERS_LISTING_CHANGED);
        }
        catch (Exception t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public String changePassword() throws ClientException {
        this.updateUser();
        this.detailsMode = "view";
        String message = this.resourcesAccessor.getMessages().get("label.userManager.password.changed");
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, message, new Object[0]);
        this.fireSeamEvent(USERS_LISTING_CHANGED);
        return null;
    }

    public void deleteUser() throws ClientException {
        try {
            this.userManager.deleteUser(this.selectedUser);
            this.selectedUser = null;
            this.showUserOrGroup = false;
            this.fireSeamEvent(USERS_LISTING_CHANGED);
        }
        catch (Exception t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void validateUserName(FacesContext context, UIComponent component, Object value) {
        if (!(value instanceof String) || !StringUtils.containsOnly((String)((String)value), (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-0123456789.@")) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.userManager.wrong.username"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
    }

    public void validatePassword(FacesContext context, UIComponent component, Object value) {
        Map attributes = component.getAttributes();
        String firstPasswordInputId = (String)attributes.get("firstPasswordInputId");
        String secondPasswordInputId = (String)attributes.get("secondPasswordInputId");
        if (firstPasswordInputId == null || secondPasswordInputId == null) {
            log.error((Object)"Cannot validate passwords: input id(s) not found");
            return;
        }
        UIInput firstPasswordComp = (UIInput)component.findComponent(firstPasswordInputId);
        UIInput secondPasswordComp = (UIInput)component.findComponent(secondPasswordInputId);
        if (firstPasswordComp == null || secondPasswordComp == null) {
            log.error((Object)"Cannot validate passwords: input(s) not found");
            return;
        }
        Object firstPassword = firstPasswordComp.getLocalValue();
        Object secondPassword = secondPasswordComp.getLocalValue();
        if (firstPassword == null || secondPassword == null) {
            log.error((Object)"Cannot validate passwords: value(s) not found");
            return;
        }
        if (!firstPassword.equals(secondPassword)) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.userManager.password.not.match"), null);
            throw new ValidatorException(message);
        }
    }

    @Factory(value="notReadOnly", scope=ScopeType.APPLICATION)
    public boolean isNotReadOnly() {
        return !Framework.isBooleanPropertyTrue((String)"org.nuxeo.ecm.webapp.readonly.mode");
    }

    public List<String> getUserVirtualGroups(String userId) throws Exception {
        NuxeoPrincipal principal = this.userManager.getPrincipal(userId);
        if (principal instanceof NuxeoPrincipalImpl) {
            NuxeoPrincipalImpl user = (NuxeoPrincipalImpl)principal;
            return user.getVirtualGroups();
        }
        return null;
    }

    public String viewUser() throws ClientException {
        if (this.selectedUser != null) {
            return this.viewUser(this.selectedUser.getId());
        }
        return null;
    }

    public String viewUser(String userName) throws ClientException {
        this.webActions.setCurrentTabIds("MAIN_TABS:home,USER_CENTER:UsersGroupsHome:UsersHome");
        this.setSelectedUser(userName);
        this.showUserOrGroup = true;
        this.shouldResetStateOnTabChange = false;
        return "view_home";
    }

    public void setShowUser(String showUser) {
        this.showUserOrGroup = Boolean.valueOf(showUser);
    }

    protected void fireSeamEvent(String eventName) {
        Events evtManager = Events.instance();
        evtManager.raiseEvent(eventName, new Object[0]);
    }

    @Factory(value="anonymousUserDefined", scope=ScopeType.APPLICATION)
    public boolean anonymousUserDefined() throws ClientException {
        return this.userManager.getAnonymousUserId() != null;
    }

    @Observer(value={"usersListingChanged"})
    public void onUsersListingChanged() {
        this.contentViewActions.refreshOnSeamEvent(USERS_LISTING_CHANGED);
        this.contentViewActions.resetPageProviderOnSeamEvent(USERS_LISTING_CHANGED);
    }

    @Observer(value={"usersSearchChanged"})
    public void onUsersSearchChanged() {
        this.contentViewActions.refreshOnSeamEvent(USERS_SEARCH_CHANGED);
        this.contentViewActions.resetPageProviderOnSeamEvent(USERS_SEARCH_CHANGED);
    }

    @Observer(value={"selectedLetterChanged"})
    public void onSelectedLetterChanged() {
        this.contentViewActions.refreshOnSeamEvent(SELECTED_LETTER_CHANGED);
        this.contentViewActions.resetPageProviderOnSeamEvent(SELECTED_LETTER_CHANGED);
    }

    @Observer(value={"currentTabChanged_MAIN_TABS", "currentTabChanged_NUXEO_ADMIN", "currentTabChanged_USER_CENTER", "currentTabChanged_UsersGroupsManager_sub_tab", "currentTabChanged_UsersGroupsHome_sub_tab", "currentTabSelected_MAIN_TABS", "currentTabSelected_NUXEO_ADMIN", "currentTabSelected_USER_CENTER", "currentTabSelected_UsersGroupsManager_sub_tab", "currentTabSelected_UsersGroupsHome_sub_tab"})
    public void resetState() {
        if (this.shouldResetStateOnTabChange) {
            this.newUser = null;
            this.selectedUser = null;
            this.showUserOrGroup = false;
            this.showCreateForm = false;
            this.detailsMode = "view";
        }
    }
}

