/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelRowEvent;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.codec.DocumentFileCodec;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.action.DeleteActions;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="documentActions")
@Scope(value=ScopeType.CONVERSATION)
public class DocumentActionsBean
extends InputController
implements DocumentActions,
Serializable {
    private static final long serialVersionUID = -2069669959016643607L;
    private static final Log log = LogFactory.getLog(DocumentActionsBean.class);
    @Deprecated
    public static final String DEFAULT_SUMMARY_LAYOUT = "default_summary_layout";
    public static final String LIFE_CYCLE_TRANSITION_KEY = "lifeCycleTransition";
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @RequestParameter
    protected String fileFieldFullName;
    @RequestParameter
    protected String filenameFieldFullName;
    @RequestParameter
    protected String filename;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(required=false, create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient DeleteActions deleteActions;
    @RequestParameter
    protected Boolean restoreCurrentTabs;
    @In(create=true)
    protected transient WebActions webActions;
    protected String comment;
    @RequestParameter
    protected String parentDocumentPath;

    @Deprecated
    @Factory(autoCreate=true, value="currentDocumentSummaryLayout", scope=ScopeType.EVENT)
    public String getCurrentDocumentSummaryLayout() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (doc == null) {
            return null;
        }
        String[] layouts = this.typeManager.getType(doc.getType()).getLayouts("summary", null);
        if (layouts != null && layouts.length > 0) {
            return layouts[0];
        }
        return DEFAULT_SUMMARY_LAYOUT;
    }

    @Factory(autoCreate=true, value="currentDocumentType", scope=ScopeType.EVENT)
    public Type getCurrentType() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (doc == null) {
            return null;
        }
        return this.typeManager.getType(doc.getType());
    }

    public Type getChangeableDocumentType() {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        if (changeableDocument == null) {
            this.navigationContext.setChangeableDocument(this.navigationContext.getCurrentDocument());
            changeableDocument = this.navigationContext.getChangeableDocument();
        }
        if (changeableDocument == null) {
            return null;
        }
        return this.typeManager.getType(changeableDocument.getType());
    }

    @Deprecated
    public String editDocument() throws ClientException {
        this.navigationContext.setChangeableDocument(this.navigationContext.getCurrentDocument());
        return this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument(), "edit");
    }

    public String getFileName(DocumentModel doc) throws ClientException {
        try {
            String name = null;
            if (this.filename != null && !"".equals(this.filename)) {
                name = this.filename;
            } else {
                if (this.filenameFieldFullName != null) {
                    String[] s = this.filenameFieldFullName.split(":");
                    try {
                        name = (String)doc.getProperty(s[0], s[1]);
                    }
                    catch (ArrayIndexOutOfBoundsException err) {
                        // empty catch block
                    }
                }
                if (name == null || "".equals(name)) {
                    name = (String)doc.getProperty("dublincore", "title");
                }
            }
            return name;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Deprecated
    public String download() throws ClientException {
        try {
            if (this.fileFieldFullName == null) {
                return null;
            }
            String[] s = this.fileFieldFullName.split(":");
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            Blob blob = (Blob)currentDocument.getProperty(s[0], s[1]);
            String filename = this.getFileName(currentDocument);
            FacesContext context = FacesContext.getCurrentInstance();
            return ComponentUtils.download((FacesContext)context, (Blob)blob, (String)filename);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void download(DocumentView docView) throws ClientException {
        if (docView != null) {
            DocumentModel doc;
            DocumentLocation docLoc = docView.getDocumentLocation();
            if (this.documentManager == null) {
                RepositoryLocation loc = new RepositoryLocation(docLoc.getServerName());
                this.navigationContext.setCurrentServerLocation(loc);
                this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            }
            if ((doc = this.documentManager.getDocument(docLoc.getDocRef())) != null) {
                Blob blob = DocumentFileCodec.getBlob((DocumentModel)doc, (DocumentView)docView);
                if (blob == null) {
                    log.warn((Object)("No blob for docView: " + docView));
                    return;
                }
                String filename = DocumentFileCodec.getFilename((DocumentModel)doc, (DocumentView)docView);
                FacesContext context = FacesContext.getCurrentInstance();
                if (blob.getLength() > Functions.getBigFileSizeLimit()) {
                    HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
                    HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
                    String bigDownloadURL = BaseURL.getBaseURL((ServletRequest)request);
                    bigDownloadURL = bigDownloadURL + "nxbigfile/";
                    bigDownloadURL = bigDownloadURL + doc.getRepositoryName() + "/";
                    bigDownloadURL = bigDownloadURL + doc.getRef().toString() + "/";
                    bigDownloadURL = bigDownloadURL + docView.getParameter("FILE_PROPERTY_PATH") + "/";
                    bigDownloadURL = bigDownloadURL + URIUtils.quoteURIPathComponent((String)filename, (boolean)true);
                    try {
                        response.sendRedirect(bigDownloadURL);
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while redirecting for big file downloader", (Throwable)e);
                    }
                } else {
                    ComponentUtils.download((FacesContext)context, (Blob)blob, (String)filename);
                }
            }
        }
    }

    @Deprecated
    public String downloadFromList() throws ClientException {
        return null;
    }

    public String updateDocument(DocumentModel doc, Boolean restoreCurrentTabs) throws ClientException {
        try {
            String tabId = null;
            String subTabId = null;
            boolean restoreTabs = Boolean.TRUE.equals(restoreCurrentTabs);
            if (restoreTabs) {
                tabId = this.webActions.getCurrentTabId();
                subTabId = this.webActions.getCurrentSubTabId();
            }
            Events.instance().raiseEvent("beforeDocumentChanged", new Object[]{doc});
            doc = this.documentManager.saveDocument(doc);
            this.throwUpdateComments(doc);
            this.documentManager.save();
            this.navigationContext.invalidateCurrentDocument();
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("document_modified"), new Object[]{this.resourcesAccessor.getMessages().get(doc.getType())});
            EventManager.raiseEventsOnDocumentChange((DocumentModel)doc);
            String res = this.navigationContext.navigateToDocument(doc, "after-edit");
            if (restoreTabs) {
                this.webActions.setCurrentTabId(tabId);
                this.webActions.setCurrentSubTabId(subTabId);
            }
            return res;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    protected String updateDocument(DocumentModel doc) throws ClientException {
        return this.updateDocument(doc, this.restoreCurrentTabs);
    }

    public String updateCurrentDocument() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.updateDocument(currentDocument);
    }

    @Deprecated
    public String updateDocument() throws ClientException {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        return this.updateDocument(changeableDocument);
    }

    public String updateDocumentAsNewVersion() throws ClientException {
        try {
            DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
            changeableDocument.putContextData(org.nuxeo.common.collections.ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", (Serializable)Boolean.TRUE);
            changeableDocument = this.documentManager.saveDocument(changeableDocument);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("new_version_created"), new Object[0]);
            EventManager.raiseEventsOnDocumentChange((DocumentModel)changeableDocument);
            return this.navigationContext.navigateToDocument(changeableDocument, "after-edit");
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public String createDocument() throws ClientException {
        Type docType = this.typesTool.getSelectedType();
        return this.createDocument(docType.getId());
    }

    public String createDocument(String typeName) throws ClientException {
        Type docType = this.typeManager.getType(typeName);
        this.typesTool.setSelectedType(docType);
        try {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("parentPath", this.navigationContext.getCurrentDocument().getPathAsString());
            DocumentModel changeableDocument = this.documentManager.createDocumentModel(typeName, context);
            this.navigationContext.setChangeableDocument(changeableDocument);
            return this.navigationContext.getActionResult(changeableDocument, UserAction.CREATE);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public String saveDocument() throws ClientException {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        return this.saveDocument(changeableDocument);
    }

    public String saveDocument(DocumentModel newDocument) throws ClientException {
        if (newDocument.getId() != null) {
            log.debug((Object)("Document " + newDocument.getName() + " already created"));
            return this.navigationContext.navigateToDocument(newDocument, "after-create");
        }
        try {
            PathSegmentService pss;
            try {
                pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            if (this.parentDocumentPath == null) {
                this.parentDocumentPath = currentDocument == null ? this.documentManager.getRootDocument().getPathAsString() : this.navigationContext.getCurrentDocument().getPathAsString();
            }
            newDocument.setPathInfo(this.parentDocumentPath, pss.generatePathSegment(newDocument));
            newDocument = this.documentManager.createDocument(newDocument);
            this.documentManager.save();
            this.logDocumentWithTitle("Created the document: ", newDocument);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("document_saved"), new Object[]{this.resourcesAccessor.getMessages().get(newDocument.getType())});
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
            return this.navigationContext.navigateToDocument(newDocument, "after-create");
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void processSelectRowEvent(SelectDataModelRowEvent event) {
        Boolean selection = event.getSelected();
        DocumentModel data = (DocumentModel)event.getRowData();
        if (Boolean.TRUE.equals(selection)) {
            this.documentsListsManager.addToWorkingList("CURRENT_SELECTION", data);
        } else {
            this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION", data);
        }
    }

    private String handleError(String errorMessage) {
        log.error((Object)errorMessage);
        return "ERROR: " + errorMessage;
    }

    public boolean getWriteRight() throws ClientException {
        return this.documentManager.hasPermission(this.navigationContext.getCurrentDocument().getRef(), "Write");
    }

    private void throwUpdateComments(DocumentModel changeableDocument) {
        if (this.comment != null && !"".equals(this.comment)) {
            changeableDocument.getContextData().put((Object)"comment", (Object)this.comment);
        }
    }

    @Deprecated
    public String getComment() {
        return "";
    }

    @Deprecated
    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean getCanUnpublish() {
        List docList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
        if (docList != null && !docList.isEmpty() && this.deleteActions.checkDeletePermOnParents(docList)) {
            for (DocumentModel document : docList) {
                if (!document.getType().equals("SectionRoot") && !document.getType().equals("Section")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Observer(value={"beforeDocumentChanged"})
    public void followTransition(DocumentModel changedDocument) throws ClientException {
        String transitionToFollow = (String)((Object)changedDocument.getContextData(org.nuxeo.common.collections.ScopeType.REQUEST, LIFE_CYCLE_TRANSITION_KEY));
        if (transitionToFollow != null) {
            this.documentManager.followTransition(changedDocument.getRef(), transitionToFollow);
            this.documentManager.save();
        }
    }
}

