/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work.api;

import java.io.Serializable;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.work.api.WorkSchedulePath;

public interface Work
extends Serializable {
    public void work() throws Exception;

    public String getId();

    public void cleanUp(boolean var1, Exception var2);

    public void setWorkInstanceSuspending();

    public boolean isSuspending();

    public void suspended();

    public boolean isWorkInstanceSuspended();

    public void setWorkInstanceState(State var1);

    public State getWorkInstanceState();

    @Deprecated
    public State getState();

    public String getCategory();

    public String getTitle();

    public String getStatus();

    public long getSchedulingTime();

    public long getStartTime();

    public long getCompletionTime();

    public void setProgress(Progress var1);

    public Progress getProgress();

    public String getUserId();

    public DocumentLocation getDocument();

    public List<DocumentLocation> getDocuments();

    public boolean isDocumentTree();

    public WorkSchedulePath getSchedulePath();

    public void setSchedulePath(WorkSchedulePath var1);

    public static class Progress
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static long CURRENT_INDETERMINATE = -1L;
        public static float PERCENT_INDETERMINATE = -1.0f;
        public static final Progress PROGRESS_INDETERMINATE = new Progress(PERCENT_INDETERMINATE);
        public static final Progress PROGRESS_0_PC = new Progress(0.0f);
        public static final Progress PROGRESS_100_PC = new Progress(100.0f);
        protected final float percent;
        protected final long current;
        protected final long total;

        public Progress(float percent) {
            this.percent = percent > 100.0f ? 100.0f : percent;
            this.current = CURRENT_INDETERMINATE;
            this.total = 0L;
        }

        public Progress(long current, long total) {
            this.percent = PERCENT_INDETERMINATE;
            this.current = current;
            this.total = total;
        }

        public float getPercent() {
            return this.percent;
        }

        public long getCurrent() {
            return this.current;
        }

        public long getTotal() {
            return this.total;
        }

        public boolean getIsWithPercent() {
            return this.percent != PERCENT_INDETERMINATE;
        }

        public boolean getIsWithCurrentAndTotal() {
            return this.current != CURRENT_INDETERMINATE;
        }

        public boolean getIsIndeterminate() {
            return this.percent == PERCENT_INDETERMINATE && this.current == CURRENT_INDETERMINATE;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + (this.percent == PERCENT_INDETERMINATE ? "?" : Float.valueOf(this.percent)) + "%, " + (this.current == CURRENT_INDETERMINATE ? "?" : Long.valueOf(this.current)) + "/" + this.total + ")";
        }
    }

    public static enum State {
        SCHEDULED,
        CANCELED,
        RUNNING,
        COMPLETED,
        FAILED;

    }
}

