/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class RepositoryManagerImpl
extends DefaultComponent
implements RepositoryManager {
    private static final Log log = LogFactory.getLog(RepositoryManagerImpl.class);
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.api.repository.RepositoryManager");
    private Map<String, Repository> repositories = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    public void addRepository(Repository repository) {
        String repoName = repository.getName();
        if (this.repositories.containsKey(repoName)) {
            log.info((Object)("Overriding repository " + repoName));
        } else {
            log.info((Object)("Registering repository " + repoName));
        }
        this.repositories.put(repoName, repository);
    }

    @Override
    public Collection<Repository> getRepositories() {
        return new ArrayList<Repository>(this.repositories.values());
    }

    @Override
    public Repository getRepository(String name) {
        return this.repositories.get(name);
    }

    @Override
    public void removeRepository(String name) {
        log.info((Object)("Removing repository " + name));
        this.repositories.remove(name);
    }

    @Override
    public void clear() {
        this.repositories.clear();
    }

    @Override
    public Repository getDefaultRepository() {
        Iterator<Repository> it = this.repositories.values().iterator();
        Repository defaultRepo = null;
        while (it.hasNext()) {
            Repository repo = it.next();
            if (repo.isDefault()) {
                return repo;
            }
            if (!"default".equals(repo.getName())) continue;
            defaultRepo = repo;
        }
        if (defaultRepo != null) {
            return defaultRepo;
        }
        if (!this.repositories.isEmpty()) {
            return this.repositories.values().iterator().next();
        }
        return null;
    }

    public void activate(ComponentContext context) throws Exception {
        this.repositories.clear();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.repositories.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("repositories".equals(extensionPoint)) {
            this.addRepository((Repository)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("repositories".equals(extensionPoint)) {
            this.removeRepository(((Repository)contribution).getName());
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (RepositoryManager.class.isAssignableFrom(adapter)) {
            return (T)this;
        }
        return null;
    }
}

