/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class Context
extends ArrayList<Object> {
    private static final long serialVersionUID = 1L;
    private final HashMap<String, Object> properties = new HashMap();

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        if (className.startsWith("[")) {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    public URL getResource(String name) {
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    public Object getObject() {
        int size = this.size();
        if (size > 0) {
            return this.get(size - 1);
        }
        return null;
    }

    public Object getParent() {
        int size = this.size();
        if (size > 1) {
            return this.get(size - 2);
        }
        return null;
    }

    public void push(Object object) {
        this.add(object);
    }

    public Object pop() {
        int size = this.size();
        if (size > 0) {
            return this.remove(size - 1);
        }
        return null;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }
}

