/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platformui.web.form;

import com.sun.faces.renderkit.html_basic.FormRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.runtime.api.Framework;

public class NxFormRenderer
extends FormRenderer {
    public static final String ENABLE_DOUBLE_CLICK_SHIELD = "nuxeo.jsf.enableDoubleClickShield";
    public static final String ENABLE_DOUBLE_CLICK_ON_ELEMENT = "disableDoubleClickShield";
    public static final String DOUBLE_CLICK_SHIELD_CSS_CLASS_FLAG = "doubleClickShielded";

    protected static boolean isDoubleShieldEnabled() {
        return !Framework.isBooleanPropertyFalse((String)ENABLE_DOUBLE_CLICK_SHIELD);
    }

    protected static boolean dcDisabledOnElement(UIComponent component) {
        if (component != null) {
            Object dcDisabledOnElement = component.getAttributes().get(ENABLE_DOUBLE_CLICK_ON_ELEMENT);
            if (dcDisabledOnElement != null) {
                if (dcDisabledOnElement instanceof String) {
                    return Boolean.TRUE.equals(Boolean.valueOf((String)dcDisabledOnElement));
                }
                if (dcDisabledOnElement instanceof Boolean) {
                    return Boolean.TRUE.equals(dcDisabledOnElement);
                }
            }
        } else {
            return true;
        }
        return false;
    }

    protected static boolean containsDoubleClickShieldClass(String styleClass) {
        if (styleClass != null) {
            String[] split;
            for (String s : split = styleClass.split(" ")) {
                if (!s.equals(DOUBLE_CLICK_SHIELD_CSS_CLASS_FLAG)) continue;
                return true;
            }
        }
        return false;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered() && NxFormRenderer.isDoubleShieldEnabled() && !NxFormRenderer.dcDisabledOnElement(component)) {
            String styleClass = (String)((HtmlForm)component).getAttributes().get("styleClass");
            if (StringUtils.isBlank((String)styleClass)) {
                ((HtmlForm)component).setStyleClass(DOUBLE_CLICK_SHIELD_CSS_CLASS_FLAG);
            } else if (!NxFormRenderer.containsDoubleClickShieldClass(styleClass)) {
                ((HtmlForm)component).setStyleClass(styleClass + " " + DOUBLE_CLICK_SHIELD_CSS_CLASS_FLAG);
            }
        }
        super.encodeBegin(context, component);
    }
}

