/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.io.Serializable;
import java.util.Arrays;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.automation.core.OperationChainContribution;

public class OperationDocumentation
implements Comparable<OperationDocumentation>,
Serializable {
    private static final long serialVersionUID = 1L;
    public String id;
    public String[] signature;
    public String category;
    public String label;
    public String requires;
    public String since;
    public String description;
    public Param[] params;
    public OperationChainContribution.Operation[] operations;
    public String url;

    public OperationDocumentation(String id) {
        this.id = id;
        this.url = id;
    }

    @Override
    public int compareTo(OperationDocumentation o) {
        String s1 = this.label == null ? this.id : this.label;
        String s2 = o.label == null ? o.id : o.label;
        return s1.compareTo(s2);
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getSignature() {
        return this.signature;
    }

    public String getCategory() {
        return this.category;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLabel() {
        return this.label;
    }

    public String getRequires() {
        return this.requires;
    }

    public Param[] getParams() {
        return this.params;
    }

    public OperationChainContribution.Operation[] getOperations() {
        return this.operations;
    }

    public String toString() {
        return this.category + " > " + this.label + " [" + this.id + ": " + Arrays.asList(this.signature) + "] (" + this.params + ")\n" + this.description;
    }

    @XObject(value="param")
    public static class Param
    implements Serializable,
    Comparable<Param> {
        private static final long serialVersionUID = 1L;
        @XNode(value="@name")
        public String name;
        @XNode(value="@description")
        public String description;
        @XNode(value="@type")
        public String type;
        public String widget;
        @XNodeList(value="values", type=String[].class, componentType=String.class)
        public String[] values;
        @XNode(value="@order")
        public int order;
        @XNode(value="@required")
        public boolean isRequired;

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public String getWidget() {
            return this.widget;
        }

        public String[] getValues() {
            return this.values;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return this.name + " [" + this.type + "] " + (this.isRequired ? "required" : "optional");
        }

        @Override
        public int compareTo(Param o) {
            if (this.order != 0 && o.order != 0) {
                if (this.order < o.order) {
                    return -1;
                }
                if (this.order > o.order) {
                    return 1;
                }
            }
            if (this.isRequired && !o.isRequired) {
                return -1;
            }
            if (o.isRequired && !this.isRequired) {
                return 1;
            }
            return this.name.compareTo(o.name);
        }
    }
}

