/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.trace;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.trace.Call;
import org.nuxeo.ecm.automation.core.trace.Trace;

public class TracePrinter {
    private static final Log log = LogFactory.getLog(TracePrinter.class);
    protected final BufferedWriter writer;
    protected String preamble = "";

    public TracePrinter(Writer writer) {
        this.writer = new BufferedWriter(writer);
    }

    public TracePrinter(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    protected void printLine(String line) throws IOException {
        this.writer.write(this.preamble + line);
    }

    protected void printHeading(String heading) throws IOException {
        this.printLine(System.getProperty("line.separator") + System.getProperty("line.separator") + "****** " + heading + " ******");
    }

    public void print(Trace trace) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.printHeading("chain");
        if (trace.error != null) {
            sb.append(System.getProperty("line.separator"));
            if (trace.getParent() != null) {
                sb.append("Parent Chain ID: ");
                sb.append(trace.getParent().getChainId());
                sb.append(System.getProperty("line.separator"));
            }
            sb.append("Name: ");
            sb.append(trace.getChain().getId());
            sb.append(System.getProperty("line.separator"));
            sb.append("Exception: ");
            sb.append(trace.error.getClass().getSimpleName());
            sb.append(System.getProperty("line.separator"));
            sb.append("Caught error: ");
            sb.append(trace.error.getMessage());
            sb.append(System.getProperty("line.separator"));
            sb.append("Caused by: ");
            sb.append(trace.error.getCause());
            this.printLine(sb.toString());
        } else {
            sb.append(System.getProperty("line.separator"));
            if (trace.getParent() != null) {
                sb.append("Parent Chain ID: ");
                sb.append(trace.getParent().getChainId());
                sb.append(System.getProperty("line.separator"));
            }
            sb.append("Name: ");
            sb.append(trace.getChain().getId());
            sb.append(System.getProperty("line.separator"));
            sb.append("Produced output type: ");
            sb.append(trace.output == null ? "Void" : trace.output.getClass().getSimpleName());
            this.printLine(sb.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("****** Hierarchy calls ******");
        stringBuilder.append(System.getProperty("line.separator"));
        this.displayOperationTreeCalls(trace.operations, stringBuilder);
        this.printLine(stringBuilder.toString());
        this.print(trace.operations);
        this.writer.flush();
    }

    public void print(List<Call> calls) throws IOException {
        for (Call call : calls) {
            this.print(call);
        }
    }

    public void print(Call call) throws IOException {
        this.printCall(call);
    }

    public void printCall(Call call) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(System.getProperty("line.separator"));
            sb.append(System.getProperty("line.separator"));
            sb.append("****** " + call.getType().getId() + " ******");
            sb.append(System.getProperty("line.separator"));
            sb.append("Chain ID: ");
            sb.append(call.getChainId());
            sb.append(System.getProperty("line.separator"));
            sb.append("Class: ");
            sb.append(call.getType().getType().getSimpleName());
            sb.append(System.getProperty("line.separator"));
            sb.append("Method: '");
            sb.append(call.getMethod().getMethod().getName());
            sb.append("' | Input Type: ");
            sb.append(call.getMethod().getConsume());
            sb.append(" | Output Type: ");
            sb.append(call.getMethod().getProduce());
            sb.append(System.getProperty("line.separator"));
            sb.append("Input: ");
            sb.append(call.getInput());
            if (!call.getParmeters().isEmpty()) {
                sb.append(System.getProperty("line.separator"));
                sb.append("Parameters ");
                for (String parameter : call.getParmeters().keySet()) {
                    sb.append(" | ");
                    sb.append("Name: ");
                    sb.append(parameter);
                    sb.append(", Value: ");
                    sb.append(call.getParmeters().get(parameter));
                }
            }
            if (!call.getVariables().isEmpty()) {
                sb.append(System.getProperty("line.separator"));
                sb.append("Context Variables");
                for (String keyVariable : call.getVariables().keySet()) {
                    sb.append(" | ");
                    sb.append("Key: ");
                    sb.append(keyVariable);
                    sb.append(", Value: ");
                    Object variable = call.getVariables().get(keyVariable);
                    if (variable instanceof Calendar) {
                        sb.append(((Calendar)variable).getTime());
                        continue;
                    }
                    sb.append(variable);
                }
            }
            this.printLine(sb.toString());
            sb = new StringBuilder();
            if (!call.getNested().isEmpty()) {
                sb.append(System.getProperty("line.separator"));
                this.printHeading("start sub chain");
                for (Trace trace : call.getNested()) {
                    this.print(trace);
                }
                sb.append(System.getProperty("line.separator"));
                this.printHeading("end sub chain");
            }
            this.printLine(sb.toString());
        }
        catch (IOException e) {
            log.error((Object)"Nuxeo TracePrinter cannot write traces output", (Throwable)e);
        }
    }

    public void litePrint(Trace trace) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.printHeading("chain");
        if (trace.error != null) {
            sb.append(System.getProperty("line.separator"));
            if (trace.getParent() != null) {
                sb.append("Parent Chain ID: ");
                sb.append(trace.getParent().getChainId());
                sb.append(System.getProperty("line.separator"));
            }
            sb.append("Name: ");
            sb.append(trace.getChain().getId());
            sb.append(System.getProperty("line.separator"));
            sb.append("Exception: ");
            sb.append(trace.error.getClass().getSimpleName());
            sb.append(System.getProperty("line.separator"));
            sb.append("Caught error: ");
            sb.append(trace.error.getMessage());
            sb.append(System.getProperty("line.separator"));
            sb.append("Caused by: ");
            sb.append(trace.error.getCause());
        }
        sb.append(System.getProperty("line.separator"));
        sb.append("****** Hierarchy calls ******");
        this.printLine(sb.toString());
        this.litePrintCall(trace.operations);
        this.writer.flush();
    }

    public void litePrintCall(List<Call> calls) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.getProperty("line.separator"));
        try {
            this.displayOperationTreeCalls(calls, stringBuilder);
            this.printLine(stringBuilder.toString());
            stringBuilder = new StringBuilder();
            for (Call call : calls) {
                if (call.getNested().isEmpty()) continue;
                stringBuilder.append(System.getProperty("line.separator"));
                this.printHeading("start sub chain");
                for (Trace trace : call.getNested()) {
                    this.litePrint(trace);
                }
                stringBuilder.append(System.getProperty("line.separator"));
                this.printHeading("end sub chain");
            }
            this.printLine(stringBuilder.toString());
        }
        catch (IOException e) {
            log.error((Object)"Nuxeo TracePrinter cannot write traces output", (Throwable)e);
        }
    }

    private void displayOperationTreeCalls(List<Call> calls, StringBuilder stringBuilder) {
        String tabs = "\t";
        for (Call call : calls) {
            stringBuilder.append(tabs);
            stringBuilder.append(call.getType().getType().getName());
            stringBuilder.append(System.getProperty("line.separator"));
            tabs = tabs + "\t";
        }
    }
}

