/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.MBeanServerForwarder;
import com.sun.jdmk.OperationContext;
import com.sun.jdmk.ThreadContext;
import java.io.ObjectInputStream;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public abstract class MBeanServerChecker
extends MBeanServerForwarder {
    protected MBeanServerChecker(MBeanServer mbs) {
        super(mbs);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        this.checkAny("instantiate", null);
        this.checkInstantiate("instantiate", className, null, params, signature);
        return super.instantiate(className, params, signature);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        this.checkAny("instantiate", null);
        this.checkInstantiate("instantiate", className, loaderName, params, signature);
        return super.instantiate(className, loaderName, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.checkAny("createMBean", name);
        this.checkCreate("createMBean", className, name, null, params, signature);
        return super.createMBean(className, name, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkAny("createMBean", name);
        this.checkCreate("createMBean", className, name, loaderName, params, signature);
        return super.createMBean(className, name, loaderName, params, signature);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.checkAny("registerMBean", name);
        this.checkCreate("registerMBean", object == null ? null : object.getClass().getName(), name, null, null, null);
        return super.registerMBean(object, name);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.checkAny("unregisterMBean", name);
        this.checkDelete("unregisterMBean", name);
        super.unregisterMBean(name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        this.checkAny("getObjectInstance", name);
        this.checkRead("getObjectInstance", name);
        return super.getObjectInstance(name);
    }

    @Override
    public Set queryMBeans(ObjectName name, QueryExp query) {
        this.checkAny("queryMBeans", name);
        this.checkQuery("queryMBeans", name, query);
        return super.queryMBeans(name, query);
    }

    @Override
    public Set queryNames(ObjectName name, QueryExp query) {
        this.checkAny("queryNames", name);
        this.checkQuery("queryNames", name, query);
        return super.queryNames(name, query);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        this.checkAny("isRegistered", name);
        this.checkRead("isRegistered", name);
        return super.isRegistered(name);
    }

    @Override
    public Integer getMBeanCount() {
        this.checkAny("getMBeanCount", null);
        this.checkRead("getMBeanCount", null);
        return super.getMBeanCount();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        this.checkAny("getAttribute", name);
        this.checkRead("getAttribute", name);
        return super.getAttribute(name, attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        this.checkAny("getAttributes", name);
        this.checkRead("getAttributes", name);
        return super.getAttributes(name, attributes);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.checkAny("setAttribute", name);
        this.checkWrite("setAttribute", name);
        super.setAttribute(name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        this.checkAny("setAttributes", name);
        this.checkWrite("setAttributes", name);
        return super.setAttributes(name, attributes);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.checkAny("invoke", name);
        this.checkInvoke("invoke", name, operationName, params, signature);
        return super.invoke(name, operationName, params, signature);
    }

    @Override
    public String getDefaultDomain() {
        this.checkAny("getDefaultDomain", null);
        this.checkRead("getDefaultDomain", null);
        return super.getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        this.checkAny("getDomains", null);
        this.checkRead("getDomains", null);
        return super.getDomains();
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.checkAny("addNotificationListener", name);
        this.checkNotification("addNotificationListener", name);
        super.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.checkAny("addNotificationListener", name);
        this.checkNotification("addNotificationListener", name);
        super.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkAny("removeNotificationListener", name);
        this.checkNotification("removeNotificationListener", name);
        super.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkAny("removeNotificationListener", name);
        this.checkNotification("removeNotificationListener", name);
        super.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkAny("removeNotificationListener", name);
        this.checkNotification("removeNotificationListener", name);
        super.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkAny("removeNotificationListener", name);
        this.checkNotification("removeNotificationListener", name);
        super.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.checkAny("getMBeanInfo", name);
        this.checkRead("getMBeanInfo", name);
        return super.getMBeanInfo(name);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        this.checkAny("isInstanceOf", name);
        this.checkRead("isInstanceOf", name);
        return super.isInstanceOf(name, className);
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        this.checkAny("deserialize", name);
        this.checkDeserialize("deserialize", name);
        return super.deserialize(name, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        this.checkAny("deserialize", null);
        this.checkDeserialize("deserialize", className);
        return super.deserialize(className, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        this.checkAny("deserialize", null);
        this.checkDeserialize("deserialize", className);
        return super.deserialize(className, loaderName, data);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        this.checkAny("getClassLoaderFor", mbeanName);
        this.checkRead("getClassLoaderFor", mbeanName);
        return super.getClassLoaderFor(mbeanName);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        this.checkAny("getClassLoader", loaderName);
        this.checkRead("getClassLoader", loaderName);
        return super.getClassLoader(loaderName);
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        this.checkAny("getClassLoaderRepository", null);
        this.checkRead("getClassLoaderRepository", null);
        return super.getClassLoaderRepository();
    }

    protected OperationContext getOperationContext() throws ClassCastException {
        Object context = ThreadContext.get("OperationContext");
        if (context instanceof OperationContext) {
            return (OperationContext)context;
        }
        return null;
    }

    protected void checkAny(String methodName, ObjectName objectName) {
    }

    protected void checkCreate(String methodName, String className, ObjectName objectName, ObjectName loaderName, Object[] params, String[] signature) {
    }

    protected void checkInstantiate(String methodName, String className, ObjectName loaderName, Object[] params, String[] signature) {
    }

    protected void checkDelete(String methodName, ObjectName objectName) {
    }

    protected void checkRead(String methodName, ObjectName objectName) {
    }

    protected void checkWrite(String methodName, ObjectName objectName) {
    }

    protected void checkQuery(String methodName, ObjectName name, QueryExp query) {
    }

    protected void checkInvoke(String methodName, ObjectName objectName, String operationName, Object[] params, String[] signature) {
    }

    protected void checkNotification(String methodName, ObjectName objectName) {
    }

    protected void checkDeserialize(String methodName, Object objectNameOrClass) {
    }
}

